/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists the Amazon Web Services Private CA SCEP connectors belonging to your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorSummary.Builder, ConnectorSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ConnectorSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(ConnectorSummary::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConnectorSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<MobileDeviceManagement> MOBILE_DEVICE_MANAGEMENT_FIELD = SdkField
            .<MobileDeviceManagement> builder(MarshallingType.SDK_POJO).memberName("MobileDeviceManagement")
            .getter(getter(ConnectorSummary::mobileDeviceManagement)).setter(setter(Builder::mobileDeviceManagement))
            .constructor(MobileDeviceManagement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceManagement").build())
            .build();

    private static final SdkField<OpenIdConfiguration> OPEN_ID_CONFIGURATION_FIELD = SdkField
            .<OpenIdConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenIdConfiguration")
            .getter(getter(ConnectorSummary::openIdConfiguration)).setter(setter(Builder::openIdConfiguration))
            .constructor(OpenIdConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ConnectorSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ConnectorSummary::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(ConnectorSummary::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ConnectorSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ConnectorSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CERTIFICATE_AUTHORITY_ARN_FIELD, TYPE_FIELD, MOBILE_DEVICE_MANAGEMENT_FIELD, OPEN_ID_CONFIGURATION_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, ENDPOINT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String certificateAuthorityArn;

    private final String type;

    private final MobileDeviceManagement mobileDeviceManagement;

    private final OpenIdConfiguration openIdConfiguration;

    private final String status;

    private final String statusReason;

    private final String endpoint;

    private final Instant createdAt;

    private final Instant updatedAt;

    private ConnectorSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.type = builder.type;
        this.mobileDeviceManagement = builder.mobileDeviceManagement;
        this.openIdConfiguration = builder.openIdConfiguration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.endpoint = builder.endpoint;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector's associated certificate authority.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector's associated certificate authority.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final ConnectorType type() {
        return ConnectorType.fromValue(type);
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't
     * configure <code>MobileDeviceManagement</code>, then the connector is for general-purpose use and this object is
     * empty.
     * </p>
     * 
     * @return Contains settings relevant to the mobile device management system that you chose for the connector. If
     *         you didn't configure <code>MobileDeviceManagement</code>, then the connector is for general-purpose use
     *         and this object is empty.
     */
    public final MobileDeviceManagement mobileDeviceManagement() {
        return mobileDeviceManagement;
    }

    /**
     * <p>
     * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
     * </p>
     * 
     * @return Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
     */
    public final OpenIdConfiguration openIdConfiguration() {
        return openIdConfiguration;
    }

    /**
     * <p>
     * The connector's status. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The connector's status. Status can be creating, active, deleting, or failed.
     * @see ConnectorStatus
     */
    public final ConnectorStatus status() {
        return ConnectorStatus.fromValue(status);
    }

    /**
     * <p>
     * The connector's status. Status can be creating, active, deleting, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The connector's status. Status can be creating, active, deleting, or failed.
     * @see ConnectorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about why connector creation failed, if status is <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ConnectorStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Information about why connector creation failed, if status is <code>FAILED</code>.
     * @see ConnectorStatusReason
     */
    public final ConnectorStatusReason statusReason() {
        return ConnectorStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * Information about why connector creation failed, if status is <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ConnectorStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Information about why connector creation failed, if status is <code>FAILED</code>.
     * @see ConnectorStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * The connector's HTTPS public SCEP URL.
     * </p>
     * 
     * @return The connector's HTTPS public SCEP URL.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The date and time that the challenge was created.
     * </p>
     * 
     * @return The date and time that the challenge was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the challenge was updated.
     * </p>
     * 
     * @return The date and time that the challenge was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mobileDeviceManagement());
        hashCode = 31 * hashCode + Objects.hashCode(openIdConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSummary)) {
            return false;
        }
        ConnectorSummary other = (ConnectorSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(mobileDeviceManagement(), other.mobileDeviceManagement())
                && Objects.equals(openIdConfiguration(), other.openIdConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorSummary").add("Arn", arn()).add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("Type", typeAsString()).add("MobileDeviceManagement", mobileDeviceManagement())
                .add("OpenIdConfiguration", openIdConfiguration()).add("Status", statusAsString())
                .add("StatusReason", statusReasonAsString()).add("Endpoint", endpoint()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MobileDeviceManagement":
            return Optional.ofNullable(clazz.cast(mobileDeviceManagement()));
        case "OpenIdConfiguration":
            return Optional.ofNullable(clazz.cast(openIdConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("MobileDeviceManagement", MOBILE_DEVICE_MANAGEMENT_FIELD);
        map.put("OpenIdConfiguration", OPEN_ID_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSummary, T> g) {
        return obj -> g.apply((ConnectorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector's associated certificate authority.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) of the connector's associated certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param type
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder type(String type);

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param type
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder type(ConnectorType type);

        /**
         * <p>
         * Contains settings relevant to the mobile device management system that you chose for the connector. If you
         * didn't configure <code>MobileDeviceManagement</code>, then the connector is for general-purpose use and this
         * object is empty.
         * </p>
         * 
         * @param mobileDeviceManagement
         *        Contains settings relevant to the mobile device management system that you chose for the connector. If
         *        you didn't configure <code>MobileDeviceManagement</code>, then the connector is for general-purpose
         *        use and this object is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobileDeviceManagement(MobileDeviceManagement mobileDeviceManagement);

        /**
         * <p>
         * Contains settings relevant to the mobile device management system that you chose for the connector. If you
         * didn't configure <code>MobileDeviceManagement</code>, then the connector is for general-purpose use and this
         * object is empty.
         * </p>
         * This is a convenience method that creates an instance of the {@link MobileDeviceManagement.Builder} avoiding
         * the need to create one manually via {@link MobileDeviceManagement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MobileDeviceManagement.Builder#build()} is called immediately and
         * its result is passed to {@link #mobileDeviceManagement(MobileDeviceManagement)}.
         * 
         * @param mobileDeviceManagement
         *        a consumer that will call methods on {@link MobileDeviceManagement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mobileDeviceManagement(MobileDeviceManagement)
         */
        default Builder mobileDeviceManagement(Consumer<MobileDeviceManagement.Builder> mobileDeviceManagement) {
            return mobileDeviceManagement(MobileDeviceManagement.builder().applyMutation(mobileDeviceManagement).build());
        }

        /**
         * <p>
         * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
         * </p>
         * 
         * @param openIdConfiguration
         *        Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConfiguration(OpenIdConfiguration openIdConfiguration);

        /**
         * <p>
         * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenIdConfiguration.Builder} avoiding the
         * need to create one manually via {@link OpenIdConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIdConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #openIdConfiguration(OpenIdConfiguration)}.
         * 
         * @param openIdConfiguration
         *        a consumer that will call methods on {@link OpenIdConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIdConfiguration(OpenIdConfiguration)
         */
        default Builder openIdConfiguration(Consumer<OpenIdConfiguration.Builder> openIdConfiguration) {
            return openIdConfiguration(OpenIdConfiguration.builder().applyMutation(openIdConfiguration).build());
        }

        /**
         * <p>
         * The connector's status. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        The connector's status. Status can be creating, active, deleting, or failed.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The connector's status. Status can be creating, active, deleting, or failed.
         * </p>
         * 
         * @param status
         *        The connector's status. Status can be creating, active, deleting, or failed.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(ConnectorStatus status);

        /**
         * <p>
         * Information about why connector creation failed, if status is <code>FAILED</code>.
         * </p>
         * 
         * @param statusReason
         *        Information about why connector creation failed, if status is <code>FAILED</code>.
         * @see ConnectorStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Information about why connector creation failed, if status is <code>FAILED</code>.
         * </p>
         * 
         * @param statusReason
         *        Information about why connector creation failed, if status is <code>FAILED</code>.
         * @see ConnectorStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatusReason
         */
        Builder statusReason(ConnectorStatusReason statusReason);

        /**
         * <p>
         * The connector's HTTPS public SCEP URL.
         * </p>
         * 
         * @param endpoint
         *        The connector's HTTPS public SCEP URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The date and time that the challenge was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the challenge was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the challenge was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the challenge was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String certificateAuthorityArn;

        private String type;

        private MobileDeviceManagement mobileDeviceManagement;

        private OpenIdConfiguration openIdConfiguration;

        private String status;

        private String statusReason;

        private String endpoint;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSummary model) {
            arn(model.arn);
            certificateAuthorityArn(model.certificateAuthorityArn);
            type(model.type);
            mobileDeviceManagement(model.mobileDeviceManagement);
            openIdConfiguration(model.openIdConfiguration);
            status(model.status);
            statusReason(model.statusReason);
            endpoint(model.endpoint);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MobileDeviceManagement.Builder getMobileDeviceManagement() {
            return mobileDeviceManagement != null ? mobileDeviceManagement.toBuilder() : null;
        }

        public final void setMobileDeviceManagement(MobileDeviceManagement.BuilderImpl mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement != null ? mobileDeviceManagement.build() : null;
        }

        @Override
        public final Builder mobileDeviceManagement(MobileDeviceManagement mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement;
            return this;
        }

        public final OpenIdConfiguration.Builder getOpenIdConfiguration() {
            return openIdConfiguration != null ? openIdConfiguration.toBuilder() : null;
        }

        public final void setOpenIdConfiguration(OpenIdConfiguration.BuilderImpl openIdConfiguration) {
            this.openIdConfiguration = openIdConfiguration != null ? openIdConfiguration.build() : null;
        }

        @Override
        public final Builder openIdConfiguration(OpenIdConfiguration openIdConfiguration) {
            this.openIdConfiguration = openIdConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ConnectorStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ConnectorSummary build() {
            return new ConnectorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
