/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pcaconnectorscep.model.CreateChallengeRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.CreateChallengeResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.CreateConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.CreateConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.DeleteChallengeRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.DeleteChallengeResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengeMetadataRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengeMetadataResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengePasswordRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengePasswordResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.GetConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.TagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.TagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorscep.model.UntagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.UntagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorscep.paginators.ListChallengeMetadataPublisher;
import software.amazon.awssdk.services.pcaconnectorscep.paginators.ListConnectorsPublisher;

/**
 * Service client for accessing Private CA Connector for SCEP asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Connector for SCEP creates a connector between Amazon Web Services Private CA and your SCEP-enabled clients and
 * devices. For more information, see <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep.html">Connector
 * for SCEP</a> in the <i>Amazon Web Services Private CA User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PcaConnectorScepAsyncClient extends AwsClient {
    String SERVICE_NAME = "pca-connector-scep";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "pca-connector-scep";

    /**
     * <p>
     * For general-purpose connectors. Creates a <i>challenge password</i> for the specified connector. The SCEP
     * protocol uses a challenge password to authenticate a request before issuing a certificate from a certificate
     * authority (CA). Your SCEP clients include the challenge password as part of their certificate request to
     * Connector for SCEP. To retrieve the connector Amazon Resource Names (ARNs) for the connectors in your account,
     * call <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_ListConnectors.html"
     * >ListConnectors</a>.
     * </p>
     * <p>
     * To create additional challenge passwords for the connector, call <code>CreateChallenge</code> again. We recommend
     * frequently rotating your challenge passwords.
     * </p>
     *
     * @param createChallengeRequest
     * @return A Java Future containing the result of the CreateChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>BadRequestException The request is malformed or contains an error such as an invalid parameter value
     *         or a missing required parameter.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.CreateChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChallengeResponse> createChallenge(CreateChallengeRequest createChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For general-purpose connectors. Creates a <i>challenge password</i> for the specified connector. The SCEP
     * protocol uses a challenge password to authenticate a request before issuing a certificate from a certificate
     * authority (CA). Your SCEP clients include the challenge password as part of their certificate request to
     * Connector for SCEP. To retrieve the connector Amazon Resource Names (ARNs) for the connectors in your account,
     * call <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_ListConnectors.html"
     * >ListConnectors</a>.
     * </p>
     * <p>
     * To create additional challenge passwords for the connector, call <code>CreateChallenge</code> again. We recommend
     * frequently rotating your challenge passwords.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChallengeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateChallengeRequest#builder()}
     * </p>
     *
     * @param createChallengeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.CreateChallengeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>BadRequestException The request is malformed or contains an error such as an invalid parameter value
     *         or a missing required parameter.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.CreateChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChallengeResponse> createChallenge(
            Consumer<CreateChallengeRequest.Builder> createChallengeRequest) {
        return createChallenge(CreateChallengeRequest.builder().applyMutation(createChallengeRequest).build());
    }

    /**
     * <p>
     * Creates a SCEP connector. A SCEP connector links Amazon Web Services Private Certificate Authority to your
     * SCEP-compatible devices and mobile device management (MDM) systems. Before you create a connector, you must
     * complete a set of prerequisites, including creation of a private certificate authority (CA) to use with this
     * connector. For more information, see <a href=
     * "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-prerequisites.html"
     * >Connector for SCEP prerequisites</a>.
     * </p>
     *
     * @param createConnectorRequest
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(CreateConnectorRequest createConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SCEP connector. A SCEP connector links Amazon Web Services Private Certificate Authority to your
     * SCEP-compatible devices and mobile device management (MDM) systems. Before you create a connector, you must
     * complete a set of prerequisites, including creation of a private certificate authority (CA) to use with this
     * connector. For more information, see <a href=
     * "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-prerequisites.html"
     * >Connector for SCEP prerequisites</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.CreateConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(
            Consumer<CreateConnectorRequest.Builder> createConnectorRequest) {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     *
     * @param deleteChallengeRequest
     * @return A Java Future containing the result of the DeleteChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.DeleteChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChallengeResponse> deleteChallenge(DeleteChallengeRequest deleteChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChallengeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteChallengeRequest#builder()}
     * </p>
     *
     * @param deleteChallengeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.DeleteChallengeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.DeleteChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChallengeResponse> deleteChallenge(
            Consumer<DeleteChallengeRequest.Builder> deleteChallengeRequest) {
        return deleteChallenge(DeleteChallengeRequest.builder().applyMutation(deleteChallengeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html"
     * >Connector</a>. This operation also deletes any challenges associated with the connector.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html"
     * >Connector</a>. This operation also deletes any challenges associated with the connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.DeleteConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>ConflictException This request can't be completed for one of the following reasons because the
     *         requested resource was being concurrently modified by another request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(
            Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest) {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     *
     * @param getChallengeMetadataRequest
     * @return A Java Future containing the result of the GetChallengeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChallengeMetadataResponse> getChallengeMetadata(
            GetChallengeMetadataRequest getChallengeMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChallengeMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetChallengeMetadataRequest#builder()}
     * </p>
     *
     * @param getChallengeMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengeMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetChallengeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChallengeMetadataResponse> getChallengeMetadata(
            Consumer<GetChallengeMetadataRequest.Builder> getChallengeMetadataRequest) {
        return getChallengeMetadata(GetChallengeMetadataRequest.builder().applyMutation(getChallengeMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves the challenge password for the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     *
     * @param getChallengePasswordRequest
     * @return A Java Future containing the result of the GetChallengePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetChallengePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengePassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChallengePasswordResponse> getChallengePassword(
            GetChallengePasswordRequest getChallengePasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the challenge password for the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html"
     * >Challenge</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChallengePasswordRequest.Builder} avoiding the
     * need to create one manually via {@link GetChallengePasswordRequest#builder()}
     * </p>
     *
     * @param getChallengePasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.GetChallengePasswordRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetChallengePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetChallengePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengePassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChallengePasswordResponse> getChallengePassword(
            Consumer<GetChallengePasswordRequest.Builder> getChallengePasswordRequest) {
        return getChallengePassword(GetChallengePasswordRequest.builder().applyMutation(getChallengePasswordRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html"
     * >Connector</a>. Calling this action returns important details about the connector, such as the public SCEP URL
     * where your clients can request certificates.
     * </p>
     *
     * @param getConnectorRequest
     * @return A Java Future containing the result of the GetConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorResponse> getConnector(GetConnectorRequest getConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the specified <a
     * href="https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html"
     * >Connector</a>. Calling this action returns important details about the connector, such as the public SCEP URL
     * where your clients can request certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectorRequest#builder()}
     * </p>
     *
     * @param getConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.GetConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.GetConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorResponse> getConnector(Consumer<GetConnectorRequest.Builder> getConnectorRequest) {
        return getConnector(GetConnectorRequest.builder().applyMutation(getConnectorRequest).build());
    }

    /**
     * <p>
     * Retrieves the challenge metadata for the specified ARN.
     * </p>
     *
     * @param listChallengeMetadataRequest
     * @return A Java Future containing the result of the ListChallengeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChallengeMetadataResponse> listChallengeMetadata(
            ListChallengeMetadataRequest listChallengeMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the challenge metadata for the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChallengeMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link ListChallengeMetadataRequest#builder()}
     * </p>
     *
     * @param listChallengeMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListChallengeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChallengeMetadataResponse> listChallengeMetadata(
            Consumer<ListChallengeMetadataRequest.Builder> listChallengeMetadataRequest) {
        return listChallengeMetadata(ListChallengeMetadataRequest.builder().applyMutation(listChallengeMetadataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChallengeMetadata(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListChallengeMetadataPublisher publisher = client.listChallengeMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListChallengeMetadataPublisher publisher = client.listChallengeMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChallengeMetadata(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChallengeMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChallengeMetadataPublisher listChallengeMetadataPaginator(
            ListChallengeMetadataRequest listChallengeMetadataRequest) {
        return new ListChallengeMetadataPublisher(this, listChallengeMetadataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChallengeMetadata(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListChallengeMetadataPublisher publisher = client.listChallengeMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListChallengeMetadataPublisher publisher = client.listChallengeMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChallengeMetadata(software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChallengeMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link ListChallengeMetadataRequest#builder()}
     * </p>
     *
     * @param listChallengeMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListChallengeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChallengeMetadataPublisher listChallengeMetadataPaginator(
            Consumer<ListChallengeMetadataRequest.Builder> listChallengeMetadataRequest) {
        return listChallengeMetadataPaginator(ListChallengeMetadataRequest.builder().applyMutation(listChallengeMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Lists the connectors belonging to your Amazon Web Services account.
     * </p>
     *
     * @param listConnectorsRequest
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(ListConnectorsRequest listConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connectors belonging to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) {
        return new ListConnectorsPublisher(this, listConnectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcaconnectorscep.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ListConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key-value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key-value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to your resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to your resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from your resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from your resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent resource. The resource might be
     *         incorrectly specified, or it might have a status other than <code>ACTIVE</code>.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure with an internal server.</li>
     *         <li>ValidationException An input validation error occurred. For example, invalid characters in a name
     *         tag, or an invalid pagination token.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>AccessDeniedException You can receive this error if you attempt to perform an operation and you don't
     *         have the required permissions. This can be caused by insufficient permissions in policies attached to
     *         your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of
     *         restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects
     *         your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcaConnectorScepException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PcaConnectorScepAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default PcaConnectorScepServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PcaConnectorScepAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PcaConnectorScepAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PcaConnectorScepAsyncClient}.
     */
    static PcaConnectorScepAsyncClientBuilder builder() {
        return new DefaultPcaConnectorScepAsyncClientBuilder();
    }
}
