/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If you don't supply a value, by default Connector for SCEP creates a connector for general-purpose use. A
 * general-purpose connector is designed to work with clients or endpoints that support the SCEP protocol, except
 * Connector for SCEP for Microsoft Intune. For information about considerations and limitations with using Connector
 * for SCEP, see <a href=
 * "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlc4scep-considerations-limitations.html"
 * >Considerations and Limitations</a>.
 * </p>
 * <p>
 * If you provide an <code>IntuneConfiguration</code>, Connector for SCEP creates a connector for use with Microsoft
 * Intune, and you manage the challenge passwords using Microsoft Intune. For more information, see <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html">Using
 * Connector for SCEP for Microsoft Intune</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MobileDeviceManagement implements SdkPojo, Serializable,
        ToCopyableBuilder<MobileDeviceManagement.Builder, MobileDeviceManagement> {
    private static final SdkField<IntuneConfiguration> INTUNE_FIELD = SdkField
            .<IntuneConfiguration> builder(MarshallingType.SDK_POJO).memberName("Intune")
            .getter(getter(MobileDeviceManagement::intune)).setter(setter(Builder::intune))
            .constructor(IntuneConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intune").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTUNE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IntuneConfiguration intune;

    private final Type type;

    private MobileDeviceManagement(BuilderImpl builder) {
        this.intune = builder.intune;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     * Microsoft Intune, see <a
     * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     * >Using Connector for SCEP for Microsoft Intune</a>.
     * </p>
     * 
     * @return Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     *         Microsoft Intune, see <a href=
     *         "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     *         >Using Connector for SCEP for Microsoft Intune</a>.
     */
    public final IntuneConfiguration intune() {
        return intune;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intune());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileDeviceManagement)) {
            return false;
        }
        MobileDeviceManagement other = (MobileDeviceManagement) obj;
        return Objects.equals(intune(), other.intune());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MobileDeviceManagement").add("Intune", intune()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Intune":
            return Optional.ofNullable(clazz.cast(intune()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #intune()} initialized to the given value.
     *
     * <p>
     * Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     * Microsoft Intune, see <a
     * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     * >Using Connector for SCEP for Microsoft Intune</a>.
     * </p>
     * 
     * @param intune
     *        Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     *        Microsoft Intune, see <a href=
     *        "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     *        >Using Connector for SCEP for Microsoft Intune</a>.
     */
    public static MobileDeviceManagement fromIntune(IntuneConfiguration intune) {
        return builder().intune(intune).build();
    }

    /**
     * Create an instance of this class with {@link #intune()} initialized to the given value.
     *
     * <p>
     * Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     * Microsoft Intune, see <a
     * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     * >Using Connector for SCEP for Microsoft Intune</a>.
     * </p>
     * 
     * @param intune
     *        Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
     *        Microsoft Intune, see <a href=
     *        "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
     *        >Using Connector for SCEP for Microsoft Intune</a>.
     */
    public static MobileDeviceManagement fromIntune(Consumer<IntuneConfiguration.Builder> intune) {
        IntuneConfiguration.Builder builder = IntuneConfiguration.builder();
        intune.accept(builder);
        return fromIntune(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Intune", INTUNE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MobileDeviceManagement, T> g) {
        return obj -> g.apply((MobileDeviceManagement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MobileDeviceManagement> {
        /**
         * <p>
         * Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
         * Microsoft Intune, see <a href=
         * "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
         * >Using Connector for SCEP for Microsoft Intune</a>.
         * </p>
         * 
         * @param intune
         *        Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP
         *        for Microsoft Intune, see <a href=
         *        "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
         *        >Using Connector for SCEP for Microsoft Intune</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intune(IntuneConfiguration intune);

        /**
         * <p>
         * Configuration settings for use with Microsoft Intune. For information about using Connector for SCEP for
         * Microsoft Intune, see <a href=
         * "https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html"
         * >Using Connector for SCEP for Microsoft Intune</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntuneConfiguration.Builder} avoiding the
         * need to create one manually via {@link IntuneConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntuneConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #intune(IntuneConfiguration)}.
         * 
         * @param intune
         *        a consumer that will call methods on {@link IntuneConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intune(IntuneConfiguration)
         */
        default Builder intune(Consumer<IntuneConfiguration.Builder> intune) {
            return intune(IntuneConfiguration.builder().applyMutation(intune).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IntuneConfiguration intune;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MobileDeviceManagement model) {
            intune(model.intune);
        }

        public final IntuneConfiguration.Builder getIntune() {
            return intune != null ? intune.toBuilder() : null;
        }

        public final void setIntune(IntuneConfiguration.BuilderImpl intune) {
            Object oldValue = this.intune;
            this.intune = intune != null ? intune.build() : null;
            handleUnionValueChange(Type.INTUNE, oldValue, this.intune);
        }

        @Override
        public final Builder intune(IntuneConfiguration intune) {
            Object oldValue = this.intune;
            this.intune = intune;
            handleUnionValueChange(Type.INTUNE, oldValue, this.intune);
            return this;
        }

        @Override
        public MobileDeviceManagement build() {
            return new MobileDeviceManagement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MobileDeviceManagement#type()
     */
    public enum Type {
        INTUNE,

        UNKNOWN_TO_SDK_VERSION
    }
}
