/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for use with Microsoft Intune. For information about using Connector for SCEP for
 * Microsoft Intune, see <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html">Using
 * Connector for SCEP for Microsoft Intune</a>.
 * </p>
 * <p>
 * When you use Connector for SCEP for Microsoft Intune, certain functionalities are enabled by accessing Microsoft
 * Intune through the Microsoft API. Your use of the Connector for SCEP and accompanying Amazon Web Services services
 * doesn't remove your need to have a valid license for your use of the Microsoft Intune service. You should also review
 * the <a href="https://learn.microsoft.com/en-us/mem/intune/apps/app-protection-policy">Microsoft Intune® App
 * Protection Policies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntuneConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IntuneConfiguration.Builder, IntuneConfiguration> {
    private static final SdkField<String> AZURE_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AzureApplicationId").getter(getter(IntuneConfiguration::azureApplicationId))
            .setter(setter(Builder::azureApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AzureApplicationId").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(IntuneConfiguration::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZURE_APPLICATION_ID_FIELD,
            DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String azureApplicationId;

    private final String domain;

    private IntuneConfiguration(BuilderImpl builder) {
        this.azureApplicationId = builder.azureApplicationId;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The directory (tenant) ID from your Microsoft Entra ID app registration.
     * </p>
     * 
     * @return The directory (tenant) ID from your Microsoft Entra ID app registration.
     */
    public final String azureApplicationId() {
        return azureApplicationId;
    }

    /**
     * <p>
     * The primary domain from your Microsoft Entra ID app registration.
     * </p>
     * 
     * @return The primary domain from your Microsoft Entra ID app registration.
     */
    public final String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(azureApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntuneConfiguration)) {
            return false;
        }
        IntuneConfiguration other = (IntuneConfiguration) obj;
        return Objects.equals(azureApplicationId(), other.azureApplicationId()) && Objects.equals(domain(), other.domain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntuneConfiguration").add("AzureApplicationId", azureApplicationId()).add("Domain", domain())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AzureApplicationId":
            return Optional.ofNullable(clazz.cast(azureApplicationId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AzureApplicationId", AZURE_APPLICATION_ID_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntuneConfiguration, T> g) {
        return obj -> g.apply((IntuneConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntuneConfiguration> {
        /**
         * <p>
         * The directory (tenant) ID from your Microsoft Entra ID app registration.
         * </p>
         * 
         * @param azureApplicationId
         *        The directory (tenant) ID from your Microsoft Entra ID app registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azureApplicationId(String azureApplicationId);

        /**
         * <p>
         * The primary domain from your Microsoft Entra ID app registration.
         * </p>
         * 
         * @param domain
         *        The primary domain from your Microsoft Entra ID app registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);
    }

    static final class BuilderImpl implements Builder {
        private String azureApplicationId;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(IntuneConfiguration model) {
            azureApplicationId(model.azureApplicationId);
            domain(model.domain);
        }

        public final String getAzureApplicationId() {
            return azureApplicationId;
        }

        public final void setAzureApplicationId(String azureApplicationId) {
            this.azureApplicationId = azureApplicationId;
        }

        @Override
        public final Builder azureApplicationId(String azureApplicationId) {
            this.azureApplicationId = azureApplicationId;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public IntuneConfiguration build() {
            return new IntuneConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
