/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChallengeMetadataResponse extends PcaConnectorScepResponse implements
        ToCopyableBuilder<GetChallengeMetadataResponse.Builder, GetChallengeMetadataResponse> {
    private static final SdkField<ChallengeMetadata> CHALLENGE_METADATA_FIELD = SdkField
            .<ChallengeMetadata> builder(MarshallingType.SDK_POJO).memberName("ChallengeMetadata")
            .getter(getter(GetChallengeMetadataResponse::challengeMetadata)).setter(setter(Builder::challengeMetadata))
            .constructor(ChallengeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChallengeMetadata challengeMetadata;

    private GetChallengeMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.challengeMetadata = builder.challengeMetadata;
    }

    /**
     * <p>
     * The metadata for the challenge.
     * </p>
     * 
     * @return The metadata for the challenge.
     */
    public final ChallengeMetadata challengeMetadata() {
        return challengeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(challengeMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChallengeMetadataResponse)) {
            return false;
        }
        GetChallengeMetadataResponse other = (GetChallengeMetadataResponse) obj;
        return Objects.equals(challengeMetadata(), other.challengeMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChallengeMetadataResponse").add("ChallengeMetadata", challengeMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeMetadata":
            return Optional.ofNullable(clazz.cast(challengeMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChallengeMetadata", CHALLENGE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChallengeMetadataResponse, T> g) {
        return obj -> g.apply((GetChallengeMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcaConnectorScepResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetChallengeMetadataResponse> {
        /**
         * <p>
         * The metadata for the challenge.
         * </p>
         * 
         * @param challengeMetadata
         *        The metadata for the challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeMetadata(ChallengeMetadata challengeMetadata);

        /**
         * <p>
         * The metadata for the challenge.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChallengeMetadata.Builder} avoiding the
         * need to create one manually via {@link ChallengeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChallengeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #challengeMetadata(ChallengeMetadata)}.
         * 
         * @param challengeMetadata
         *        a consumer that will call methods on {@link ChallengeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challengeMetadata(ChallengeMetadata)
         */
        default Builder challengeMetadata(Consumer<ChallengeMetadata.Builder> challengeMetadata) {
            return challengeMetadata(ChallengeMetadata.builder().applyMutation(challengeMetadata).build());
        }
    }

    static final class BuilderImpl extends PcaConnectorScepResponse.BuilderImpl implements Builder {
        private ChallengeMetadata challengeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChallengeMetadataResponse model) {
            super(model);
            challengeMetadata(model.challengeMetadata);
        }

        public final ChallengeMetadata.Builder getChallengeMetadata() {
            return challengeMetadata != null ? challengeMetadata.toBuilder() : null;
        }

        public final void setChallengeMetadata(ChallengeMetadata.BuilderImpl challengeMetadata) {
            this.challengeMetadata = challengeMetadata != null ? challengeMetadata.build() : null;
        }

        @Override
        public final Builder challengeMetadata(ChallengeMetadata challengeMetadata) {
            this.challengeMetadata = challengeMetadata;
            return this;
        }

        @Override
        public GetChallengeMetadataResponse build() {
            return new GetChallengeMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
