/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcaconnectorscep.model.MobileDeviceManagement;
import software.amazon.awssdk.services.pcaconnectorscep.model.PcaConnectorScepRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorRequest
extends PcaConnectorScepRequest
implements ToCopyableBuilder<Builder, CreateConnectorRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(CreateConnectorRequest.getter(CreateConnectorRequest::certificateAuthorityArn)).setter(CreateConnectorRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<MobileDeviceManagement> MOBILE_DEVICE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MobileDeviceManagement").getter(CreateConnectorRequest.getter(CreateConnectorRequest::mobileDeviceManagement)).setter(CreateConnectorRequest.setter(Builder::mobileDeviceManagement)).constructor(MobileDeviceManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceManagement").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateConnectorRequest.getter(CreateConnectorRequest::clientToken)).setter(CreateConnectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateConnectorRequest.getter(CreateConnectorRequest::tags)).setter(CreateConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, MOBILE_DEVICE_MANAGEMENT_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorRequest.memberNameToFieldInitializer();
    private final String certificateAuthorityArn;
    private final MobileDeviceManagement mobileDeviceManagement;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.mobileDeviceManagement = builder.mobileDeviceManagement;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final MobileDeviceManagement mobileDeviceManagement() {
        return this.mobileDeviceManagement;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mobileDeviceManagement());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.mobileDeviceManagement(), other.mobileDeviceManagement()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("MobileDeviceManagement", (Object)this.mobileDeviceManagement()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "MobileDeviceManagement": {
                return Optional.ofNullable(clazz.cast(this.mobileDeviceManagement()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("MobileDeviceManagement", MOBILE_DEVICE_MANAGEMENT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorScepRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private MobileDeviceManagement mobileDeviceManagement;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.mobileDeviceManagement(model.mobileDeviceManagement);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final MobileDeviceManagement.Builder getMobileDeviceManagement() {
            return this.mobileDeviceManagement != null ? this.mobileDeviceManagement.toBuilder() : null;
        }

        public final void setMobileDeviceManagement(MobileDeviceManagement.BuilderImpl mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement != null ? mobileDeviceManagement.build() : null;
        }

        @Override
        public final Builder mobileDeviceManagement(MobileDeviceManagement mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcaConnectorScepRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder mobileDeviceManagement(MobileDeviceManagement var1);

        default public Builder mobileDeviceManagement(Consumer<MobileDeviceManagement.Builder> mobileDeviceManagement) {
            return this.mobileDeviceManagement((MobileDeviceManagement)((MobileDeviceManagement.Builder)MobileDeviceManagement.builder().applyMutation(mobileDeviceManagement)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

