/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the boundaries of the compute node group auto scaling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfigurationRequest.Builder, ScalingConfigurationRequest> {
    private static final SdkField<Integer> MIN_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minInstanceCount").getter(getter(ScalingConfigurationRequest::minInstanceCount))
            .setter(setter(Builder::minInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minInstanceCount").build()).build();

    private static final SdkField<Integer> MAX_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxInstanceCount").getter(getter(ScalingConfigurationRequest::maxInstanceCount))
            .setter(setter(Builder::maxInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxInstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_INSTANCE_COUNT_FIELD,
            MAX_INSTANCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minInstanceCount;

    private final Integer maxInstanceCount;

    private ScalingConfigurationRequest(BuilderImpl builder) {
        this.minInstanceCount = builder.minInstanceCount;
        this.maxInstanceCount = builder.maxInstanceCount;
    }

    /**
     * <p>
     * The lower bound of the number of instances allowed in the compute fleet.
     * </p>
     * 
     * @return The lower bound of the number of instances allowed in the compute fleet.
     */
    public final Integer minInstanceCount() {
        return minInstanceCount;
    }

    /**
     * <p>
     * The upper bound of the number of instances allowed in the compute fleet.
     * </p>
     * 
     * @return The upper bound of the number of instances allowed in the compute fleet.
     */
    public final Integer maxInstanceCount() {
        return maxInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationRequest)) {
            return false;
        }
        ScalingConfigurationRequest other = (ScalingConfigurationRequest) obj;
        return Objects.equals(minInstanceCount(), other.minInstanceCount())
                && Objects.equals(maxInstanceCount(), other.maxInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingConfigurationRequest").add("MinInstanceCount", minInstanceCount())
                .add("MaxInstanceCount", maxInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minInstanceCount":
            return Optional.ofNullable(clazz.cast(minInstanceCount()));
        case "maxInstanceCount":
            return Optional.ofNullable(clazz.cast(maxInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationRequest, T> g) {
        return obj -> g.apply((ScalingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfigurationRequest> {
        /**
         * <p>
         * The lower bound of the number of instances allowed in the compute fleet.
         * </p>
         * 
         * @param minInstanceCount
         *        The lower bound of the number of instances allowed in the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInstanceCount(Integer minInstanceCount);

        /**
         * <p>
         * The upper bound of the number of instances allowed in the compute fleet.
         * </p>
         * 
         * @param maxInstanceCount
         *        The upper bound of the number of instances allowed in the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceCount(Integer maxInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer minInstanceCount;

        private Integer maxInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationRequest model) {
            minInstanceCount(model.minInstanceCount);
            maxInstanceCount(model.maxInstanceCount);
        }

        public final Integer getMinInstanceCount() {
            return minInstanceCount;
        }

        public final void setMinInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
        }

        @Override
        public final Builder minInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
            return this;
        }

        public final Integer getMaxInstanceCount() {
            return maxInstanceCount;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        @Override
        public ScalingConfigurationRequest build() {
            return new ScalingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
