/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputeNodeGroupRequest extends PcsRequest implements
        ToCopyableBuilder<CreateComputeNodeGroupRequest.Builder, CreateComputeNodeGroupRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(CreateComputeNodeGroupRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final SdkField<String> COMPUTE_NODE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeNodeGroupName").getter(getter(CreateComputeNodeGroupRequest::computeNodeGroupName))
            .setter(setter(Builder::computeNodeGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupName").build())
            .build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("amiId")
            .getter(getter(CreateComputeNodeGroupRequest::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(CreateComputeNodeGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PURCHASE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("purchaseOption").getter(getter(CreateComputeNodeGroupRequest::purchaseOptionAsString))
            .setter(setter(Builder::purchaseOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseOption").build()).build();

    private static final SdkField<CustomLaunchTemplate> CUSTOM_LAUNCH_TEMPLATE_FIELD = SdkField
            .<CustomLaunchTemplate> builder(MarshallingType.SDK_POJO).memberName("customLaunchTemplate")
            .getter(getter(CreateComputeNodeGroupRequest::customLaunchTemplate)).setter(setter(Builder::customLaunchTemplate))
            .constructor(CustomLaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLaunchTemplate").build())
            .build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamInstanceProfileArn").getter(getter(CreateComputeNodeGroupRequest::iamInstanceProfileArn))
            .setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build())
            .build();

    private static final SdkField<ScalingConfigurationRequest> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("scalingConfiguration")
            .getter(getter(CreateComputeNodeGroupRequest::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build())
            .build();

    private static final SdkField<List<InstanceConfig>> INSTANCE_CONFIGS_FIELD = SdkField
            .<List<InstanceConfig>> builder(MarshallingType.LIST)
            .memberName("instanceConfigs")
            .getter(getter(CreateComputeNodeGroupRequest::instanceConfigs))
            .setter(setter(Builder::instanceConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.<SpotOptions> builder(MarshallingType.SDK_POJO)
            .memberName("spotOptions").getter(getter(CreateComputeNodeGroupRequest::spotOptions))
            .setter(setter(Builder::spotOptions)).constructor(SpotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotOptions").build()).build();

    private static final SdkField<ComputeNodeGroupSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField
            .<ComputeNodeGroupSlurmConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(CreateComputeNodeGroupRequest::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(ComputeNodeGroupSlurmConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateComputeNodeGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateComputeNodeGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            COMPUTE_NODE_GROUP_NAME_FIELD, AMI_ID_FIELD, SUBNET_IDS_FIELD, PURCHASE_OPTION_FIELD, CUSTOM_LAUNCH_TEMPLATE_FIELD,
            IAM_INSTANCE_PROFILE_ARN_FIELD, SCALING_CONFIGURATION_FIELD, INSTANCE_CONFIGS_FIELD, SPOT_OPTIONS_FIELD,
            SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String clusterIdentifier;

    private final String computeNodeGroupName;

    private final String amiId;

    private final List<String> subnetIds;

    private final String purchaseOption;

    private final CustomLaunchTemplate customLaunchTemplate;

    private final String iamInstanceProfileArn;

    private final ScalingConfigurationRequest scalingConfiguration;

    private final List<InstanceConfig> instanceConfigs;

    private final SpotOptions spotOptions;

    private final ComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateComputeNodeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.computeNodeGroupName = builder.computeNodeGroupName;
        this.amiId = builder.amiId;
        this.subnetIds = builder.subnetIds;
        this.purchaseOption = builder.purchaseOption;
        this.customLaunchTemplate = builder.customLaunchTemplate;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.instanceConfigs = builder.instanceConfigs;
        this.spotOptions = builder.spotOptions;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name or ID of the cluster to create a compute node group in.
     * </p>
     * 
     * @return The name or ID of the cluster to create a compute node group in.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * A name to identify the cluster. Example: <code>MyCluster</code>
     * </p>
     * 
     * @return A name to identify the cluster. Example: <code>MyCluster</code>
     */
    public final String computeNodeGroupName() {
        return computeNodeGroupName;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch compute nodes (Amazon EC2
     * instances). If you don't provide this value, Amazon Web Services PCS uses the AMI ID specified in the custom
     * launch template.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch compute nodes
     *         (Amazon EC2 instances). If you don't provide this value, Amazon Web Services PCS uses the AMI ID
     *         specified in the custom launch template.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of subnet IDs where the compute node group launches instances. Subnets must be in the same VPC as the
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of subnet IDs where the compute node group launches instances. Subnets must be in the same VPC
     *         as the cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
     * instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing
     * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults
     * to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and
     *         Spot instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
     *         purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
     *         option, it defaults to On-Demand.
     * @see PurchaseOption
     */
    public final PurchaseOption purchaseOption() {
        return PurchaseOption.fromValue(purchaseOption);
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
     * instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing
     * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults
     * to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and
     *         Spot instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
     *         purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
     *         option, it defaults to On-Demand.
     * @see PurchaseOption
     */
    public final String purchaseOptionAsString() {
        return purchaseOption;
    }

    /**
     * Returns the value of the CustomLaunchTemplate property for this object.
     * 
     * @return The value of the CustomLaunchTemplate property for this object.
     */
    public final CustomLaunchTemplate customLaunchTemplate() {
        return customLaunchTemplate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances.
     * The role contained in your instance profile must have the <code>pcs:RegisterComputeNodeGroupInstance</code>
     * permission. The resource identifier of the ARN must start with <code>AWSPCS</code> or it must have
     * <code>/aws-pcs/</code> in its path.
     * </p>
     * <p class="title">
     * <b>Examples</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
     *         instances. The role contained in your instance profile must have the
     *         <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must
     *         start with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.</p>
     *         <p class="title">
     *         <b>Examples</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
     *         </p>
     *         </li>
     */
    public final String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * <p>
     * Specifies the boundaries of the compute node group auto scaling.
     * </p>
     * 
     * @return Specifies the boundaries of the compute node group auto scaling.
     */
    public final ScalingConfigurationRequest scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceConfigs() {
        return instanceConfigs != null && !(instanceConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceConfigs} method.
     * </p>
     * 
     * @return A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node
     *         group.
     */
    public final List<InstanceConfig> instanceConfigs() {
        return instanceConfigs;
    }

    /**
     * Returns the value of the SpotOptions property for this object.
     * 
     * @return The value of the SpotOptions property for this object.
     */
    public final SpotOptions spotOptions() {
        return spotOptions;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final ComputeNodeGroupSlurmConfigurationRequest slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect. If you don't specify a client token, the CLI and SDK automatically
     * generate 1 for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect. If you don't specify a client token,
     *         the CLI and SDK automatically generate 1 for you.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and
     * can be an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
     *         optional and can be an empty string.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(computeNodeGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceConfigs() ? instanceConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeNodeGroupRequest)) {
            return false;
        }
        CreateComputeNodeGroupRequest other = (CreateComputeNodeGroupRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(computeNodeGroupName(), other.computeNodeGroupName()) && Objects.equals(amiId(), other.amiId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(purchaseOptionAsString(), other.purchaseOptionAsString())
                && Objects.equals(customLaunchTemplate(), other.customLaunchTemplate())
                && Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && hasInstanceConfigs() == other.hasInstanceConfigs()
                && Objects.equals(instanceConfigs(), other.instanceConfigs())
                && Objects.equals(spotOptions(), other.spotOptions())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputeNodeGroupRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ComputeNodeGroupName", computeNodeGroupName()).add("AmiId", amiId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("PurchaseOption", purchaseOptionAsString())
                .add("CustomLaunchTemplate", customLaunchTemplate()).add("IamInstanceProfileArn", iamInstanceProfileArn())
                .add("ScalingConfiguration", scalingConfiguration())
                .add("InstanceConfigs", hasInstanceConfigs() ? instanceConfigs() : null).add("SpotOptions", spotOptions())
                .add("SlurmConfiguration", slurmConfiguration()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "computeNodeGroupName":
            return Optional.ofNullable(clazz.cast(computeNodeGroupName()));
        case "amiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "purchaseOption":
            return Optional.ofNullable(clazz.cast(purchaseOptionAsString()));
        case "customLaunchTemplate":
            return Optional.ofNullable(clazz.cast(customLaunchTemplate()));
        case "iamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "scalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "instanceConfigs":
            return Optional.ofNullable(clazz.cast(instanceConfigs()));
        case "spotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeNodeGroupRequest, T> g) {
        return obj -> g.apply((CreateComputeNodeGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputeNodeGroupRequest> {
        /**
         * <p>
         * The name or ID of the cluster to create a compute node group in.
         * </p>
         * 
         * @param clusterIdentifier
         *        The name or ID of the cluster to create a compute node group in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * A name to identify the cluster. Example: <code>MyCluster</code>
         * </p>
         * 
         * @param computeNodeGroupName
         *        A name to identify the cluster. Example: <code>MyCluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupName(String computeNodeGroupName);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch compute nodes (Amazon
         * EC2 instances). If you don't provide this value, Amazon Web Services PCS uses the AMI ID specified in the
         * custom launch template.
         * </p>
         * 
         * @param amiId
         *        The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch compute nodes
         *        (Amazon EC2 instances). If you don't provide this value, Amazon Web Services PCS uses the AMI ID
         *        specified in the custom launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The list of subnet IDs where the compute node group launches instances. Subnets must be in the same VPC as
         * the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where the compute node group launches instances. Subnets must be in the same
         *        VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of subnet IDs where the compute node group launches instances. Subnets must be in the same VPC as
         * the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where the compute node group launches instances. Subnets must be in the same
         *        VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
         * instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         * purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
         * option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand
         *        and Spot instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         *        purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide
         *        this option, it defaults to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(String purchaseOption);

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
         * instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         * purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
         * option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand
         *        and Spot instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         *        purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide
         *        this option, it defaults to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(PurchaseOption purchaseOption);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * @param customLaunchTemplate
         *        The new value for the CustomLaunchTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomLaunchTemplate.Builder} avoiding
         * the need to create one manually via {@link CustomLaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLaunchTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #customLaunchTemplate(CustomLaunchTemplate)}.
         * 
         * @param customLaunchTemplate
         *        a consumer that will call methods on {@link CustomLaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLaunchTemplate(CustomLaunchTemplate)
         */
        default Builder customLaunchTemplate(Consumer<CustomLaunchTemplate.Builder> customLaunchTemplate) {
            return customLaunchTemplate(CustomLaunchTemplate.builder().applyMutation(customLaunchTemplate).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         * instances. The role contained in your instance profile must have the
         * <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must start
         * with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.
         * </p>
         * <p class="title">
         * <b>Examples</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param iamInstanceProfileArn
         *        The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         *        instances. The role contained in your instance profile must have the
         *        <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must
         *        start with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.</p>
         *        <p class="title">
         *        <b>Examples</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * <p>
         * Specifies the boundaries of the compute node group auto scaling.
         * </p>
         * 
         * @param scalingConfiguration
         *        Specifies the boundaries of the compute node group auto scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfigurationRequest scalingConfiguration);

        /**
         * <p>
         * Specifies the boundaries of the compute node group auto scaling.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ScalingConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingConfiguration(ScalingConfigurationRequest)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfigurationRequest)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfigurationRequest.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfigurationRequest.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.
         * </p>
         * 
         * @param instanceConfigs
         *        A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfigs(Collection<InstanceConfig> instanceConfigs);

        /**
         * <p>
         * A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.
         * </p>
         * 
         * @param instanceConfigs
         *        A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfigs(InstanceConfig... instanceConfigs);

        /**
         * <p>
         * A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pcs.model.InstanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfigs(List<InstanceConfig>)}.
         * 
         * @param instanceConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfigs(java.util.Collection<InstanceConfig>)
         */
        Builder instanceConfigs(Consumer<InstanceConfig.Builder>... instanceConfigs);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * @param spotOptions
         *        The new value for the SpotOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotOptions spotOptions);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SpotOptions.Builder} avoiding the need to
         * create one manually via {@link SpotOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #spotOptions(SpotOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotOptions)
         */
        default Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return spotOptions(SpotOptions.builder().applyMutation(spotOptions).build());
        }

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ComputeNodeGroupSlurmConfigurationRequest.Builder} avoiding the need to create one manually via
         * {@link ComputeNodeGroupSlurmConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeNodeGroupSlurmConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #slurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link ComputeNodeGroupSlurmConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest)
         */
        default Builder slurmConfiguration(Consumer<ComputeNodeGroupSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return slurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration)
                    .build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect. If you don't specify a client token, the CLI and SDK
         * automatically generate 1 for you.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect. If you don't specify a
         *        client token, the CLI and SDK automatically generate 1 for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional
         * and can be an empty string.
         * </p>
         * 
         * @param tags
         *        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
         *        optional and can be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcsRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String computeNodeGroupName;

        private String amiId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String purchaseOption;

        private CustomLaunchTemplate customLaunchTemplate;

        private String iamInstanceProfileArn;

        private ScalingConfigurationRequest scalingConfiguration;

        private List<InstanceConfig> instanceConfigs = DefaultSdkAutoConstructList.getInstance();

        private SpotOptions spotOptions;

        private ComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeNodeGroupRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            computeNodeGroupName(model.computeNodeGroupName);
            amiId(model.amiId);
            subnetIds(model.subnetIds);
            purchaseOption(model.purchaseOption);
            customLaunchTemplate(model.customLaunchTemplate);
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            scalingConfiguration(model.scalingConfiguration);
            instanceConfigs(model.instanceConfigs);
            spotOptions(model.spotOptions);
            slurmConfiguration(model.slurmConfiguration);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getComputeNodeGroupName() {
            return computeNodeGroupName;
        }

        public final void setComputeNodeGroupName(String computeNodeGroupName) {
            this.computeNodeGroupName = computeNodeGroupName;
        }

        @Override
        public final Builder computeNodeGroupName(String computeNodeGroupName) {
            this.computeNodeGroupName = computeNodeGroupName;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getPurchaseOption() {
            return purchaseOption;
        }

        public final void setPurchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
        }

        @Override
        public final Builder purchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        @Override
        public final Builder purchaseOption(PurchaseOption purchaseOption) {
            this.purchaseOption(purchaseOption == null ? null : purchaseOption.toString());
            return this;
        }

        public final CustomLaunchTemplate.Builder getCustomLaunchTemplate() {
            return customLaunchTemplate != null ? customLaunchTemplate.toBuilder() : null;
        }

        public final void setCustomLaunchTemplate(CustomLaunchTemplate.BuilderImpl customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate != null ? customLaunchTemplate.build() : null;
        }

        @Override
        public final Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final ScalingConfigurationRequest.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationRequest.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationRequest scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final List<InstanceConfig.Builder> getInstanceConfigs() {
            List<InstanceConfig.Builder> result = InstanceListCopier.copyToBuilder(this.instanceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceConfigs(Collection<InstanceConfig.BuilderImpl> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copyFromBuilder(instanceConfigs);
        }

        @Override
        public final Builder instanceConfigs(Collection<InstanceConfig> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copy(instanceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(InstanceConfig... instanceConfigs) {
            instanceConfigs(Arrays.asList(instanceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(Consumer<InstanceConfig.Builder>... instanceConfigs) {
            instanceConfigs(Stream.of(instanceConfigs).map(c -> InstanceConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final ComputeNodeGroupSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ComputeNodeGroupSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeNodeGroupRequest build() {
            return new CreateComputeNodeGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
