/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cluster management and job scheduling software associated with the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchedulerRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SchedulerRequest.Builder, SchedulerRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SchedulerRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(SchedulerRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String version;

    private SchedulerRequest(BuilderImpl builder) {
        this.type = builder.type;
        this.version = builder.version;
    }

    /**
     * <p>
     * The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchedulerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
     * @see SchedulerType
     */
    public final SchedulerType type() {
        return SchedulerType.fromValue(type);
    }

    /**
     * <p>
     * The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchedulerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
     * @see SchedulerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster scaling and
     * job scheduling.
     * </p>
     * 
     * @return The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster
     *         scaling and job scheduling.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulerRequest)) {
            return false;
        }
        SchedulerRequest other = (SchedulerRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchedulerRequest").add("Type", typeAsString()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchedulerRequest, T> g) {
        return obj -> g.apply((SchedulerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchedulerRequest> {
        /**
         * <p>
         * The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
         * </p>
         * 
         * @param type
         *        The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
         * @see SchedulerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerType
         */
        Builder type(String type);

        /**
         * <p>
         * The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
         * </p>
         * 
         * @param type
         *        The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.
         * @see SchedulerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerType
         */
        Builder type(SchedulerType type);

        /**
         * <p>
         * The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster scaling
         * and job scheduling.
         * </p>
         * 
         * @param version
         *        The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster
         *        scaling and job scheduling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulerRequest model) {
            type(model.type);
            version(model.version);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchedulerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public SchedulerRequest build() {
            return new SchedulerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
