/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional configuration when you specify <code>SPOT</code> as the <code>purchaseOption</code> for the
 * <code>CreateComputeNodeGroup</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotOptions implements SdkPojo, Serializable, ToCopyableBuilder<SpotOptions.Builder, SpotOptions> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allocationStrategy").getter(getter(SpotOptions::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private SpotOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
    }

    /**
     * <p>
     * The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web Services
     * PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity optimized</b>. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use allocation
     * strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to <b>price capacity
     * optimized</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link SpotAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
     *         Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity
     *         optimized</b>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use
     *         allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a>
     *         in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to
     *         <b>price capacity optimized</b>.
     * @see SpotAllocationStrategy
     */
    public final SpotAllocationStrategy allocationStrategy() {
        return SpotAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web Services
     * PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity optimized</b>. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use allocation
     * strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to <b>price capacity
     * optimized</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link SpotAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
     *         Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity
     *         optimized</b>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use
     *         allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a>
     *         in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to
     *         <b>price capacity optimized</b>.
     * @see SpotAllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptions)) {
            return false;
        }
        SpotOptions other = (SpotOptions) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotOptions").add("AllocationStrategy", allocationStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotOptions, T> g) {
        return obj -> g.apply((SpotOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotOptions> {
        /**
         * <p>
         * The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
         * Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity optimized</b>.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use allocation
         * strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to <b>price capacity
         * optimized</b>.
         * </p>
         * 
         * @param allocationStrategy
         *        The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
         *        Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity
         *        optimized</b>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use
         *        allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand
         *        capacity</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option,
         *        it defaults to <b>price capacity optimized</b>.
         * @see SpotAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
         * Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity optimized</b>.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use allocation
         * strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults to <b>price capacity
         * optimized</b>.
         * </p>
         * 
         * @param allocationStrategy
         *        The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web
         *        Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity
         *        optimized</b>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use
         *        allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand
         *        capacity</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option,
         *        it defaults to <b>price capacity optimized</b>.
         * @see SpotAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotAllocationStrategy
         */
        Builder allocationStrategy(SpotAllocationStrategy allocationStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotOptions model) {
            allocationStrategy(model.allocationStrategy);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        @Override
        public SpotOptions build() {
            return new SpotOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
