/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputeNodeGroupRequest extends PcsRequest implements
        ToCopyableBuilder<UpdateComputeNodeGroupRequest.Builder, UpdateComputeNodeGroupRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(UpdateComputeNodeGroupRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final SdkField<String> COMPUTE_NODE_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("computeNodeGroupIdentifier")
            .getter(getter(UpdateComputeNodeGroupRequest::computeNodeGroupIdentifier))
            .setter(setter(Builder::computeNodeGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupIdentifier").build())
            .build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("amiId")
            .getter(getter(UpdateComputeNodeGroupRequest::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(UpdateComputeNodeGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomLaunchTemplate> CUSTOM_LAUNCH_TEMPLATE_FIELD = SdkField
            .<CustomLaunchTemplate> builder(MarshallingType.SDK_POJO).memberName("customLaunchTemplate")
            .getter(getter(UpdateComputeNodeGroupRequest::customLaunchTemplate)).setter(setter(Builder::customLaunchTemplate))
            .constructor(CustomLaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLaunchTemplate").build())
            .build();

    private static final SdkField<String> PURCHASE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("purchaseOption").getter(getter(UpdateComputeNodeGroupRequest::purchaseOptionAsString))
            .setter(setter(Builder::purchaseOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseOption").build()).build();

    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.<SpotOptions> builder(MarshallingType.SDK_POJO)
            .memberName("spotOptions").getter(getter(UpdateComputeNodeGroupRequest::spotOptions))
            .setter(setter(Builder::spotOptions)).constructor(SpotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotOptions").build()).build();

    private static final SdkField<ScalingConfigurationRequest> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("scalingConfiguration")
            .getter(getter(UpdateComputeNodeGroupRequest::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build())
            .build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamInstanceProfileArn").getter(getter(UpdateComputeNodeGroupRequest::iamInstanceProfileArn))
            .setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build())
            .build();

    private static final SdkField<UpdateComputeNodeGroupSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField
            .<UpdateComputeNodeGroupSlurmConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(UpdateComputeNodeGroupRequest::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(UpdateComputeNodeGroupSlurmConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateComputeNodeGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            COMPUTE_NODE_GROUP_IDENTIFIER_FIELD, AMI_ID_FIELD, SUBNET_IDS_FIELD, CUSTOM_LAUNCH_TEMPLATE_FIELD,
            PURCHASE_OPTION_FIELD, SPOT_OPTIONS_FIELD, SCALING_CONFIGURATION_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD,
            SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private final String clusterIdentifier;

    private final String computeNodeGroupIdentifier;

    private final String amiId;

    private final List<String> subnetIds;

    private final CustomLaunchTemplate customLaunchTemplate;

    private final String purchaseOption;

    private final SpotOptions spotOptions;

    private final ScalingConfigurationRequest scalingConfiguration;

    private final String iamInstanceProfileArn;

    private final UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;

    private final String clientToken;

    private UpdateComputeNodeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.computeNodeGroupIdentifier = builder.computeNodeGroupIdentifier;
        this.amiId = builder.amiId;
        this.subnetIds = builder.subnetIds;
        this.customLaunchTemplate = builder.customLaunchTemplate;
        this.purchaseOption = builder.purchaseOption;
        this.spotOptions = builder.spotOptions;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name or ID of the cluster of the compute node group.
     * </p>
     * 
     * @return The name or ID of the cluster of the compute node group.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name or ID of the compute node group.
     * </p>
     * 
     * @return The name or ID of the compute node group.
     */
    public final String computeNodeGroupIdentifier() {
        return computeNodeGroupIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not provided,
     * Amazon Web Services PCS uses the AMI ID specified in the custom launch template.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not
     *         provided, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of subnet IDs where the compute node group provisions instances. The subnets must be in the same VPC as
     * the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of subnet IDs where the compute node group provisions instances. The subnets must be in the same
     *         VPC as the cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns the value of the CustomLaunchTemplate property for this object.
     * 
     * @return The value of the CustomLaunchTemplate property for this object.
     */
    public final CustomLaunchTemplate customLaunchTemplate() {
        return customLaunchTemplate;
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
     * instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing
     * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults
     * to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and
     *         Spot instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
     *         purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
     *         option, it defaults to On-Demand.
     * @see PurchaseOption
     */
    public final PurchaseOption purchaseOption() {
        return PurchaseOption.fromValue(purchaseOption);
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
     * instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing
     * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this option, it defaults
     * to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and
     *         Spot instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
     *         purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
     *         option, it defaults to On-Demand.
     * @see PurchaseOption
     */
    public final String purchaseOptionAsString() {
        return purchaseOption;
    }

    /**
     * Returns the value of the SpotOptions property for this object.
     * 
     * @return The value of the SpotOptions property for this object.
     */
    public final SpotOptions spotOptions() {
        return spotOptions;
    }

    /**
     * <p>
     * Specifies the boundaries of the compute node group auto scaling.
     * </p>
     * 
     * @return Specifies the boundaries of the compute node group auto scaling.
     */
    public final ScalingConfigurationRequest scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances.
     * The role contained in your instance profile must have the <code>pcs:RegisterComputeNodeGroupInstance</code>
     * permission. The resource identifier of the ARN must start with <code>AWSPCS</code> or it must have
     * <code>/aws-pcs/</code> in its path.
     * </p>
     * <p class="title">
     * <b>Examples</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
     *         instances. The role contained in your instance profile must have the
     *         <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must
     *         start with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.</p>
     *         <p class="title">
     *         <b>Examples</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
     *         </p>
     *         </li>
     */
    public final String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect. If you don't specify a client token, the CLI and SDK automatically
     * generate 1 for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect. If you don't specify a client token,
     *         the CLI and SDK automatically generate 1 for you.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(computeNodeGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeNodeGroupRequest)) {
            return false;
        }
        UpdateComputeNodeGroupRequest other = (UpdateComputeNodeGroupRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(computeNodeGroupIdentifier(), other.computeNodeGroupIdentifier())
                && Objects.equals(amiId(), other.amiId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(customLaunchTemplate(), other.customLaunchTemplate())
                && Objects.equals(purchaseOptionAsString(), other.purchaseOptionAsString())
                && Objects.equals(spotOptions(), other.spotOptions())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputeNodeGroupRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ComputeNodeGroupIdentifier", computeNodeGroupIdentifier()).add("AmiId", amiId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("CustomLaunchTemplate", customLaunchTemplate())
                .add("PurchaseOption", purchaseOptionAsString()).add("SpotOptions", spotOptions())
                .add("ScalingConfiguration", scalingConfiguration()).add("IamInstanceProfileArn", iamInstanceProfileArn())
                .add("SlurmConfiguration", slurmConfiguration()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "computeNodeGroupIdentifier":
            return Optional.ofNullable(clazz.cast(computeNodeGroupIdentifier()));
        case "amiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "customLaunchTemplate":
            return Optional.ofNullable(clazz.cast(customLaunchTemplate()));
        case "purchaseOption":
            return Optional.ofNullable(clazz.cast(purchaseOptionAsString()));
        case "spotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        case "scalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "iamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeNodeGroupRequest, T> g) {
        return obj -> g.apply((UpdateComputeNodeGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputeNodeGroupRequest> {
        /**
         * <p>
         * The name or ID of the cluster of the compute node group.
         * </p>
         * 
         * @param clusterIdentifier
         *        The name or ID of the cluster of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name or ID of the compute node group.
         * </p>
         * 
         * @param computeNodeGroupIdentifier
         *        The name or ID of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupIdentifier(String computeNodeGroupIdentifier);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not
         * provided, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.
         * </p>
         * 
         * @param amiId
         *        The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not
         *        provided, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The list of subnet IDs where the compute node group provisions instances. The subnets must be in the same VPC
         * as the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where the compute node group provisions instances. The subnets must be in the
         *        same VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of subnet IDs where the compute node group provisions instances. The subnets must be in the same VPC
         * as the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where the compute node group provisions instances. The subnets must be in the
         *        same VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * @param customLaunchTemplate
         *        The new value for the CustomLaunchTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomLaunchTemplate.Builder} avoiding
         * the need to create one manually via {@link CustomLaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLaunchTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #customLaunchTemplate(CustomLaunchTemplate)}.
         * 
         * @param customLaunchTemplate
         *        a consumer that will call methods on {@link CustomLaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLaunchTemplate(CustomLaunchTemplate)
         */
        default Builder customLaunchTemplate(Consumer<CustomLaunchTemplate.Builder> customLaunchTemplate) {
            return customLaunchTemplate(CustomLaunchTemplate.builder().applyMutation(customLaunchTemplate).build());
        }

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
         * instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         * purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
         * option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand
         *        and Spot instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         *        purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide
         *        this option, it defaults to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(String purchaseOption);

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot
         * instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         * purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide this
         * option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand
         *        and Spot instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance
         *        purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don't provide
         *        this option, it defaults to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(PurchaseOption purchaseOption);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * @param spotOptions
         *        The new value for the SpotOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotOptions spotOptions);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SpotOptions.Builder} avoiding the need to
         * create one manually via {@link SpotOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #spotOptions(SpotOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotOptions)
         */
        default Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return spotOptions(SpotOptions.builder().applyMutation(spotOptions).build());
        }

        /**
         * <p>
         * Specifies the boundaries of the compute node group auto scaling.
         * </p>
         * 
         * @param scalingConfiguration
         *        Specifies the boundaries of the compute node group auto scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfigurationRequest scalingConfiguration);

        /**
         * <p>
         * Specifies the boundaries of the compute node group auto scaling.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ScalingConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingConfiguration(ScalingConfigurationRequest)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfigurationRequest)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfigurationRequest.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfigurationRequest.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         * instances. The role contained in your instance profile must have the
         * <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must start
         * with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.
         * </p>
         * <p class="title">
         * <b>Examples</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param iamInstanceProfileArn
         *        The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         *        instances. The role contained in your instance profile must have the
         *        <code>pcs:RegisterComputeNodeGroupInstance</code> permission. The resource identifier of the ARN must
         *        start with <code>AWSPCS</code> or it must have <code>/aws-pcs/</code> in its path.</p>
         *        <p class="title">
         *        <b>Examples</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateComputeNodeGroupSlurmConfigurationRequest.Builder} avoiding the need to create one manually via
         * {@link UpdateComputeNodeGroupSlurmConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateComputeNodeGroupSlurmConfigurationRequest.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link UpdateComputeNodeGroupSlurmConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest)
         */
        default Builder slurmConfiguration(Consumer<UpdateComputeNodeGroupSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration)
                    .build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect. If you don't specify a client token, the CLI and SDK
         * automatically generate 1 for you.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect. If you don't specify a
         *        client token, the CLI and SDK automatically generate 1 for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcsRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String computeNodeGroupIdentifier;

        private String amiId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private CustomLaunchTemplate customLaunchTemplate;

        private String purchaseOption;

        private SpotOptions spotOptions;

        private ScalingConfigurationRequest scalingConfiguration;

        private String iamInstanceProfileArn;

        private UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeNodeGroupRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            computeNodeGroupIdentifier(model.computeNodeGroupIdentifier);
            amiId(model.amiId);
            subnetIds(model.subnetIds);
            customLaunchTemplate(model.customLaunchTemplate);
            purchaseOption(model.purchaseOption);
            spotOptions(model.spotOptions);
            scalingConfiguration(model.scalingConfiguration);
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            slurmConfiguration(model.slurmConfiguration);
            clientToken(model.clientToken);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getComputeNodeGroupIdentifier() {
            return computeNodeGroupIdentifier;
        }

        public final void setComputeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
        }

        @Override
        public final Builder computeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final CustomLaunchTemplate.Builder getCustomLaunchTemplate() {
            return customLaunchTemplate != null ? customLaunchTemplate.toBuilder() : null;
        }

        public final void setCustomLaunchTemplate(CustomLaunchTemplate.BuilderImpl customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate != null ? customLaunchTemplate.build() : null;
        }

        @Override
        public final Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        public final String getPurchaseOption() {
            return purchaseOption;
        }

        public final void setPurchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
        }

        @Override
        public final Builder purchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        @Override
        public final Builder purchaseOption(PurchaseOption purchaseOption) {
            this.purchaseOption(purchaseOption == null ? null : purchaseOption.toString());
            return this;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final ScalingConfigurationRequest.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationRequest.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationRequest scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final UpdateComputeNodeGroupSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeNodeGroupRequest build() {
            return new UpdateComputeNodeGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
