/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The shared Slurm key for authentication, also known as the <b>cluster secret</b>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlurmAuthKey implements SdkPojo, Serializable, ToCopyableBuilder<SlurmAuthKey.Builder, SlurmAuthKey> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(SlurmAuthKey::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> SECRET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretVersion").getter(getter(SlurmAuthKey::secretVersion)).setter(setter(Builder::secretVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            SECRET_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String secretVersion;

    private SlurmAuthKey(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.secretVersion = builder.secretVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the the shared Slurm key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the the shared Slurm key.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The version of the shared Slurm key.
     * </p>
     * 
     * @return The version of the shared Slurm key.
     */
    public final String secretVersion() {
        return secretVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlurmAuthKey)) {
            return false;
        }
        SlurmAuthKey other = (SlurmAuthKey) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(secretVersion(), other.secretVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlurmAuthKey").add("SecretArn", secretArn()).add("SecretVersion", secretVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "secretVersion":
            return Optional.ofNullable(clazz.cast(secretVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("secretVersion", SECRET_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlurmAuthKey, T> g) {
        return obj -> g.apply((SlurmAuthKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlurmAuthKey> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the the shared Slurm key.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the the shared Slurm key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The version of the shared Slurm key.
         * </p>
         * 
         * @param secretVersion
         *        The version of the shared Slurm key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretVersion(String secretVersion);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String secretVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SlurmAuthKey model) {
            secretArn(model.secretArn);
            secretVersion(model.secretVersion);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSecretVersion() {
            return secretVersion;
        }

        public final void setSecretVersion(String secretVersion) {
            this.secretVersion = secretVersion;
        }

        @Override
        public final Builder secretVersion(String secretVersion) {
            this.secretVersion = secretVersion;
            return this;
        }

        @Override
        public SlurmAuthKey build() {
            return new SlurmAuthKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
