/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterResponse extends PcsResponse implements
        ToCopyableBuilder<GetClusterResponse.Builder, GetClusterResponse> {
    private static final SdkField<Cluster> CLUSTER_FIELD = SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
            .memberName("cluster").getter(getter(GetClusterResponse::cluster)).setter(setter(Builder::cluster))
            .constructor(Cluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Cluster cluster;

    private GetClusterResponse(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
    }

    /**
     * <p>
     * The cluster resource.
     * </p>
     * 
     * @return The cluster resource.
     */
    public final Cluster cluster() {
        return cluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterResponse)) {
            return false;
        }
        GetClusterResponse other = (GetClusterResponse) obj;
        return Objects.equals(cluster(), other.cluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClusterResponse").add("Cluster", cluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterResponse, T> g) {
        return obj -> g.apply((GetClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClusterResponse> {
        /**
         * <p>
         * The cluster resource.
         * </p>
         * 
         * @param cluster
         *        The cluster resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(Cluster cluster);

        /**
         * <p>
         * The cluster resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cluster.Builder} avoiding the need to
         * create one manually via {@link Cluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cluster.Builder#build()} is called immediately and its result is
         * passed to {@link #cluster(Cluster)}.
         * 
         * @param cluster
         *        a consumer that will call methods on {@link Cluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cluster(Cluster)
         */
        default Builder cluster(Consumer<Cluster.Builder> cluster) {
            return cluster(Cluster.builder().applyMutation(cluster).build());
        }
    }

    static final class BuilderImpl extends PcsResponse.BuilderImpl implements Builder {
        private Cluster cluster;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterResponse model) {
            super(model);
            cluster(model.cluster);
        }

        public final Cluster.Builder getCluster() {
            return cluster != null ? cluster.toBuilder() : null;
        }

        public final void setCluster(Cluster.BuilderImpl cluster) {
            this.cluster = cluster != null ? cluster.build() : null;
        }

        @Override
        public final Builder cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        public GetClusterResponse build() {
            return new GetClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
