/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.pcs.model.ErrorInfo;
import software.amazon.awssdk.services.pcs.model.ErrorInfoListCopier;
import software.amazon.awssdk.services.pcs.model.QueueStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Queue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Queue> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Queue.getter(Queue::name)).setter(Queue.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Queue.getter(Queue::id)).setter(Queue.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Queue.getter(Queue::arn)).setter(Queue.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterId").getter(Queue.getter(Queue::clusterId)).setter(Queue.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Queue.getter(Queue::createdAt)).setter(Queue.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Queue.getter(Queue::modifiedAt)).setter(Queue.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Queue.getter(Queue::statusAsString)).setter(Queue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<ComputeNodeGroupConfiguration>> COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeNodeGroupConfigurations").getter(Queue.getter(Queue::computeNodeGroupConfigurations)).setter(Queue.setter(Builder::computeNodeGroupConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeNodeGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorInfo>> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorInfo").getter(Queue.getter(Queue::errorInfo)).setter(Queue.setter(Builder::errorInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, CLUSTER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Queue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String clusterId;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String status;
    private final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations;
    private final List<ErrorInfo> errorInfo;

    private Queue(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.clusterId = builder.clusterId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.computeNodeGroupConfigurations = builder.computeNodeGroupConfigurations;
        this.errorInfo = builder.errorInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasComputeNodeGroupConfigurations() {
        return this.computeNodeGroupConfigurations != null && !(this.computeNodeGroupConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations() {
        return this.computeNodeGroupConfigurations;
    }

    public final boolean hasErrorInfo() {
        return this.errorInfo != null && !(this.errorInfo instanceof SdkAutoConstructList);
    }

    public final List<ErrorInfo> errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeNodeGroupConfigurations() ? this.computeNodeGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorInfo() ? this.errorInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasComputeNodeGroupConfigurations() == other.hasComputeNodeGroupConfigurations() && Objects.equals(this.computeNodeGroupConfigurations(), other.computeNodeGroupConfigurations()) && this.hasErrorInfo() == other.hasErrorInfo() && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"Queue").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClusterId", (Object)this.clusterId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Status", (Object)this.statusAsString()).add("ComputeNodeGroupConfigurations", this.hasComputeNodeGroupConfigurations() ? this.computeNodeGroupConfigurations() : null).add("ErrorInfo", this.hasErrorInfo() ? this.errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "computeNodeGroupConfigurations": {
                return Optional.ofNullable(clazz.cast(this.computeNodeGroupConfigurations()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("computeNodeGroupConfigurations", COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String clusterId;
        private Instant createdAt;
        private Instant modifiedAt;
        private String status;
        private List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.clusterId(model.clusterId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.status(model.status);
            this.computeNodeGroupConfigurations(model.computeNodeGroupConfigurations);
            this.errorInfo(model.errorInfo);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ComputeNodeGroupConfiguration.Builder> getComputeNodeGroupConfigurations() {
            List<ComputeNodeGroupConfiguration.Builder> result = ComputeNodeGroupConfigurationListCopier.copyToBuilder(this.computeNodeGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration.BuilderImpl> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copyFromBuilder(computeNodeGroupConfigurations);
        }

        @Override
        public final Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copy(computeNodeGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration ... computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations(Arrays.asList(computeNodeGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder> ... computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations(Stream.of(computeNodeGroupConfigurations).map(c -> (ComputeNodeGroupConfiguration)((ComputeNodeGroupConfiguration.Builder)ComputeNodeGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorInfo.Builder> getErrorInfo() {
            List<ErrorInfo.Builder> result = ErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<ErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<ErrorInfo> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(ErrorInfo ... errorInfo) {
            this.errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<ErrorInfo.Builder> ... errorInfo) {
            this.errorInfo(Stream.of(errorInfo).map(c -> (ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Queue build() {
            return new Queue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Queue> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clusterId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> var1);

        public Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration ... var1);

        public Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder> ... var1);

        public Builder errorInfo(Collection<ErrorInfo> var1);

        public Builder errorInfo(ErrorInfo ... var1);

        public Builder errorInfo(Consumer<ErrorInfo.Builder> ... var1);
    }
}

