/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The accounting configuration includes configurable settings for Slurm accounting. It's a property of the
 * <b>ClusterSlurmConfiguration</b> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountingRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountingRequest.Builder, AccountingRequest> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(AccountingRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<Integer> DEFAULT_PURGE_TIME_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("defaultPurgeTimeInDays").getter(getter(AccountingRequest::defaultPurgeTimeInDays))
            .setter(setter(Builder::defaultPurgeTimeInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPurgeTimeInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            DEFAULT_PURGE_TIME_IN_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final Integer defaultPurgeTimeInDays;

    private AccountingRequest(BuilderImpl builder) {
        this.mode = builder.mode;
        this.defaultPurgeTimeInDays = builder.defaultPurgeTimeInDays;
    }

    /**
     * <p>
     * The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means Slurm
     * accounting is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AccountingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means
     *         Slurm accounting is enabled.
     * @see AccountingMode
     */
    public final AccountingMode mode() {
        return AccountingMode.fromValue(mode);
    }

    /**
     * <p>
     * The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means Slurm
     * accounting is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AccountingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means
     *         Slurm accounting is enabled.
     * @see AccountingMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The default value for all purge settings for <code>slurmdbd.conf</code>. For more information, see the <a
     * href="https://slurm.schedmd.com/slurmdbd.conf.html">slurmdbd.conf documentation at SchedMD</a>.
     * </p>
     * <p>
     * The default value for <code>defaultPurgeTimeInDays</code> is <code>-1</code>.
     * </p>
     * <p>
     * A value of <code>-1</code> means there is no purge time and records persist as long as the cluster exists.
     * </p>
     * <important>
     * <p>
     * <code>0</code> isn't a valid value.
     * </p>
     * </important>
     * 
     * @return The default value for all purge settings for <code>slurmdbd.conf</code>. For more information, see the <a
     *         href="https://slurm.schedmd.com/slurmdbd.conf.html">slurmdbd.conf documentation at SchedMD</a>.</p>
     *         <p>
     *         The default value for <code>defaultPurgeTimeInDays</code> is <code>-1</code>.
     *         </p>
     *         <p>
     *         A value of <code>-1</code> means there is no purge time and records persist as long as the cluster
     *         exists.
     *         </p>
     *         <important>
     *         <p>
     *         <code>0</code> isn't a valid value.
     *         </p>
     */
    public final Integer defaultPurgeTimeInDays() {
        return defaultPurgeTimeInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPurgeTimeInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountingRequest)) {
            return false;
        }
        AccountingRequest other = (AccountingRequest) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(defaultPurgeTimeInDays(), other.defaultPurgeTimeInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountingRequest").add("Mode", modeAsString())
                .add("DefaultPurgeTimeInDays", defaultPurgeTimeInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "defaultPurgeTimeInDays":
            return Optional.ofNullable(clazz.cast(defaultPurgeTimeInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mode", MODE_FIELD);
        map.put("defaultPurgeTimeInDays", DEFAULT_PURGE_TIME_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountingRequest, T> g) {
        return obj -> g.apply((AccountingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountingRequest> {
        /**
         * <p>
         * The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means
         * Slurm accounting is enabled.
         * </p>
         * 
         * @param mode
         *        The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code>
         *        means Slurm accounting is enabled.
         * @see AccountingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountingMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code> means
         * Slurm accounting is enabled.
         * </p>
         * 
         * @param mode
         *        The default value for <code>mode</code> is <code>STANDARD</code>. A value of <code>STANDARD</code>
         *        means Slurm accounting is enabled.
         * @see AccountingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountingMode
         */
        Builder mode(AccountingMode mode);

        /**
         * <p>
         * The default value for all purge settings for <code>slurmdbd.conf</code>. For more information, see the <a
         * href="https://slurm.schedmd.com/slurmdbd.conf.html">slurmdbd.conf documentation at SchedMD</a>.
         * </p>
         * <p>
         * The default value for <code>defaultPurgeTimeInDays</code> is <code>-1</code>.
         * </p>
         * <p>
         * A value of <code>-1</code> means there is no purge time and records persist as long as the cluster exists.
         * </p>
         * <important>
         * <p>
         * <code>0</code> isn't a valid value.
         * </p>
         * </important>
         * 
         * @param defaultPurgeTimeInDays
         *        The default value for all purge settings for <code>slurmdbd.conf</code>. For more information, see the
         *        <a href="https://slurm.schedmd.com/slurmdbd.conf.html">slurmdbd.conf documentation at SchedMD</a>.</p>
         *        <p>
         *        The default value for <code>defaultPurgeTimeInDays</code> is <code>-1</code>.
         *        </p>
         *        <p>
         *        A value of <code>-1</code> means there is no purge time and records persist as long as the cluster
         *        exists.
         *        </p>
         *        <important>
         *        <p>
         *        <code>0</code> isn't a valid value.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPurgeTimeInDays(Integer defaultPurgeTimeInDays);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private Integer defaultPurgeTimeInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountingRequest model) {
            mode(model.mode);
            defaultPurgeTimeInDays(model.defaultPurgeTimeInDays);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AccountingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Integer getDefaultPurgeTimeInDays() {
            return defaultPurgeTimeInDays;
        }

        public final void setDefaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
        }

        @Override
        public final Builder defaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
            return this;
        }

        @Override
        public AccountingRequest build() {
            return new AccountingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
