/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object returned by the <code>ListComputeNodeGroups</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeNodeGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeNodeGroupSummary.Builder, ComputeNodeGroupSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComputeNodeGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ComputeNodeGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ComputeNodeGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterId").getter(getter(ComputeNodeGroupSummary::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ComputeNodeGroupSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(ComputeNodeGroupSummary::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ComputeNodeGroupSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, CLUSTER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final String clusterId;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String status;

    private ComputeNodeGroupSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.clusterId = builder.clusterId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name that identifies the compute node group.
     * </p>
     * 
     * @return The name that identifies the compute node group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The generated unique ID of the compute node group.
     * </p>
     * 
     * @return The generated unique ID of the compute node group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the compute node group.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the compute node group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the cluster of the compute node group.
     * </p>
     * 
     * @return The ID of the cluster of the compute node group.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the resource was modified.
     * </p>
     * 
     * @return The date and time the resource was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The provisioning status of the compute node group.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the compute node group.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComputeNodeGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the compute node group.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the compute node group.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see ComputeNodeGroupStatus
     */
    public final ComputeNodeGroupStatus status() {
        return ComputeNodeGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The provisioning status of the compute node group.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the compute node group.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComputeNodeGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the compute node group.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the compute node group.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see ComputeNodeGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeNodeGroupSummary)) {
            return false;
        }
        ComputeNodeGroupSummary other = (ComputeNodeGroupSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeNodeGroupSummary").add("Name", name()).add("Id", id()).add("Arn", arn())
                .add("ClusterId", clusterId()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeNodeGroupSummary, T> g) {
        return obj -> g.apply((ComputeNodeGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeNodeGroupSummary> {
        /**
         * <p>
         * The name that identifies the compute node group.
         * </p>
         * 
         * @param name
         *        The name that identifies the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The generated unique ID of the compute node group.
         * </p>
         * 
         * @param id
         *        The generated unique ID of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the compute node group.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the cluster of the compute node group.
         * </p>
         * 
         * @param clusterId
         *        The ID of the cluster of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the resource was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the resource was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The provisioning status of the compute node group.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the compute node group.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the compute node group.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the compute node group.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see ComputeNodeGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeNodeGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The provisioning status of the compute node group.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the compute node group.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the compute node group.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the compute node group.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see ComputeNodeGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeNodeGroupStatus
         */
        Builder status(ComputeNodeGroupStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String clusterId;

        private Instant createdAt;

        private Instant modifiedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeNodeGroupSummary model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            clusterId(model.clusterId);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComputeNodeGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ComputeNodeGroupSummary build() {
            return new ComputeNodeGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
