/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional settings that directly map to Slurm settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlurmCustomSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SlurmCustomSetting.Builder, SlurmCustomSetting> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterName").getter(getter(SlurmCustomSetting::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterValue").getter(getter(SlurmCustomSetting::parameterValue))
            .setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterValue;

    private SlurmCustomSetting(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * PCS supports configuration of the following Slurm parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <b>clusters</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Prolog_1"> <code>Prolog</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Epilog_1"> <code>Epilog</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_SelectTypeParameters"> <code>SelectTypeParameters</code>
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_AccountingStorageEnforce">
     * <code>AccountingStorageEnforce</code> </a>
     * </p>
     * <important>
     * <p>
     * PCS supports a subset of the options for <code>AccountingStorageEnforce</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-accounting.html">Slurm accounting in PCS</a> in the
     * <i>PCS User Guide</i>.
     * </p>
     * </important></li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For <b>compute node groups</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>Weight</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>RealMemory</code> </a>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return PCS supports configuration of the following Slurm parameters:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <b>clusters</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Prolog_1"> <code>Prolog</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Epilog_1"> <code>Epilog</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_SelectTypeParameters">
     *         <code>SelectTypeParameters</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_AccountingStorageEnforce">
     *         <code>AccountingStorageEnforce</code> </a>
     *         </p>
     *         <important>
     *         <p>
     *         PCS supports a subset of the options for <code>AccountingStorageEnforce</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-accounting.html">Slurm accounting in
     *         PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     *         </important></li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For <b>compute node groups</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>Weight</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>RealMemory</code> </a>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The values for the configured Slurm settings.
     * </p>
     * 
     * @return The values for the configured Slurm settings.
     */
    public final String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlurmCustomSetting)) {
            return false;
        }
        SlurmCustomSetting other = (SlurmCustomSetting) obj;
        return Objects.equals(parameterName(), other.parameterName()) && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlurmCustomSetting").add("ParameterName", parameterName())
                .add("ParameterValue", parameterValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "parameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parameterName", PARAMETER_NAME_FIELD);
        map.put("parameterValue", PARAMETER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlurmCustomSetting, T> g) {
        return obj -> g.apply((SlurmCustomSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlurmCustomSetting> {
        /**
         * <p>
         * PCS supports configuration of the following Slurm parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <b>clusters</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Prolog_1"> <code>Prolog</code> </a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Epilog_1"> <code>Epilog</code> </a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_SelectTypeParameters">
         * <code>SelectTypeParameters</code> </a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_AccountingStorageEnforce">
         * <code>AccountingStorageEnforce</code> </a>
         * </p>
         * <important>
         * <p>
         * PCS supports a subset of the options for <code>AccountingStorageEnforce</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-accounting.html">Slurm accounting in PCS</a> in
         * the <i>PCS User Guide</i>.
         * </p>
         * </important></li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For <b>compute node groups</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>Weight</code> </a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>RealMemory</code> </a>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param parameterName
         *        PCS supports configuration of the following Slurm parameters:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <b>clusters</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Prolog_1"> <code>Prolog</code> </a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Epilog_1"> <code>Epilog</code> </a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_SelectTypeParameters">
         *        <code>SelectTypeParameters</code> </a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_AccountingStorageEnforce">
         *        <code>AccountingStorageEnforce</code> </a>
         *        </p>
         *        <important>
         *        <p>
         *        PCS supports a subset of the options for <code>AccountingStorageEnforce</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-accounting.html">Slurm accounting
         *        in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         *        </important></li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For <b>compute node groups</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>Weight</code> </a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Weight"> <code>RealMemory</code> </a>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The values for the configured Slurm settings.
         * </p>
         * 
         * @param parameterValue
         *        The values for the configured Slurm settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SlurmCustomSetting model) {
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        @Override
        public SlurmCustomSetting build() {
            return new SlurmCustomSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
