/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputeNodeGroupResponse extends PcsResponse implements
        ToCopyableBuilder<UpdateComputeNodeGroupResponse.Builder, UpdateComputeNodeGroupResponse> {
    private static final SdkField<ComputeNodeGroup> COMPUTE_NODE_GROUP_FIELD = SdkField
            .<ComputeNodeGroup> builder(MarshallingType.SDK_POJO).memberName("computeNodeGroup")
            .getter(getter(UpdateComputeNodeGroupResponse::computeNodeGroup)).setter(setter(Builder::computeNodeGroup))
            .constructor(ComputeNodeGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_NODE_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ComputeNodeGroup computeNodeGroup;

    private UpdateComputeNodeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.computeNodeGroup = builder.computeNodeGroup;
    }

    /**
     * Returns the value of the ComputeNodeGroup property for this object.
     * 
     * @return The value of the ComputeNodeGroup property for this object.
     */
    public final ComputeNodeGroup computeNodeGroup() {
        return computeNodeGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeNodeGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeNodeGroupResponse)) {
            return false;
        }
        UpdateComputeNodeGroupResponse other = (UpdateComputeNodeGroupResponse) obj;
        return Objects.equals(computeNodeGroup(), other.computeNodeGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputeNodeGroupResponse").add("ComputeNodeGroup", computeNodeGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeNodeGroup":
            return Optional.ofNullable(clazz.cast(computeNodeGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computeNodeGroup", COMPUTE_NODE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeNodeGroupResponse, T> g) {
        return obj -> g.apply((UpdateComputeNodeGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputeNodeGroupResponse> {
        /**
         * Sets the value of the ComputeNodeGroup property for this object.
         *
         * @param computeNodeGroup
         *        The new value for the ComputeNodeGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroup(ComputeNodeGroup computeNodeGroup);

        /**
         * Sets the value of the ComputeNodeGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ComputeNodeGroup.Builder} avoiding the
         * need to create one manually via {@link ComputeNodeGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeNodeGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #computeNodeGroup(ComputeNodeGroup)}.
         * 
         * @param computeNodeGroup
         *        a consumer that will call methods on {@link ComputeNodeGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeNodeGroup(ComputeNodeGroup)
         */
        default Builder computeNodeGroup(Consumer<ComputeNodeGroup.Builder> computeNodeGroup) {
            return computeNodeGroup(ComputeNodeGroup.builder().applyMutation(computeNodeGroup).build());
        }
    }

    static final class BuilderImpl extends PcsResponse.BuilderImpl implements Builder {
        private ComputeNodeGroup computeNodeGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeNodeGroupResponse model) {
            super(model);
            computeNodeGroup(model.computeNodeGroup);
        }

        public final ComputeNodeGroup.Builder getComputeNodeGroup() {
            return computeNodeGroup != null ? computeNodeGroup.toBuilder() : null;
        }

        public final void setComputeNodeGroup(ComputeNodeGroup.BuilderImpl computeNodeGroup) {
            this.computeNodeGroup = computeNodeGroup != null ? computeNodeGroup.build() : null;
        }

        @Override
        public final Builder computeNodeGroup(ComputeNodeGroup computeNodeGroup) {
            this.computeNodeGroup = computeNodeGroup;
            return this;
        }

        @Override
        public UpdateComputeNodeGroupResponse build() {
            return new UpdateComputeNodeGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
