/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional options related to the Slurm scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSlurmConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSlurmConfigurationRequest.Builder, ClusterSlurmConfigurationRequest> {
    private static final SdkField<Integer> SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("scaleDownIdleTimeInSeconds")
            .getter(getter(ClusterSlurmConfigurationRequest::scaleDownIdleTimeInSeconds))
            .setter(setter(Builder::scaleDownIdleTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleDownIdleTimeInSeconds").build())
            .build();

    private static final SdkField<List<SlurmCustomSetting>> SLURM_CUSTOM_SETTINGS_FIELD = SdkField
            .<List<SlurmCustomSetting>> builder(MarshallingType.LIST)
            .memberName("slurmCustomSettings")
            .getter(getter(ClusterSlurmConfigurationRequest::slurmCustomSettings))
            .setter(setter(Builder::slurmCustomSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmCustomSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlurmCustomSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlurmCustomSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AccountingRequest> ACCOUNTING_FIELD = SdkField
            .<AccountingRequest> builder(MarshallingType.SDK_POJO).memberName("accounting")
            .getter(getter(ClusterSlurmConfigurationRequest::accounting)).setter(setter(Builder::accounting))
            .constructor(AccountingRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounting").build()).build();

    private static final SdkField<SlurmRestRequest> SLURM_REST_FIELD = SdkField
            .<SlurmRestRequest> builder(MarshallingType.SDK_POJO).memberName("slurmRest")
            .getter(getter(ClusterSlurmConfigurationRequest::slurmRest)).setter(setter(Builder::slurmRest))
            .constructor(SlurmRestRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmRest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD, SLURM_CUSTOM_SETTINGS_FIELD, ACCOUNTING_FIELD, SLURM_REST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer scaleDownIdleTimeInSeconds;

    private final List<SlurmCustomSetting> slurmCustomSettings;

    private final AccountingRequest accounting;

    private final SlurmRestRequest slurmRest;

    private ClusterSlurmConfigurationRequest(BuilderImpl builder) {
        this.scaleDownIdleTimeInSeconds = builder.scaleDownIdleTimeInSeconds;
        this.slurmCustomSettings = builder.slurmCustomSettings;
        this.accounting = builder.accounting;
        this.slurmRest = builder.slurmRest;
    }

    /**
     * <p>
     * The time (in seconds) before an idle node is scaled down.
     * </p>
     * <p>
     * Default: <code>600</code>
     * </p>
     * 
     * @return The time (in seconds) before an idle node is scaled down.</p>
     *         <p>
     *         Default: <code>600</code>
     */
    public final Integer scaleDownIdleTimeInSeconds() {
        return scaleDownIdleTimeInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlurmCustomSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlurmCustomSettings() {
        return slurmCustomSettings != null && !(slurmCustomSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional Slurm-specific configuration that directly maps to Slurm settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlurmCustomSettings} method.
     * </p>
     * 
     * @return Additional Slurm-specific configuration that directly maps to Slurm settings.
     */
    public final List<SlurmCustomSetting> slurmCustomSettings() {
        return slurmCustomSettings;
    }

    /**
     * <p>
     * The accounting configuration includes configurable settings for Slurm accounting.
     * </p>
     * 
     * @return The accounting configuration includes configurable settings for Slurm accounting.
     */
    public final AccountingRequest accounting() {
        return accounting;
    }

    /**
     * <p>
     * The Slurm REST API configuration for the cluster.
     * </p>
     * 
     * @return The Slurm REST API configuration for the cluster.
     */
    public final SlurmRestRequest slurmRest() {
        return slurmRest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scaleDownIdleTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlurmCustomSettings() ? slurmCustomSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accounting());
        hashCode = 31 * hashCode + Objects.hashCode(slurmRest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSlurmConfigurationRequest)) {
            return false;
        }
        ClusterSlurmConfigurationRequest other = (ClusterSlurmConfigurationRequest) obj;
        return Objects.equals(scaleDownIdleTimeInSeconds(), other.scaleDownIdleTimeInSeconds())
                && hasSlurmCustomSettings() == other.hasSlurmCustomSettings()
                && Objects.equals(slurmCustomSettings(), other.slurmCustomSettings())
                && Objects.equals(accounting(), other.accounting()) && Objects.equals(slurmRest(), other.slurmRest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSlurmConfigurationRequest")
                .add("ScaleDownIdleTimeInSeconds", scaleDownIdleTimeInSeconds())
                .add("SlurmCustomSettings", hasSlurmCustomSettings() ? slurmCustomSettings() : null)
                .add("Accounting", accounting()).add("SlurmRest", slurmRest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scaleDownIdleTimeInSeconds":
            return Optional.ofNullable(clazz.cast(scaleDownIdleTimeInSeconds()));
        case "slurmCustomSettings":
            return Optional.ofNullable(clazz.cast(slurmCustomSettings()));
        case "accounting":
            return Optional.ofNullable(clazz.cast(accounting()));
        case "slurmRest":
            return Optional.ofNullable(clazz.cast(slurmRest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scaleDownIdleTimeInSeconds", SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD);
        map.put("slurmCustomSettings", SLURM_CUSTOM_SETTINGS_FIELD);
        map.put("accounting", ACCOUNTING_FIELD);
        map.put("slurmRest", SLURM_REST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSlurmConfigurationRequest, T> g) {
        return obj -> g.apply((ClusterSlurmConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSlurmConfigurationRequest> {
        /**
         * <p>
         * The time (in seconds) before an idle node is scaled down.
         * </p>
         * <p>
         * Default: <code>600</code>
         * </p>
         * 
         * @param scaleDownIdleTimeInSeconds
         *        The time (in seconds) before an idle node is scaled down.</p>
         *        <p>
         *        Default: <code>600</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleDownIdleTimeInSeconds(Integer scaleDownIdleTimeInSeconds);

        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * 
         * @param slurmCustomSettings
         *        Additional Slurm-specific configuration that directly maps to Slurm settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmCustomSettings(Collection<SlurmCustomSetting> slurmCustomSettings);

        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * 
         * @param slurmCustomSettings
         *        Additional Slurm-specific configuration that directly maps to Slurm settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmCustomSettings(SlurmCustomSetting... slurmCustomSettings);

        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #slurmCustomSettings(List<SlurmCustomSetting>)}.
         * 
         * @param slurmCustomSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmCustomSettings(java.util.Collection<SlurmCustomSetting>)
         */
        Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder>... slurmCustomSettings);

        /**
         * <p>
         * The accounting configuration includes configurable settings for Slurm accounting.
         * </p>
         * 
         * @param accounting
         *        The accounting configuration includes configurable settings for Slurm accounting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounting(AccountingRequest accounting);

        /**
         * <p>
         * The accounting configuration includes configurable settings for Slurm accounting.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountingRequest.Builder} avoiding the
         * need to create one manually via {@link AccountingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountingRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #accounting(AccountingRequest)}.
         * 
         * @param accounting
         *        a consumer that will call methods on {@link AccountingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounting(AccountingRequest)
         */
        default Builder accounting(Consumer<AccountingRequest.Builder> accounting) {
            return accounting(AccountingRequest.builder().applyMutation(accounting).build());
        }

        /**
         * <p>
         * The Slurm REST API configuration for the cluster.
         * </p>
         * 
         * @param slurmRest
         *        The Slurm REST API configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmRest(SlurmRestRequest slurmRest);

        /**
         * <p>
         * The Slurm REST API configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlurmRestRequest.Builder} avoiding the
         * need to create one manually via {@link SlurmRestRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlurmRestRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #slurmRest(SlurmRestRequest)}.
         * 
         * @param slurmRest
         *        a consumer that will call methods on {@link SlurmRestRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmRest(SlurmRestRequest)
         */
        default Builder slurmRest(Consumer<SlurmRestRequest.Builder> slurmRest) {
            return slurmRest(SlurmRestRequest.builder().applyMutation(slurmRest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer scaleDownIdleTimeInSeconds;

        private List<SlurmCustomSetting> slurmCustomSettings = DefaultSdkAutoConstructList.getInstance();

        private AccountingRequest accounting;

        private SlurmRestRequest slurmRest;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSlurmConfigurationRequest model) {
            scaleDownIdleTimeInSeconds(model.scaleDownIdleTimeInSeconds);
            slurmCustomSettings(model.slurmCustomSettings);
            accounting(model.accounting);
            slurmRest(model.slurmRest);
        }

        public final Integer getScaleDownIdleTimeInSeconds() {
            return scaleDownIdleTimeInSeconds;
        }

        public final void setScaleDownIdleTimeInSeconds(Integer scaleDownIdleTimeInSeconds) {
            this.scaleDownIdleTimeInSeconds = scaleDownIdleTimeInSeconds;
        }

        @Override
        public final Builder scaleDownIdleTimeInSeconds(Integer scaleDownIdleTimeInSeconds) {
            this.scaleDownIdleTimeInSeconds = scaleDownIdleTimeInSeconds;
            return this;
        }

        public final List<SlurmCustomSetting.Builder> getSlurmCustomSettings() {
            List<SlurmCustomSetting.Builder> result = SlurmCustomSettingsCopier.copyToBuilder(this.slurmCustomSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlurmCustomSettings(Collection<SlurmCustomSetting.BuilderImpl> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copyFromBuilder(slurmCustomSettings);
        }

        @Override
        public final Builder slurmCustomSettings(Collection<SlurmCustomSetting> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copy(slurmCustomSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(SlurmCustomSetting... slurmCustomSettings) {
            slurmCustomSettings(Arrays.asList(slurmCustomSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder>... slurmCustomSettings) {
            slurmCustomSettings(Stream.of(slurmCustomSettings).map(c -> SlurmCustomSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AccountingRequest.Builder getAccounting() {
            return accounting != null ? accounting.toBuilder() : null;
        }

        public final void setAccounting(AccountingRequest.BuilderImpl accounting) {
            this.accounting = accounting != null ? accounting.build() : null;
        }

        @Override
        public final Builder accounting(AccountingRequest accounting) {
            this.accounting = accounting;
            return this;
        }

        public final SlurmRestRequest.Builder getSlurmRest() {
            return slurmRest != null ? slurmRest.toBuilder() : null;
        }

        public final void setSlurmRest(SlurmRestRequest.BuilderImpl slurmRest) {
            this.slurmRest = slurmRest != null ? slurmRest.build() : null;
        }

        @Override
        public final Builder slurmRest(SlurmRestRequest slurmRest) {
            this.slurmRest = slurmRest;
            return this;
        }

        @Override
        public ClusterSlurmConfigurationRequest build() {
            return new ClusterSlurmConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
