/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A compute node group associated with a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeNodeGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeNodeGroup.Builder, ComputeNodeGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComputeNodeGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ComputeNodeGroup::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ComputeNodeGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterId").getter(getter(ComputeNodeGroup::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ComputeNodeGroup::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(ComputeNodeGroup::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ComputeNodeGroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("amiId")
            .getter(getter(ComputeNodeGroup::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(ComputeNodeGroup::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PURCHASE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("purchaseOption").getter(getter(ComputeNodeGroup::purchaseOptionAsString))
            .setter(setter(Builder::purchaseOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseOption").build()).build();

    private static final SdkField<CustomLaunchTemplate> CUSTOM_LAUNCH_TEMPLATE_FIELD = SdkField
            .<CustomLaunchTemplate> builder(MarshallingType.SDK_POJO).memberName("customLaunchTemplate")
            .getter(getter(ComputeNodeGroup::customLaunchTemplate)).setter(setter(Builder::customLaunchTemplate))
            .constructor(CustomLaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLaunchTemplate").build())
            .build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamInstanceProfileArn").getter(getter(ComputeNodeGroup::iamInstanceProfileArn))
            .setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build())
            .build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("scalingConfiguration")
            .getter(getter(ComputeNodeGroup::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build())
            .build();

    private static final SdkField<List<InstanceConfig>> INSTANCE_CONFIGS_FIELD = SdkField
            .<List<InstanceConfig>> builder(MarshallingType.LIST)
            .memberName("instanceConfigs")
            .getter(getter(ComputeNodeGroup::instanceConfigs))
            .setter(setter(Builder::instanceConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.<SpotOptions> builder(MarshallingType.SDK_POJO)
            .memberName("spotOptions").getter(getter(ComputeNodeGroup::spotOptions)).setter(setter(Builder::spotOptions))
            .constructor(SpotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotOptions").build()).build();

    private static final SdkField<ComputeNodeGroupSlurmConfiguration> SLURM_CONFIGURATION_FIELD = SdkField
            .<ComputeNodeGroupSlurmConfiguration> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(ComputeNodeGroup::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(ComputeNodeGroupSlurmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<List<ErrorInfo>> ERROR_INFO_FIELD = SdkField
            .<List<ErrorInfo>> builder(MarshallingType.LIST)
            .memberName("errorInfo")
            .getter(getter(ComputeNodeGroup::errorInfo))
            .setter(setter(Builder::errorInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, CLUSTER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, AMI_ID_FIELD, SUBNET_IDS_FIELD,
            PURCHASE_OPTION_FIELD, CUSTOM_LAUNCH_TEMPLATE_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, SCALING_CONFIGURATION_FIELD,
            INSTANCE_CONFIGS_FIELD, SPOT_OPTIONS_FIELD, SLURM_CONFIGURATION_FIELD, ERROR_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final String clusterId;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String status;

    private final String amiId;

    private final List<String> subnetIds;

    private final String purchaseOption;

    private final CustomLaunchTemplate customLaunchTemplate;

    private final String iamInstanceProfileArn;

    private final ScalingConfiguration scalingConfiguration;

    private final List<InstanceConfig> instanceConfigs;

    private final SpotOptions spotOptions;

    private final ComputeNodeGroupSlurmConfiguration slurmConfiguration;

    private final List<ErrorInfo> errorInfo;

    private ComputeNodeGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.clusterId = builder.clusterId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.amiId = builder.amiId;
        this.subnetIds = builder.subnetIds;
        this.purchaseOption = builder.purchaseOption;
        this.customLaunchTemplate = builder.customLaunchTemplate;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.instanceConfigs = builder.instanceConfigs;
        this.spotOptions = builder.spotOptions;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * The name that identifies the compute node group.
     * </p>
     * 
     * @return The name that identifies the compute node group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The generated unique ID of the compute node group.
     * </p>
     * 
     * @return The generated unique ID of the compute node group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the compute node group.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the compute node group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the cluster of the compute node group.
     * </p>
     * 
     * @return The ID of the cluster of the compute node group.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the resource was modified.
     * </p>
     * 
     * @return The date and time the resource was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The provisioning status of the compute node group.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the compute node group.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComputeNodeGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the compute node group.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the compute node group.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see ComputeNodeGroupStatus
     */
    public final ComputeNodeGroupStatus status() {
        return ComputeNodeGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The provisioning status of the compute node group.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the compute node group.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComputeNodeGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the compute node group.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the compute node group.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see ComputeNodeGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) that PCS uses to launch instances. If not provided, PCS uses the AMI ID
     * specified in the custom launch template.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) that PCS uses to launch instances. If not provided, PCS uses the
     *         AMI ID specified in the custom launch template.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same
     * VPC as the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in
     *         the same VPC as the cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot Instances, and
     * Amazon EC2 Capacity Blocks for ML. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2 billing
     * and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about PCS
     * support for Capacity Blocks, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity Blocks for
     * ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot
     *         Instances, and Amazon EC2 Capacity Blocks for ML. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
     *         billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
     *         information about PCS support for Capacity Blocks, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity
     *         Blocks for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to
     *         On-Demand.
     * @see PurchaseOption
     */
    public final PurchaseOption purchaseOption() {
        return PurchaseOption.fromValue(purchaseOption);
    }

    /**
     * <p>
     * Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot Instances, and
     * Amazon EC2 Capacity Blocks for ML. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2 billing
     * and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about PCS
     * support for Capacity Blocks, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity Blocks for
     * ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to On-Demand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchaseOption}
     * will return {@link PurchaseOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchaseOptionAsString}.
     * </p>
     * 
     * @return Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot
     *         Instances, and Amazon EC2 Capacity Blocks for ML. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
     *         billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
     *         information about PCS support for Capacity Blocks, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity
     *         Blocks for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to
     *         On-Demand.
     * @see PurchaseOption
     */
    public final String purchaseOptionAsString() {
        return purchaseOption;
    }

    /**
     * Returns the value of the CustomLaunchTemplate property for this object.
     * 
     * @return The value of the CustomLaunchTemplate property for this object.
     */
    public final CustomLaunchTemplate customLaunchTemplate() {
        return customLaunchTemplate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances.
     * The role contained in your instance profile must have the <code>pcs:RegisterComputeNodeGroupInstance</code>
     * permission and the role name must start with <code>AWSPCS</code> or must have the path <code>/aws-pcs/</code>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html">IAM instance profiles for
     * PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
     *         instances. The role contained in your instance profile must have the
     *         <code>pcs:RegisterComputeNodeGroupInstance</code> permission and the role name must start with
     *         <code>AWSPCS</code> or must have the path <code>/aws-pcs/</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html">IAM instance
     *         profiles for PCS</a> in the <i>PCS User Guide</i>.
     */
    public final String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * Returns the value of the ScalingConfiguration property for this object.
     * 
     * @return The value of the ScalingConfiguration property for this object.
     */
    public final ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceConfigs() {
        return instanceConfigs != null && !(instanceConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 instance configurations that PCS can provision in the compute node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceConfigs} method.
     * </p>
     * 
     * @return A list of EC2 instance configurations that PCS can provision in the compute node group.
     */
    public final List<InstanceConfig> instanceConfigs() {
        return instanceConfigs;
    }

    /**
     * Returns the value of the SpotOptions property for this object.
     * 
     * @return The value of the SpotOptions property for this object.
     */
    public final SpotOptions spotOptions() {
        return spotOptions;
    }

    /**
     * Returns the value of the SlurmConfiguration property for this object.
     * 
     * @return The value of the SlurmConfiguration property for this object.
     */
    public final ComputeNodeGroupSlurmConfiguration slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorInfo property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorInfo() {
        return errorInfo != null && !(errorInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of errors that occurred during compute node group provisioning.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorInfo} method.
     * </p>
     * 
     * @return The list of errors that occurred during compute node group provisioning.
     */
    public final List<ErrorInfo> errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceConfigs() ? instanceConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorInfo() ? errorInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeNodeGroup)) {
            return false;
        }
        ComputeNodeGroup other = (ComputeNodeGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(amiId(), other.amiId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(purchaseOptionAsString(), other.purchaseOptionAsString())
                && Objects.equals(customLaunchTemplate(), other.customLaunchTemplate())
                && Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && hasInstanceConfigs() == other.hasInstanceConfigs()
                && Objects.equals(instanceConfigs(), other.instanceConfigs())
                && Objects.equals(spotOptions(), other.spotOptions())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration()) && hasErrorInfo() == other.hasErrorInfo()
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeNodeGroup").add("Name", name()).add("Id", id()).add("Arn", arn())
                .add("ClusterId", clusterId()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Status", statusAsString()).add("AmiId", amiId()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("PurchaseOption", purchaseOptionAsString()).add("CustomLaunchTemplate", customLaunchTemplate())
                .add("IamInstanceProfileArn", iamInstanceProfileArn()).add("ScalingConfiguration", scalingConfiguration())
                .add("InstanceConfigs", hasInstanceConfigs() ? instanceConfigs() : null).add("SpotOptions", spotOptions())
                .add("SlurmConfiguration", slurmConfiguration()).add("ErrorInfo", hasErrorInfo() ? errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "amiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "purchaseOption":
            return Optional.ofNullable(clazz.cast(purchaseOptionAsString()));
        case "customLaunchTemplate":
            return Optional.ofNullable(clazz.cast(customLaunchTemplate()));
        case "iamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "scalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "instanceConfigs":
            return Optional.ofNullable(clazz.cast(instanceConfigs()));
        case "spotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("amiId", AMI_ID_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("purchaseOption", PURCHASE_OPTION_FIELD);
        map.put("customLaunchTemplate", CUSTOM_LAUNCH_TEMPLATE_FIELD);
        map.put("iamInstanceProfileArn", IAM_INSTANCE_PROFILE_ARN_FIELD);
        map.put("scalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("instanceConfigs", INSTANCE_CONFIGS_FIELD);
        map.put("spotOptions", SPOT_OPTIONS_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeNodeGroup, T> g) {
        return obj -> g.apply((ComputeNodeGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeNodeGroup> {
        /**
         * <p>
         * The name that identifies the compute node group.
         * </p>
         * 
         * @param name
         *        The name that identifies the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The generated unique ID of the compute node group.
         * </p>
         * 
         * @param id
         *        The generated unique ID of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the compute node group.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the cluster of the compute node group.
         * </p>
         * 
         * @param clusterId
         *        The ID of the cluster of the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the resource was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the resource was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The provisioning status of the compute node group.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the compute node group.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the compute node group.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the compute node group.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see ComputeNodeGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeNodeGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The provisioning status of the compute node group.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the compute node group.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the compute node group.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the compute node group.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see ComputeNodeGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeNodeGroupStatus
         */
        Builder status(ComputeNodeGroupStatus status);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) that PCS uses to launch instances. If not provided, PCS uses the AMI
         * ID specified in the custom launch template.
         * </p>
         * 
         * @param amiId
         *        The ID of the Amazon Machine Image (AMI) that PCS uses to launch instances. If not provided, PCS uses
         *        the AMI ID specified in the custom launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the
         * same VPC as the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be
         *        in the same VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the
         * same VPC as the cluster.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be
         *        in the same VPC as the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot Instances,
         * and Amazon EC2 Capacity Blocks for ML. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
         * billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
         * information about PCS support for Capacity Blocks, see <a
         * href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity Blocks
         * for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot
         *        Instances, and Amazon EC2 Capacity Blocks for ML. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
         *        billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
         *        information about PCS support for Capacity Blocks, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity
         *        Blocks for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults
         *        to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(String purchaseOption);

        /**
         * <p>
         * Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot Instances,
         * and Amazon EC2 Capacity Blocks for ML. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
         * billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
         * information about PCS support for Capacity Blocks, see <a
         * href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity Blocks
         * for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults to On-Demand.
         * </p>
         * 
         * @param purchaseOption
         *        Specifies how EC2 instances are purchased on your behalf. PCS supports On-Demand Instances, Spot
         *        Instances, and Amazon EC2 Capacity Blocks for ML. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Amazon EC2
         *        billing and purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more
         *        information about PCS support for Capacity Blocks, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/capacity-blocks.html">Using Amazon EC2 Capacity
         *        Blocks for ML with PCS</a> in the <i>PCS User Guide</i>. If you don't provide this option, it defaults
         *        to On-Demand.
         * @see PurchaseOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOption
         */
        Builder purchaseOption(PurchaseOption purchaseOption);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * @param customLaunchTemplate
         *        The new value for the CustomLaunchTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate);

        /**
         * Sets the value of the CustomLaunchTemplate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomLaunchTemplate.Builder} avoiding
         * the need to create one manually via {@link CustomLaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLaunchTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #customLaunchTemplate(CustomLaunchTemplate)}.
         * 
         * @param customLaunchTemplate
         *        a consumer that will call methods on {@link CustomLaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLaunchTemplate(CustomLaunchTemplate)
         */
        default Builder customLaunchTemplate(Consumer<CustomLaunchTemplate.Builder> customLaunchTemplate) {
            return customLaunchTemplate(CustomLaunchTemplate.builder().applyMutation(customLaunchTemplate).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         * instances. The role contained in your instance profile must have the
         * <code>pcs:RegisterComputeNodeGroupInstance</code> permission and the role name must start with
         * <code>AWSPCS</code> or must have the path <code>/aws-pcs/</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html">IAM instance profiles
         * for PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * 
         * @param iamInstanceProfileArn
         *        The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2
         *        instances. The role contained in your instance profile must have the
         *        <code>pcs:RegisterComputeNodeGroupInstance</code> permission and the role name must start with
         *        <code>AWSPCS</code> or must have the path <code>/aws-pcs/</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html">IAM instance
         *        profiles for PCS</a> in the <i>PCS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * Sets the value of the ScalingConfiguration property for this object.
         *
         * @param scalingConfiguration
         *        The new value for the ScalingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * Sets the value of the ScalingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScalingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * A list of EC2 instance configurations that PCS can provision in the compute node group.
         * </p>
         * 
         * @param instanceConfigs
         *        A list of EC2 instance configurations that PCS can provision in the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfigs(Collection<InstanceConfig> instanceConfigs);

        /**
         * <p>
         * A list of EC2 instance configurations that PCS can provision in the compute node group.
         * </p>
         * 
         * @param instanceConfigs
         *        A list of EC2 instance configurations that PCS can provision in the compute node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfigs(InstanceConfig... instanceConfigs);

        /**
         * <p>
         * A list of EC2 instance configurations that PCS can provision in the compute node group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pcs.model.InstanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfigs(List<InstanceConfig>)}.
         * 
         * @param instanceConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.InstanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfigs(java.util.Collection<InstanceConfig>)
         */
        Builder instanceConfigs(Consumer<InstanceConfig.Builder>... instanceConfigs);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * @param spotOptions
         *        The new value for the SpotOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotOptions spotOptions);

        /**
         * Sets the value of the SpotOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SpotOptions.Builder} avoiding the need to
         * create one manually via {@link SpotOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #spotOptions(SpotOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotOptions)
         */
        default Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return spotOptions(SpotOptions.builder().applyMutation(spotOptions).build());
        }

        /**
         * Sets the value of the SlurmConfiguration property for this object.
         *
         * @param slurmConfiguration
         *        The new value for the SlurmConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(ComputeNodeGroupSlurmConfiguration slurmConfiguration);

        /**
         * Sets the value of the SlurmConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ComputeNodeGroupSlurmConfiguration.Builder} avoiding the need to create one manually via
         * {@link ComputeNodeGroupSlurmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeNodeGroupSlurmConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #slurmConfiguration(ComputeNodeGroupSlurmConfiguration)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link ComputeNodeGroupSlurmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(ComputeNodeGroupSlurmConfiguration)
         */
        default Builder slurmConfiguration(Consumer<ComputeNodeGroupSlurmConfiguration.Builder> slurmConfiguration) {
            return slurmConfiguration(ComputeNodeGroupSlurmConfiguration.builder().applyMutation(slurmConfiguration).build());
        }

        /**
         * <p>
         * The list of errors that occurred during compute node group provisioning.
         * </p>
         * 
         * @param errorInfo
         *        The list of errors that occurred during compute node group provisioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(Collection<ErrorInfo> errorInfo);

        /**
         * <p>
         * The list of errors that occurred during compute node group provisioning.
         * </p>
         * 
         * @param errorInfo
         *        The list of errors that occurred during compute node group provisioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo... errorInfo);

        /**
         * <p>
         * The list of errors that occurred during compute node group provisioning.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.pcs.model.ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInfo(List<ErrorInfo>)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(java.util.Collection<ErrorInfo>)
         */
        Builder errorInfo(Consumer<ErrorInfo.Builder>... errorInfo);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String clusterId;

        private Instant createdAt;

        private Instant modifiedAt;

        private String status;

        private String amiId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String purchaseOption;

        private CustomLaunchTemplate customLaunchTemplate;

        private String iamInstanceProfileArn;

        private ScalingConfiguration scalingConfiguration;

        private List<InstanceConfig> instanceConfigs = DefaultSdkAutoConstructList.getInstance();

        private SpotOptions spotOptions;

        private ComputeNodeGroupSlurmConfiguration slurmConfiguration;

        private List<ErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeNodeGroup model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            clusterId(model.clusterId);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            status(model.status);
            amiId(model.amiId);
            subnetIds(model.subnetIds);
            purchaseOption(model.purchaseOption);
            customLaunchTemplate(model.customLaunchTemplate);
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            scalingConfiguration(model.scalingConfiguration);
            instanceConfigs(model.instanceConfigs);
            spotOptions(model.spotOptions);
            slurmConfiguration(model.slurmConfiguration);
            errorInfo(model.errorInfo);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComputeNodeGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getPurchaseOption() {
            return purchaseOption;
        }

        public final void setPurchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
        }

        @Override
        public final Builder purchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        @Override
        public final Builder purchaseOption(PurchaseOption purchaseOption) {
            this.purchaseOption(purchaseOption == null ? null : purchaseOption.toString());
            return this;
        }

        public final CustomLaunchTemplate.Builder getCustomLaunchTemplate() {
            return customLaunchTemplate != null ? customLaunchTemplate.toBuilder() : null;
        }

        public final void setCustomLaunchTemplate(CustomLaunchTemplate.BuilderImpl customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate != null ? customLaunchTemplate.build() : null;
        }

        @Override
        public final Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final List<InstanceConfig.Builder> getInstanceConfigs() {
            List<InstanceConfig.Builder> result = InstanceListCopier.copyToBuilder(this.instanceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceConfigs(Collection<InstanceConfig.BuilderImpl> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copyFromBuilder(instanceConfigs);
        }

        @Override
        public final Builder instanceConfigs(Collection<InstanceConfig> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copy(instanceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(InstanceConfig... instanceConfigs) {
            instanceConfigs(Arrays.asList(instanceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(Consumer<InstanceConfig.Builder>... instanceConfigs) {
            instanceConfigs(Stream.of(instanceConfigs).map(c -> InstanceConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final ComputeNodeGroupSlurmConfiguration.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ComputeNodeGroupSlurmConfiguration.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ComputeNodeGroupSlurmConfiguration slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final List<ErrorInfo.Builder> getErrorInfo() {
            List<ErrorInfo.Builder> result = ErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<ErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<ErrorInfo> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(ErrorInfo... errorInfo) {
            errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<ErrorInfo.Builder>... errorInfo) {
            errorInfo(Stream.of(errorInfo).map(c -> ErrorInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ComputeNodeGroup build() {
            return new ComputeNodeGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
