/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The compute node group configuration for a queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeNodeGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeNodeGroupConfiguration.Builder, ComputeNodeGroupConfiguration> {
    private static final SdkField<String> COMPUTE_NODE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeNodeGroupId").getter(getter(ComputeNodeGroupConfiguration::computeNodeGroupId))
            .setter(setter(Builder::computeNodeGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_NODE_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computeNodeGroupId;

    private ComputeNodeGroupConfiguration(BuilderImpl builder) {
        this.computeNodeGroupId = builder.computeNodeGroupId;
    }

    /**
     * <p>
     * The compute node group ID for the compute node group configuration.
     * </p>
     * 
     * @return The compute node group ID for the compute node group configuration.
     */
    public final String computeNodeGroupId() {
        return computeNodeGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeNodeGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeNodeGroupConfiguration)) {
            return false;
        }
        ComputeNodeGroupConfiguration other = (ComputeNodeGroupConfiguration) obj;
        return Objects.equals(computeNodeGroupId(), other.computeNodeGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeNodeGroupConfiguration").add("ComputeNodeGroupId", computeNodeGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeNodeGroupId":
            return Optional.ofNullable(clazz.cast(computeNodeGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computeNodeGroupId", COMPUTE_NODE_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeNodeGroupConfiguration, T> g) {
        return obj -> g.apply((ComputeNodeGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeNodeGroupConfiguration> {
        /**
         * <p>
         * The compute node group ID for the compute node group configuration.
         * </p>
         * 
         * @param computeNodeGroupId
         *        The compute node group ID for the compute node group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupId(String computeNodeGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String computeNodeGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeNodeGroupConfiguration model) {
            computeNodeGroupId(model.computeNodeGroupId);
        }

        public final String getComputeNodeGroupId() {
            return computeNodeGroupId;
        }

        public final void setComputeNodeGroupId(String computeNodeGroupId) {
            this.computeNodeGroupId = computeNodeGroupId;
        }

        @Override
        public final Builder computeNodeGroupId(String computeNodeGroupId) {
            this.computeNodeGroupId = computeNodeGroupId;
            return this;
        }

        @Override
        public ComputeNodeGroupConfiguration build() {
            return new ComputeNodeGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
