/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQueueRequest extends PcsRequest implements
        ToCopyableBuilder<CreateQueueRequest.Builder, CreateQueueRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(CreateQueueRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueName").getter(getter(CreateQueueRequest::queueName)).setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueName").build()).build();

    private static final SdkField<List<ComputeNodeGroupConfiguration>> COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD = SdkField
            .<List<ComputeNodeGroupConfiguration>> builder(MarshallingType.LIST)
            .memberName("computeNodeGroupConfigurations")
            .getter(getter(CreateQueueRequest::computeNodeGroupConfigurations))
            .setter(setter(Builder::computeNodeGroupConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeNodeGroupConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeNodeGroupConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueueSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField
            .<QueueSlurmConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(CreateQueueRequest::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(QueueSlurmConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateQueueRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateQueueRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, QUEUE_NAME_FIELD, COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD,
                    SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String queueName;

    private final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations;

    private final QueueSlurmConfigurationRequest slurmConfiguration;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.queueName = builder.queueName;
        this.computeNodeGroupConfigurations = builder.computeNodeGroupConfigurations;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name or ID of the cluster for which to create a queue.
     * </p>
     * 
     * @return The name or ID of the cluster for which to create a queue.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * A name to identify the queue.
     * </p>
     * 
     * @return A name to identify the queue.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeNodeGroupConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations != null && !(computeNodeGroupConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
     * compute node groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeNodeGroupConfigurations} method.
     * </p>
     * 
     * @return The list of compute node group configurations to associate with the queue. Queues assign jobs to
     *         associated compute node groups.
     */
    public final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final QueueSlurmConfigurationRequest slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect. If you don't specify a client token, the CLI and SDK automatically
     * generate 1 for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect. If you don't specify a client token,
     *         the CLI and SDK automatically generate 1 for you.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and
     * can be an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
     *         optional and can be an empty string.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(queueName(), other.queueName())
                && hasComputeNodeGroupConfigurations() == other.hasComputeNodeGroupConfigurations()
                && Objects.equals(computeNodeGroupConfigurations(), other.computeNodeGroupConfigurations())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateQueueRequest")
                .add("ClusterIdentifier", clusterIdentifier())
                .add("QueueName", queueName())
                .add("ComputeNodeGroupConfigurations",
                        hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null)
                .add("SlurmConfiguration", slurmConfiguration()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "queueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "computeNodeGroupConfigurations":
            return Optional.ofNullable(clazz.cast(computeNodeGroupConfigurations()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("queueName", QUEUE_NAME_FIELD);
        map.put("computeNodeGroupConfigurations", COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueRequest, T> g) {
        return obj -> g.apply((CreateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQueueRequest> {
        /**
         * <p>
         * The name or ID of the cluster for which to create a queue.
         * </p>
         * 
         * @param clusterIdentifier
         *        The name or ID of the cluster for which to create a queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * A name to identify the queue.
         * </p>
         * 
         * @param queueName
         *        A name to identify the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations to associate with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations to associate with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #computeNodeGroupConfigurations(List<ComputeNodeGroupConfiguration>)}.
         * 
         * @param computeNodeGroupConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeNodeGroupConfigurations(java.util.Collection<ComputeNodeGroupConfiguration>)
         */
        Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(QueueSlurmConfigurationRequest slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueSlurmConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link QueueSlurmConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueSlurmConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #slurmConfiguration(QueueSlurmConfigurationRequest)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link QueueSlurmConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(QueueSlurmConfigurationRequest)
         */
        default Builder slurmConfiguration(Consumer<QueueSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return slurmConfiguration(QueueSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect. If you don't specify a client token, the CLI and SDK
         * automatically generate 1 for you.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect. If you don't specify a
         *        client token, the CLI and SDK automatically generate 1 for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional
         * and can be an empty string.
         * </p>
         * 
         * @param tags
         *        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
         *        optional and can be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcsRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String queueName;

        private List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations = DefaultSdkAutoConstructList.getInstance();

        private QueueSlurmConfigurationRequest slurmConfiguration;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            queueName(model.queueName);
            computeNodeGroupConfigurations(model.computeNodeGroupConfigurations);
            slurmConfiguration(model.slurmConfiguration);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getQueueName() {
            return queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final List<ComputeNodeGroupConfiguration.Builder> getComputeNodeGroupConfigurations() {
            List<ComputeNodeGroupConfiguration.Builder> result = ComputeNodeGroupConfigurationListCopier
                    .copyToBuilder(this.computeNodeGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration.BuilderImpl> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier
                    .copyFromBuilder(computeNodeGroupConfigurations);
        }

        @Override
        public final Builder computeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copy(computeNodeGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Arrays.asList(computeNodeGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(
                Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Stream.of(computeNodeGroupConfigurations)
                    .map(c -> ComputeNodeGroupConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final QueueSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(QueueSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(QueueSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
