/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A queue resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Queue implements SdkPojo, Serializable, ToCopyableBuilder<Queue.Builder, Queue> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Queue::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Queue::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Queue::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterId").getter(getter(Queue::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Queue::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(Queue::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Queue::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<ComputeNodeGroupConfiguration>> COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD = SdkField
            .<List<ComputeNodeGroupConfiguration>> builder(MarshallingType.LIST)
            .memberName("computeNodeGroupConfigurations")
            .getter(getter(Queue::computeNodeGroupConfigurations))
            .setter(setter(Builder::computeNodeGroupConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeNodeGroupConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeNodeGroupConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueueSlurmConfiguration> SLURM_CONFIGURATION_FIELD = SdkField
            .<QueueSlurmConfiguration> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(Queue::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(QueueSlurmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<List<ErrorInfo>> ERROR_INFO_FIELD = SdkField
            .<List<ErrorInfo>> builder(MarshallingType.LIST)
            .memberName("errorInfo")
            .getter(getter(Queue::errorInfo))
            .setter(setter(Builder::errorInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, CLUSTER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD,
            COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD, SLURM_CONFIGURATION_FIELD, ERROR_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final String clusterId;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String status;

    private final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations;

    private final QueueSlurmConfiguration slurmConfiguration;

    private final List<ErrorInfo> errorInfo;

    private Queue(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.clusterId = builder.clusterId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.computeNodeGroupConfigurations = builder.computeNodeGroupConfigurations;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * The name that identifies the queue.
     * </p>
     * 
     * @return The name that identifies the queue.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The generated unique ID of the queue.
     * </p>
     * 
     * @return The generated unique ID of the queue.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the queue.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the queue.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the cluster of the queue.
     * </p>
     * 
     * @return The ID of the cluster of the queue.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the resource was modified.
     * </p>
     * 
     * @return The date and time the resource was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The provisioning status of the queue.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the queue.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the queue.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the queue.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * <p>
     * The provisioning status of the queue.
     * </p>
     * <note>
     * <p>
     * The provisioning status doesn't indicate the overall health of the queue.
     * </p>
     * </note> <important>
     * <p>
     * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is beyond
     * end of life and we have suspended the cluster. When in these states, you can't use the cluster. The cluster
     * controller is down and all compute instances are terminated. The resources still count toward your service
     * quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions about
     * Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The provisioning status of the queue.</p> <note>
     *         <p>
     *         The provisioning status doesn't indicate the overall health of the queue.
     *         </p>
     *         </note> <important>
     *         <p>
     *         The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
     *         beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster.
     *         The cluster controller is down and all compute instances are terminated. The resources still count toward
     *         your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
     *         questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
     *         </p>
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeNodeGroupConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations != null && !(computeNodeGroupConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute
     * node groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeNodeGroupConfigurations} method.
     * </p>
     * 
     * @return The list of compute node group configurations associated with the queue. Queues assign jobs to associated
     *         compute node groups.
     */
    public final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final QueueSlurmConfiguration slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorInfo property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorInfo() {
        return errorInfo != null && !(errorInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of errors that occurred during queue provisioning.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorInfo} method.
     * </p>
     * 
     * @return The list of errors that occurred during queue provisioning.
     */
    public final List<ErrorInfo> errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorInfo() ? errorInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasComputeNodeGroupConfigurations() == other.hasComputeNodeGroupConfigurations()
                && Objects.equals(computeNodeGroupConfigurations(), other.computeNodeGroupConfigurations())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration()) && hasErrorInfo() == other.hasErrorInfo()
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Queue")
                .add("Name", name())
                .add("Id", id())
                .add("Arn", arn())
                .add("ClusterId", clusterId())
                .add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt())
                .add("Status", statusAsString())
                .add("ComputeNodeGroupConfigurations",
                        hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null)
                .add("SlurmConfiguration", slurmConfiguration()).add("ErrorInfo", hasErrorInfo() ? errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "computeNodeGroupConfigurations":
            return Optional.ofNullable(clazz.cast(computeNodeGroupConfigurations()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("computeNodeGroupConfigurations", COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Queue> {
        /**
         * <p>
         * The name that identifies the queue.
         * </p>
         * 
         * @param name
         *        The name that identifies the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The generated unique ID of the queue.
         * </p>
         * 
         * @param id
         *        The generated unique ID of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the queue.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the cluster of the queue.
         * </p>
         * 
         * @param clusterId
         *        The ID of the cluster of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the resource was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the resource was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The provisioning status of the queue.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the queue.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the queue.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the queue.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The provisioning status of the queue.
         * </p>
         * <note>
         * <p>
         * The provisioning status doesn't indicate the overall health of the queue.
         * </p>
         * </note> <important>
         * <p>
         * The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler is
         * beyond end of life and we have suspended the cluster. When in these states, you can't use the cluster. The
         * cluster controller is down and all compute instances are terminated. The resources still count toward your
         * service quotas. You can delete a resource if its status is <code>SUSPENDED</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked questions
         * about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         * </p>
         * </important>
         * 
         * @param status
         *        The provisioning status of the queue.</p> <note>
         *        <p>
         *        The provisioning status doesn't indicate the overall health of the queue.
         *        </p>
         *        </note> <important>
         *        <p>
         *        The resource enters the <code>SUSPENDING</code> and <code>SUSPENDED</code> states when the scheduler
         *        is beyond end of life and we have suspended the cluster. When in these states, you can't use the
         *        cluster. The cluster controller is down and all compute instances are terminated. The resources still
         *        count toward your service quotas. You can delete a resource if its status is <code>SUSPENDED</code>.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/pcs/latest/userguide/slurm-versions_faq.html">Frequently asked
         *        questions about Slurm versions in PCS</a> in the <i>PCS User Guide</i>.
         *        </p>
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * <p>
         * The list of compute node group configurations associated with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations associated with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations associated with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations associated with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations associated with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #computeNodeGroupConfigurations(List<ComputeNodeGroupConfiguration>)}.
         * 
         * @param computeNodeGroupConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeNodeGroupConfigurations(java.util.Collection<ComputeNodeGroupConfiguration>)
         */
        Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(QueueSlurmConfiguration slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueSlurmConfiguration.Builder} avoiding
         * the need to create one manually via {@link QueueSlurmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueSlurmConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #slurmConfiguration(QueueSlurmConfiguration)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link QueueSlurmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(QueueSlurmConfiguration)
         */
        default Builder slurmConfiguration(Consumer<QueueSlurmConfiguration.Builder> slurmConfiguration) {
            return slurmConfiguration(QueueSlurmConfiguration.builder().applyMutation(slurmConfiguration).build());
        }

        /**
         * <p>
         * The list of errors that occurred during queue provisioning.
         * </p>
         * 
         * @param errorInfo
         *        The list of errors that occurred during queue provisioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(Collection<ErrorInfo> errorInfo);

        /**
         * <p>
         * The list of errors that occurred during queue provisioning.
         * </p>
         * 
         * @param errorInfo
         *        The list of errors that occurred during queue provisioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo... errorInfo);

        /**
         * <p>
         * The list of errors that occurred during queue provisioning.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.pcs.model.ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInfo(List<ErrorInfo>)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(java.util.Collection<ErrorInfo>)
         */
        Builder errorInfo(Consumer<ErrorInfo.Builder>... errorInfo);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String clusterId;

        private Instant createdAt;

        private Instant modifiedAt;

        private String status;

        private List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations = DefaultSdkAutoConstructList.getInstance();

        private QueueSlurmConfiguration slurmConfiguration;

        private List<ErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            clusterId(model.clusterId);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            status(model.status);
            computeNodeGroupConfigurations(model.computeNodeGroupConfigurations);
            slurmConfiguration(model.slurmConfiguration);
            errorInfo(model.errorInfo);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ComputeNodeGroupConfiguration.Builder> getComputeNodeGroupConfigurations() {
            List<ComputeNodeGroupConfiguration.Builder> result = ComputeNodeGroupConfigurationListCopier
                    .copyToBuilder(this.computeNodeGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration.BuilderImpl> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier
                    .copyFromBuilder(computeNodeGroupConfigurations);
        }

        @Override
        public final Builder computeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copy(computeNodeGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Arrays.asList(computeNodeGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(
                Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Stream.of(computeNodeGroupConfigurations)
                    .map(c -> ComputeNodeGroupConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final QueueSlurmConfiguration.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(QueueSlurmConfiguration.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(QueueSlurmConfiguration slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final List<ErrorInfo.Builder> getErrorInfo() {
            List<ErrorInfo.Builder> result = ErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<ErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<ErrorInfo> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(ErrorInfo... errorInfo) {
            errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<ErrorInfo.Builder>... errorInfo) {
            errorInfo(Stream.of(errorInfo).map(c -> ErrorInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Queue build() {
            return new Queue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
