/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional options related to the Slurm scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeNodeGroupSlurmConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeNodeGroupSlurmConfigurationRequest.Builder, ComputeNodeGroupSlurmConfigurationRequest> {
    private static final SdkField<List<SlurmCustomSetting>> SLURM_CUSTOM_SETTINGS_FIELD = SdkField
            .<List<SlurmCustomSetting>> builder(MarshallingType.LIST)
            .memberName("slurmCustomSettings")
            .getter(getter(ComputeNodeGroupSlurmConfigurationRequest::slurmCustomSettings))
            .setter(setter(Builder::slurmCustomSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmCustomSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlurmCustomSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlurmCustomSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLURM_CUSTOM_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SlurmCustomSetting> slurmCustomSettings;

    private ComputeNodeGroupSlurmConfigurationRequest(BuilderImpl builder) {
        this.slurmCustomSettings = builder.slurmCustomSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlurmCustomSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlurmCustomSettings() {
        return slurmCustomSettings != null && !(slurmCustomSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional Slurm-specific configuration that directly maps to Slurm settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlurmCustomSettings} method.
     * </p>
     * 
     * @return Additional Slurm-specific configuration that directly maps to Slurm settings.
     */
    public final List<SlurmCustomSetting> slurmCustomSettings() {
        return slurmCustomSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSlurmCustomSettings() ? slurmCustomSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeNodeGroupSlurmConfigurationRequest)) {
            return false;
        }
        ComputeNodeGroupSlurmConfigurationRequest other = (ComputeNodeGroupSlurmConfigurationRequest) obj;
        return hasSlurmCustomSettings() == other.hasSlurmCustomSettings()
                && Objects.equals(slurmCustomSettings(), other.slurmCustomSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeNodeGroupSlurmConfigurationRequest")
                .add("SlurmCustomSettings", hasSlurmCustomSettings() ? slurmCustomSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slurmCustomSettings":
            return Optional.ofNullable(clazz.cast(slurmCustomSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slurmCustomSettings", SLURM_CUSTOM_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeNodeGroupSlurmConfigurationRequest, T> g) {
        return obj -> g.apply((ComputeNodeGroupSlurmConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeNodeGroupSlurmConfigurationRequest> {
        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * 
         * @param slurmCustomSettings
         *        Additional Slurm-specific configuration that directly maps to Slurm settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmCustomSettings(Collection<SlurmCustomSetting> slurmCustomSettings);

        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * 
         * @param slurmCustomSettings
         *        Additional Slurm-specific configuration that directly maps to Slurm settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmCustomSettings(SlurmCustomSetting... slurmCustomSettings);

        /**
         * <p>
         * Additional Slurm-specific configuration that directly maps to Slurm settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #slurmCustomSettings(List<SlurmCustomSetting>)}.
         * 
         * @param slurmCustomSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.SlurmCustomSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmCustomSettings(java.util.Collection<SlurmCustomSetting>)
         */
        Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder>... slurmCustomSettings);
    }

    static final class BuilderImpl implements Builder {
        private List<SlurmCustomSetting> slurmCustomSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeNodeGroupSlurmConfigurationRequest model) {
            slurmCustomSettings(model.slurmCustomSettings);
        }

        public final List<SlurmCustomSetting.Builder> getSlurmCustomSettings() {
            List<SlurmCustomSetting.Builder> result = SlurmCustomSettingsCopier.copyToBuilder(this.slurmCustomSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlurmCustomSettings(Collection<SlurmCustomSetting.BuilderImpl> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copyFromBuilder(slurmCustomSettings);
        }

        @Override
        public final Builder slurmCustomSettings(Collection<SlurmCustomSetting> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copy(slurmCustomSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(SlurmCustomSetting... slurmCustomSettings) {
            slurmCustomSettings(Arrays.asList(slurmCustomSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder>... slurmCustomSettings) {
            slurmCustomSettings(Stream.of(slurmCustomSettings).map(c -> SlurmCustomSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ComputeNodeGroupSlurmConfigurationRequest build() {
            return new ComputeNodeGroupSlurmConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
