/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends PcsRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<SchedulerRequest> SCHEDULER_FIELD = SdkField
            .<SchedulerRequest> builder(MarshallingType.SDK_POJO).memberName("scheduler")
            .getter(getter(CreateClusterRequest::scheduler)).setter(setter(Builder::scheduler))
            .constructor(SchedulerRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduler").build()).build();

    private static final SdkField<String> SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("size")
            .getter(getter(CreateClusterRequest::sizeAsString)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<NetworkingRequest> NETWORKING_FIELD = SdkField
            .<NetworkingRequest> builder(MarshallingType.SDK_POJO).memberName("networking")
            .getter(getter(CreateClusterRequest::networking)).setter(setter(Builder::networking))
            .constructor(NetworkingRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()).build();

    private static final SdkField<ClusterSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField
            .<ClusterSlurmConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(CreateClusterRequest::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(ClusterSlurmConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            SCHEDULER_FIELD, SIZE_FIELD, NETWORKING_FIELD, SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final SchedulerRequest scheduler;

    private final String size;

    private final NetworkingRequest networking;

    private final ClusterSlurmConfigurationRequest slurmConfiguration;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.scheduler = builder.scheduler;
        this.size = builder.size;
        this.networking = builder.networking;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name to identify the cluster. Example: <code>MyCluster</code>
     * </p>
     * 
     * @return A name to identify the cluster. Example: <code>MyCluster</code>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The cluster management and job scheduling software associated with the cluster.
     * </p>
     * 
     * @return The cluster management and job scheduling software associated with the cluster.
     */
    public final SchedulerRequest scheduler() {
        return scheduler;
    }

    /**
     * <p>
     * A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs (active
     * and queued).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SMALL</code>: 32 compute nodes and 256 jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #size} will return
     * {@link Size#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sizeAsString}.
     * </p>
     * 
     * @return A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs
     *         (active and queued).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SMALL</code>: 32 compute nodes and 256 jobs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
     *         </p>
     *         </li>
     * @see Size
     */
    public final Size size() {
        return Size.fromValue(size);
    }

    /**
     * <p>
     * A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs (active
     * and queued).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SMALL</code>: 32 compute nodes and 256 jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #size} will return
     * {@link Size#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sizeAsString}.
     * </p>
     * 
     * @return A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs
     *         (active and queued).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SMALL</code>: 32 compute nodes and 256 jobs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
     *         </p>
     *         </li>
     * @see Size
     */
    public final String sizeAsString() {
        return size;
    }

    /**
     * <p>
     * The networking configuration used to set up the cluster's control plane.
     * </p>
     * 
     * @return The networking configuration used to set up the cluster's control plane.
     */
    public final NetworkingRequest networking() {
        return networking;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final ClusterSlurmConfigurationRequest slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect. If you don't specify a client token, the CLI and SDK automatically
     * generate 1 for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect. If you don't specify a client token,
     *         the CLI and SDK automatically generate 1 for you.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and
     * can be an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
     *         optional and can be an empty string.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduler());
        hashCode = 31 * hashCode + Objects.hashCode(sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networking());
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(scheduler(), other.scheduler())
                && Objects.equals(sizeAsString(), other.sizeAsString()) && Objects.equals(networking(), other.networking())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("ClusterName", clusterName()).add("Scheduler", scheduler())
                .add("Size", sizeAsString()).add("Networking", networking()).add("SlurmConfiguration", slurmConfiguration())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "scheduler":
            return Optional.ofNullable(clazz.cast(scheduler()));
        case "size":
            return Optional.ofNullable(clazz.cast(sizeAsString()));
        case "networking":
            return Optional.ofNullable(clazz.cast(networking()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("scheduler", SCHEDULER_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("networking", NETWORKING_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * A name to identify the cluster. Example: <code>MyCluster</code>
         * </p>
         * 
         * @param clusterName
         *        A name to identify the cluster. Example: <code>MyCluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The cluster management and job scheduling software associated with the cluster.
         * </p>
         * 
         * @param scheduler
         *        The cluster management and job scheduling software associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduler(SchedulerRequest scheduler);

        /**
         * <p>
         * The cluster management and job scheduling software associated with the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchedulerRequest.Builder} avoiding the
         * need to create one manually via {@link SchedulerRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchedulerRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #scheduler(SchedulerRequest)}.
         * 
         * @param scheduler
         *        a consumer that will call methods on {@link SchedulerRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduler(SchedulerRequest)
         */
        default Builder scheduler(Consumer<SchedulerRequest.Builder> scheduler) {
            return scheduler(SchedulerRequest.builder().applyMutation(scheduler).build());
        }

        /**
         * <p>
         * A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs
         * (active and queued).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SMALL</code>: 32 compute nodes and 256 jobs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
         * </p>
         * </li>
         * </ul>
         * 
         * @param size
         *        A value that determines the maximum number of compute nodes in the cluster and the maximum number of
         *        jobs (active and queued).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SMALL</code>: 32 compute nodes and 256 jobs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
         *        </p>
         *        </li>
         * @see Size
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Size
         */
        Builder size(String size);

        /**
         * <p>
         * A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs
         * (active and queued).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SMALL</code>: 32 compute nodes and 256 jobs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
         * </p>
         * </li>
         * </ul>
         * 
         * @param size
         *        A value that determines the maximum number of compute nodes in the cluster and the maximum number of
         *        jobs (active and queued).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SMALL</code>: 32 compute nodes and 256 jobs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code>: 512 compute nodes and 8192 jobs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LARGE</code>: 2048 compute nodes and 16,384 jobs
         *        </p>
         *        </li>
         * @see Size
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Size
         */
        Builder size(Size size);

        /**
         * <p>
         * The networking configuration used to set up the cluster's control plane.
         * </p>
         * 
         * @param networking
         *        The networking configuration used to set up the cluster's control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networking(NetworkingRequest networking);

        /**
         * <p>
         * The networking configuration used to set up the cluster's control plane.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkingRequest.Builder} avoiding the
         * need to create one manually via {@link NetworkingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkingRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #networking(NetworkingRequest)}.
         * 
         * @param networking
         *        a consumer that will call methods on {@link NetworkingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networking(NetworkingRequest)
         */
        default Builder networking(Consumer<NetworkingRequest.Builder> networking) {
            return networking(NetworkingRequest.builder().applyMutation(networking).build());
        }

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(ClusterSlurmConfigurationRequest slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterSlurmConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ClusterSlurmConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterSlurmConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #slurmConfiguration(ClusterSlurmConfigurationRequest)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link ClusterSlurmConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(ClusterSlurmConfigurationRequest)
         */
        default Builder slurmConfiguration(Consumer<ClusterSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return slurmConfiguration(ClusterSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect. If you don't specify a client token, the CLI and SDK
         * automatically generate 1 for you.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect. If you don't specify a
         *        client token, the CLI and SDK automatically generate 1 for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional
         * and can be an empty string.
         * </p>
         * 
         * @param tags
         *        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is
         *        optional and can be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcsRequest.BuilderImpl implements Builder {
        private String clusterName;

        private SchedulerRequest scheduler;

        private String size;

        private NetworkingRequest networking;

        private ClusterSlurmConfigurationRequest slurmConfiguration;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            scheduler(model.scheduler);
            size(model.size);
            networking(model.networking);
            slurmConfiguration(model.slurmConfiguration);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final SchedulerRequest.Builder getScheduler() {
            return scheduler != null ? scheduler.toBuilder() : null;
        }

        public final void setScheduler(SchedulerRequest.BuilderImpl scheduler) {
            this.scheduler = scheduler != null ? scheduler.build() : null;
        }

        @Override
        public final Builder scheduler(SchedulerRequest scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public final String getSize() {
            return size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(Size size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final NetworkingRequest.Builder getNetworking() {
            return networking != null ? networking.toBuilder() : null;
        }

        public final void setNetworking(NetworkingRequest.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        @Override
        public final Builder networking(NetworkingRequest networking) {
            this.networking = networking;
            return this;
        }

        public final ClusterSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ClusterSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ClusterSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
