/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The JWT authentication configuration for Slurm REST API access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JwtAuth implements SdkPojo, Serializable, ToCopyableBuilder<JwtAuth.Builder, JwtAuth> {
    private static final SdkField<JwtKey> JWT_KEY_FIELD = SdkField.<JwtKey> builder(MarshallingType.SDK_POJO)
            .memberName("jwtKey").getter(getter(JwtAuth::jwtKey)).setter(setter(Builder::jwtKey)).constructor(JwtKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JWT_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JwtKey jwtKey;

    private JwtAuth(BuilderImpl builder) {
        this.jwtKey = builder.jwtKey;
    }

    /**
     * <p>
     * The JWT key for Slurm REST API authentication.
     * </p>
     * 
     * @return The JWT key for Slurm REST API authentication.
     */
    public final JwtKey jwtKey() {
        return jwtKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jwtKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtAuth)) {
            return false;
        }
        JwtAuth other = (JwtAuth) obj;
        return Objects.equals(jwtKey(), other.jwtKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JwtAuth").add("JwtKey", jwtKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jwtKey":
            return Optional.ofNullable(clazz.cast(jwtKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jwtKey", JWT_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JwtAuth, T> g) {
        return obj -> g.apply((JwtAuth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JwtAuth> {
        /**
         * <p>
         * The JWT key for Slurm REST API authentication.
         * </p>
         * 
         * @param jwtKey
         *        The JWT key for Slurm REST API authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtKey(JwtKey jwtKey);

        /**
         * <p>
         * The JWT key for Slurm REST API authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link JwtKey.Builder} avoiding the need to
         * create one manually via {@link JwtKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JwtKey.Builder#build()} is called immediately and its result is
         * passed to {@link #jwtKey(JwtKey)}.
         * 
         * @param jwtKey
         *        a consumer that will call methods on {@link JwtKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jwtKey(JwtKey)
         */
        default Builder jwtKey(Consumer<JwtKey.Builder> jwtKey) {
            return jwtKey(JwtKey.builder().applyMutation(jwtKey).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JwtKey jwtKey;

        private BuilderImpl() {
        }

        private BuilderImpl(JwtAuth model) {
            jwtKey(model.jwtKey);
        }

        public final JwtKey.Builder getJwtKey() {
            return jwtKey != null ? jwtKey.toBuilder() : null;
        }

        public final void setJwtKey(JwtKey.BuilderImpl jwtKey) {
            this.jwtKey = jwtKey != null ? jwtKey.build() : null;
        }

        @Override
        public final Builder jwtKey(JwtKey jwtKey) {
            this.jwtKey = jwtKey;
            return this;
        }

        @Override
        public JwtAuth build() {
            return new JwtAuth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
