/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQueueRequest extends PcsRequest implements
        ToCopyableBuilder<UpdateQueueRequest.Builder, UpdateQueueRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(UpdateQueueRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final SdkField<String> QUEUE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueIdentifier").getter(getter(UpdateQueueRequest::queueIdentifier))
            .setter(setter(Builder::queueIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueIdentifier").build()).build();

    private static final SdkField<List<ComputeNodeGroupConfiguration>> COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD = SdkField
            .<List<ComputeNodeGroupConfiguration>> builder(MarshallingType.LIST)
            .memberName("computeNodeGroupConfigurations")
            .getter(getter(UpdateQueueRequest::computeNodeGroupConfigurations))
            .setter(setter(Builder::computeNodeGroupConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeNodeGroupConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeNodeGroupConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UpdateQueueSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField
            .<UpdateQueueSlurmConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("slurmConfiguration")
            .getter(getter(UpdateQueueRequest::slurmConfiguration)).setter(setter(Builder::slurmConfiguration))
            .constructor(UpdateQueueSlurmConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateQueueRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            QUEUE_IDENTIFIER_FIELD, COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD, SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String queueIdentifier;

    private final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations;

    private final UpdateQueueSlurmConfigurationRequest slurmConfiguration;

    private final String clientToken;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.queueIdentifier = builder.queueIdentifier;
        this.computeNodeGroupConfigurations = builder.computeNodeGroupConfigurations;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name or ID of the cluster of the queue.
     * </p>
     * 
     * @return The name or ID of the cluster of the queue.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name or ID of the queue.
     * </p>
     * 
     * @return The name or ID of the queue.
     */
    public final String queueIdentifier() {
        return queueIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeNodeGroupConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations != null && !(computeNodeGroupConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
     * compute node groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeNodeGroupConfigurations} method.
     * </p>
     * 
     * @return The list of compute node group configurations to associate with the queue. Queues assign jobs to
     *         associated compute node groups.
     */
    public final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations() {
        return computeNodeGroupConfigurations;
    }

    /**
     * <p>
     * Additional options related to the Slurm scheduler.
     * </p>
     * 
     * @return Additional options related to the Slurm scheduler.
     */
    public final UpdateQueueSlurmConfigurationRequest slurmConfiguration() {
        return slurmConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect. If you don't specify a client token, the CLI and SDK automatically
     * generate 1 for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect. If you don't specify a client token,
     *         the CLI and SDK automatically generate 1 for you.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queueIdentifier());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(queueIdentifier(), other.queueIdentifier())
                && hasComputeNodeGroupConfigurations() == other.hasComputeNodeGroupConfigurations()
                && Objects.equals(computeNodeGroupConfigurations(), other.computeNodeGroupConfigurations())
                && Objects.equals(slurmConfiguration(), other.slurmConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateQueueRequest")
                .add("ClusterIdentifier", clusterIdentifier())
                .add("QueueIdentifier", queueIdentifier())
                .add("ComputeNodeGroupConfigurations",
                        hasComputeNodeGroupConfigurations() ? computeNodeGroupConfigurations() : null)
                .add("SlurmConfiguration", slurmConfiguration()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "queueIdentifier":
            return Optional.ofNullable(clazz.cast(queueIdentifier()));
        case "computeNodeGroupConfigurations":
            return Optional.ofNullable(clazz.cast(computeNodeGroupConfigurations()));
        case "slurmConfiguration":
            return Optional.ofNullable(clazz.cast(slurmConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("queueIdentifier", QUEUE_IDENTIFIER_FIELD);
        map.put("computeNodeGroupConfigurations", COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueRequest, T> g) {
        return obj -> g.apply((UpdateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQueueRequest> {
        /**
         * <p>
         * The name or ID of the cluster of the queue.
         * </p>
         * 
         * @param clusterIdentifier
         *        The name or ID of the cluster of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name or ID of the queue.
         * </p>
         * 
         * @param queueIdentifier
         *        The name or ID of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueIdentifier(String queueIdentifier);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations to associate with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * 
         * @param computeNodeGroupConfigurations
         *        The list of compute node group configurations to associate with the queue. Queues assign jobs to
         *        associated compute node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations);

        /**
         * <p>
         * The list of compute node group configurations to associate with the queue. Queues assign jobs to associated
         * compute node groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #computeNodeGroupConfigurations(List<ComputeNodeGroupConfiguration>)}.
         * 
         * @param computeNodeGroupConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeNodeGroupConfigurations(java.util.Collection<ComputeNodeGroupConfiguration>)
         */
        Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * 
         * @param slurmConfiguration
         *        Additional options related to the Slurm scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slurmConfiguration(UpdateQueueSlurmConfigurationRequest slurmConfiguration);

        /**
         * <p>
         * Additional options related to the Slurm scheduler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateQueueSlurmConfigurationRequest.Builder} avoiding the need to create one manually via
         * {@link UpdateQueueSlurmConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateQueueSlurmConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #slurmConfiguration(UpdateQueueSlurmConfigurationRequest)}.
         * 
         * @param slurmConfiguration
         *        a consumer that will call methods on {@link UpdateQueueSlurmConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slurmConfiguration(UpdateQueueSlurmConfigurationRequest)
         */
        default Builder slurmConfiguration(Consumer<UpdateQueueSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return slurmConfiguration(UpdateQueueSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect. If you don't specify a client token, the CLI and SDK
         * automatically generate 1 for you.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect. If you don't specify a
         *        client token, the CLI and SDK automatically generate 1 for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcsRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String queueIdentifier;

        private List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations = DefaultSdkAutoConstructList.getInstance();

        private UpdateQueueSlurmConfigurationRequest slurmConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            queueIdentifier(model.queueIdentifier);
            computeNodeGroupConfigurations(model.computeNodeGroupConfigurations);
            slurmConfiguration(model.slurmConfiguration);
            clientToken(model.clientToken);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getQueueIdentifier() {
            return queueIdentifier;
        }

        public final void setQueueIdentifier(String queueIdentifier) {
            this.queueIdentifier = queueIdentifier;
        }

        @Override
        public final Builder queueIdentifier(String queueIdentifier) {
            this.queueIdentifier = queueIdentifier;
            return this;
        }

        public final List<ComputeNodeGroupConfiguration.Builder> getComputeNodeGroupConfigurations() {
            List<ComputeNodeGroupConfiguration.Builder> result = ComputeNodeGroupConfigurationListCopier
                    .copyToBuilder(this.computeNodeGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration.BuilderImpl> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier
                    .copyFromBuilder(computeNodeGroupConfigurations);
        }

        @Override
        public final Builder computeNodeGroupConfigurations(
                Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copy(computeNodeGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Arrays.asList(computeNodeGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(
                Consumer<ComputeNodeGroupConfiguration.Builder>... computeNodeGroupConfigurations) {
            computeNodeGroupConfigurations(Stream.of(computeNodeGroupConfigurations)
                    .map(c -> ComputeNodeGroupConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final UpdateQueueSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return slurmConfiguration != null ? slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(UpdateQueueSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(UpdateQueueSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
