/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolutionVersionsResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListSolutionVersionsResponse.Builder, ListSolutionVersionsResponse> {
    private static final SdkField<List<SolutionVersionSummary>> SOLUTION_VERSIONS_FIELD = SdkField
            .<List<SolutionVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListSolutionVersionsResponse::solutionVersions))
            .setter(setter(Builder::solutionVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SolutionVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SolutionVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSolutionVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SolutionVersionSummary> solutionVersions;

    private final String nextToken;

    private ListSolutionVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionVersions = builder.solutionVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of solution versions describing the version properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of solution versions describing the version properties.
     */
    public List<SolutionVersionSummary> solutionVersions() {
        return solutionVersions;
    }

    /**
     * <p>
     * A token for getting the next set of solution versions (if they exist).
     * </p>
     * 
     * @return A token for getting the next set of solution versions (if they exist).
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionVersionsResponse)) {
            return false;
        }
        ListSolutionVersionsResponse other = (ListSolutionVersionsResponse) obj;
        return Objects.equals(solutionVersions(), other.solutionVersions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSolutionVersionsResponse").add("SolutionVersions", solutionVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionVersions":
            return Optional.ofNullable(clazz.cast(solutionVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionVersionsResponse, T> g) {
        return obj -> g.apply((ListSolutionVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSolutionVersionsResponse> {
        /**
         * <p>
         * A list of solution versions describing the version properties.
         * </p>
         * 
         * @param solutionVersions
         *        A list of solution versions describing the version properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersions(Collection<SolutionVersionSummary> solutionVersions);

        /**
         * <p>
         * A list of solution versions describing the version properties.
         * </p>
         * 
         * @param solutionVersions
         *        A list of solution versions describing the version properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersions(SolutionVersionSummary... solutionVersions);

        /**
         * <p>
         * A list of solution versions describing the version properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SolutionVersionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<SolutionVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SolutionVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #solutionVersions(List<SolutionVersionSummary>)}.
         * 
         * @param solutionVersions
         *        a consumer that will call methods on {@link List<SolutionVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionVersions(List<SolutionVersionSummary>)
         */
        Builder solutionVersions(Consumer<SolutionVersionSummary.Builder>... solutionVersions);

        /**
         * <p>
         * A token for getting the next set of solution versions (if they exist).
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of solution versions (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<SolutionVersionSummary> solutionVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionVersionsResponse model) {
            super(model);
            solutionVersions(model.solutionVersions);
            nextToken(model.nextToken);
        }

        public final Collection<SolutionVersionSummary.Builder> getSolutionVersions() {
            return solutionVersions != null ? solutionVersions.stream().map(SolutionVersionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutionVersions(Collection<SolutionVersionSummary> solutionVersions) {
            this.solutionVersions = SolutionVersionsCopier.copy(solutionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionVersions(SolutionVersionSummary... solutionVersions) {
            solutionVersions(Arrays.asList(solutionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionVersions(Consumer<SolutionVersionSummary.Builder>... solutionVersions) {
            solutionVersions(Stream.of(solutionVersions).map(c -> SolutionVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSolutionVersions(Collection<SolutionVersionSummary.BuilderImpl> solutionVersions) {
            this.solutionVersions = SolutionVersionsCopier.copyFromBuilder(solutionVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSolutionVersionsResponse build() {
            return new ListSolutionVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
