/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that provides information about a solution. A solution is a trained model that can be deployed as a
 * campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Solution implements SdkPojo, Serializable, ToCopyableBuilder<Solution.Builder, Solution> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::solutionArn)).setter(setter(Builder::solutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()).build();

    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Solution::performHPO)).setter(setter(Builder::performHPO))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Solution::performAutoML)).setter(setter(Builder::performAutoML))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField
            .<SolutionConfig> builder(MarshallingType.SDK_POJO).getter(getter(Solution::solutionConfig))
            .setter(setter(Builder::solutionConfig)).constructor(SolutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()).build();

    private static final SdkField<AutoMLResult> AUTO_ML_RESULT_FIELD = SdkField.<AutoMLResult> builder(MarshallingType.SDK_POJO)
            .getter(getter(Solution::autoMLResult)).setter(setter(Builder::autoMLResult)).constructor(AutoMLResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMLResult").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Solution::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Solution::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Solution::lastUpdatedDateTime)).setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<SolutionVersionSummary> LATEST_SOLUTION_VERSION_FIELD = SdkField
            .<SolutionVersionSummary> builder(MarshallingType.SDK_POJO).getter(getter(Solution::latestSolutionVersion))
            .setter(setter(Builder::latestSolutionVersion)).constructor(SolutionVersionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSolutionVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SOLUTION_ARN_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, RECIPE_ARN_FIELD, DATASET_GROUP_ARN_FIELD,
            EVENT_TYPE_FIELD, SOLUTION_CONFIG_FIELD, AUTO_ML_RESULT_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD, LATEST_SOLUTION_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String solutionArn;

    private final Boolean performHPO;

    private final Boolean performAutoML;

    private final String recipeArn;

    private final String datasetGroupArn;

    private final String eventType;

    private final SolutionConfig solutionConfig;

    private final AutoMLResult autoMLResult;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final SolutionVersionSummary latestSolutionVersion;

    private Solution(BuilderImpl builder) {
        this.name = builder.name;
        this.solutionArn = builder.solutionArn;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.recipeArn = builder.recipeArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.eventType = builder.eventType;
        this.solutionConfig = builder.solutionConfig;
        this.autoMLResult = builder.autoMLResult;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.latestSolutionVersion = builder.latestSolutionVersion;
    }

    /**
     * <p>
     * The name of the solution.
     * </p>
     * 
     * @return The name of the solution.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the solution.
     * </p>
     * 
     * @return The ARN of the solution.
     */
    public String solutionArn() {
        return solutionArn;
    }

    /**
     * <p>
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.
     * </p>
     * 
     * @return Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is
     *         <code>false</code>.
     */
    public Boolean performHPO() {
        return performHPO;
    }

    /**
     * <p>
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified
     * in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon
     * Personalize uses <code>recipeArn</code> for training.
     * </p>
     * 
     * @return When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list
     *         specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the
     *         default), Amazon Personalize uses <code>recipeArn</code> for training.
     */
    public Boolean performAutoML() {
        return performAutoML;
    }

    /**
     * <p>
     * The ARN of the recipe used to create the solution.
     * </p>
     * 
     * @return The ARN of the recipe used to create the solution.
     */
    public String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    public String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The event type (for example, 'click' or 'like') that is used for training the model.
     * </p>
     * 
     * @return The event type (for example, 'click' or 'like') that is used for training the model.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * Describes the configuration properties for the solution.
     * </p>
     * 
     * @return Describes the configuration properties for the solution.
     */
    public SolutionConfig solutionConfig() {
        return solutionConfig;
    }

    /**
     * <p>
     * When <code>performAutoML</code> is true, specifies the best recipe found.
     * </p>
     * 
     * @return When <code>performAutoML</code> is true, specifies the best recipe found.
     */
    public AutoMLResult autoMLResult() {
        return autoMLResult;
    }

    /**
     * <p>
     * The status of the solution.
     * </p>
     * <p>
     * A solution can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the solution.</p>
     *         <p>
     *         A solution can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the solution.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the solution.
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the solution was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the solution was last updated.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * Describes the latest version of the solution, including the status and the ARN.
     * </p>
     * 
     * @return Describes the latest version of the solution, including the status and the ARN.
     */
    public SolutionVersionSummary latestSolutionVersion() {
        return latestSolutionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLResult());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestSolutionVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Solution)) {
            return false;
        }
        Solution other = (Solution) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(solutionArn(), other.solutionArn())
                && Objects.equals(performHPO(), other.performHPO()) && Objects.equals(performAutoML(), other.performAutoML())
                && Objects.equals(recipeArn(), other.recipeArn()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(eventType(), other.eventType()) && Objects.equals(solutionConfig(), other.solutionConfig())
                && Objects.equals(autoMLResult(), other.autoMLResult()) && Objects.equals(status(), other.status())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(latestSolutionVersion(), other.latestSolutionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Solution").add("Name", name()).add("SolutionArn", solutionArn()).add("PerformHPO", performHPO())
                .add("PerformAutoML", performAutoML()).add("RecipeArn", recipeArn()).add("DatasetGroupArn", datasetGroupArn())
                .add("EventType", eventType()).add("SolutionConfig", solutionConfig()).add("AutoMLResult", autoMLResult())
                .add("Status", status()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("LatestSolutionVersion", latestSolutionVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "solutionArn":
            return Optional.ofNullable(clazz.cast(solutionArn()));
        case "performHPO":
            return Optional.ofNullable(clazz.cast(performHPO()));
        case "performAutoML":
            return Optional.ofNullable(clazz.cast(performAutoML()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "solutionConfig":
            return Optional.ofNullable(clazz.cast(solutionConfig()));
        case "autoMLResult":
            return Optional.ofNullable(clazz.cast(autoMLResult()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "latestSolutionVersion":
            return Optional.ofNullable(clazz.cast(latestSolutionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Solution, T> g) {
        return obj -> g.apply((Solution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Solution> {
        /**
         * <p>
         * The name of the solution.
         * </p>
         * 
         * @param name
         *        The name of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the solution.
         * </p>
         * 
         * @param solutionArn
         *        The ARN of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionArn(String solutionArn);

        /**
         * <p>
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.
         * </p>
         * 
         * @param performHPO
         *        Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performHPO(Boolean performHPO);

        /**
         * <p>
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list
         * specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the
         * default), Amazon Personalize uses <code>recipeArn</code> for training.
         * </p>
         * 
         * @param performAutoML
         *        When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list
         *        specified in the solution configuration (<code>recipeArn</code> must not be specified). When false
         *        (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoML(Boolean performAutoML);

        /**
         * <p>
         * The ARN of the recipe used to create the solution.
         * </p>
         * 
         * @param recipeArn
         *        The ARN of the recipe used to create the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The event type (for example, 'click' or 'like') that is used for training the model.
         * </p>
         * 
         * @param eventType
         *        The event type (for example, 'click' or 'like') that is used for training the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * Describes the configuration properties for the solution.
         * </p>
         * 
         * @param solutionConfig
         *        Describes the configuration properties for the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionConfig(SolutionConfig solutionConfig);

        /**
         * <p>
         * Describes the configuration properties for the solution.
         * </p>
         * This is a convenience that creates an instance of the {@link SolutionConfig.Builder} avoiding the need to
         * create one manually via {@link SolutionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SolutionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #solutionConfig(SolutionConfig)}.
         * 
         * @param solutionConfig
         *        a consumer that will call methods on {@link SolutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionConfig(SolutionConfig)
         */
        default Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return solutionConfig(SolutionConfig.builder().applyMutation(solutionConfig).build());
        }

        /**
         * <p>
         * When <code>performAutoML</code> is true, specifies the best recipe found.
         * </p>
         * 
         * @param autoMLResult
         *        When <code>performAutoML</code> is true, specifies the best recipe found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLResult(AutoMLResult autoMLResult);

        /**
         * <p>
         * When <code>performAutoML</code> is true, specifies the best recipe found.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLResult.Builder} avoiding the need to
         * create one manually via {@link AutoMLResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLResult.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLResult(AutoMLResult)}.
         * 
         * @param autoMLResult
         *        a consumer that will call methods on {@link AutoMLResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLResult(AutoMLResult)
         */
        default Builder autoMLResult(Consumer<AutoMLResult.Builder> autoMLResult) {
            return autoMLResult(AutoMLResult.builder().applyMutation(autoMLResult).build());
        }

        /**
         * <p>
         * The status of the solution.
         * </p>
         * <p>
         * A solution can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the solution.</p>
         *        <p>
         *        A solution can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The creation date and time (in Unix time) of the solution.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the solution was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the solution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Describes the latest version of the solution, including the status and the ARN.
         * </p>
         * 
         * @param latestSolutionVersion
         *        Describes the latest version of the solution, including the status and the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSolutionVersion(SolutionVersionSummary latestSolutionVersion);

        /**
         * <p>
         * Describes the latest version of the solution, including the status and the ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link SolutionVersionSummary.Builder} avoiding the
         * need to create one manually via {@link SolutionVersionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SolutionVersionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #latestSolutionVersion(SolutionVersionSummary)}.
         * 
         * @param latestSolutionVersion
         *        a consumer that will call methods on {@link SolutionVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestSolutionVersion(SolutionVersionSummary)
         */
        default Builder latestSolutionVersion(Consumer<SolutionVersionSummary.Builder> latestSolutionVersion) {
            return latestSolutionVersion(SolutionVersionSummary.builder().applyMutation(latestSolutionVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String solutionArn;

        private Boolean performHPO;

        private Boolean performAutoML;

        private String recipeArn;

        private String datasetGroupArn;

        private String eventType;

        private SolutionConfig solutionConfig;

        private AutoMLResult autoMLResult;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private SolutionVersionSummary latestSolutionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Solution model) {
            name(model.name);
            solutionArn(model.solutionArn);
            performHPO(model.performHPO);
            performAutoML(model.performAutoML);
            recipeArn(model.recipeArn);
            datasetGroupArn(model.datasetGroupArn);
            eventType(model.eventType);
            solutionConfig(model.solutionConfig);
            autoMLResult(model.autoMLResult);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            latestSolutionVersion(model.latestSolutionVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSolutionArn() {
            return solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        public final Boolean getPerformHPO() {
            return performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        public final Boolean getPerformAutoML() {
            return performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return solutionConfig != null ? solutionConfig.toBuilder() : null;
        }

        @Override
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        public final AutoMLResult.Builder getAutoMLResult() {
            return autoMLResult != null ? autoMLResult.toBuilder() : null;
        }

        @Override
        public final Builder autoMLResult(AutoMLResult autoMLResult) {
            this.autoMLResult = autoMLResult;
            return this;
        }

        public final void setAutoMLResult(AutoMLResult.BuilderImpl autoMLResult) {
            this.autoMLResult = autoMLResult != null ? autoMLResult.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final SolutionVersionSummary.Builder getLatestSolutionVersion() {
            return latestSolutionVersion != null ? latestSolutionVersion.toBuilder() : null;
        }

        @Override
        public final Builder latestSolutionVersion(SolutionVersionSummary latestSolutionVersion) {
            this.latestSolutionVersion = latestSolutionVersion;
            return this;
        }

        public final void setLatestSolutionVersion(SolutionVersionSummary.BuilderImpl latestSolutionVersion) {
            this.latestSolutionVersion = latestSolutionVersion != null ? latestSolutionVersion.build() : null;
        }

        @Override
        public Solution build() {
            return new Solution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
