/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignConfig implements SdkPojo, Serializable, ToCopyableBuilder<CampaignConfig.Builder, CampaignConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CampaignConfig::itemExplorationConfig))
            .setter(setter(Builder::itemExplorationConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> itemExplorationConfig;

    private CampaignConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
    }

    /**
     * Returns true if the ItemExplorationConfig property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasItemExplorationConfig() {
        return itemExplorationConfig != null && !(itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string to string map specifying the inference hyperparameters you wish to use for hyperparameter optimization.
     * See <a>customizing-solution-config-hpo</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItemExplorationConfig()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A string to string map specifying the inference hyperparameters you wish to use for hyperparameter
     *         optimization. See <a>customizing-solution-config-hpo</a>.
     */
    public Map<String, String> itemExplorationConfig() {
        return itemExplorationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemExplorationConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignConfig)) {
            return false;
        }
        CampaignConfig other = (CampaignConfig) obj;
        return Objects.equals(itemExplorationConfig(), other.itemExplorationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignConfig").add("ItemExplorationConfig", itemExplorationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemExplorationConfig":
            return Optional.ofNullable(clazz.cast(itemExplorationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignConfig, T> g) {
        return obj -> g.apply((CampaignConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignConfig> {
        /**
         * <p>
         * A string to string map specifying the inference hyperparameters you wish to use for hyperparameter
         * optimization. See <a>customizing-solution-config-hpo</a>.
         * </p>
         * 
         * @param itemExplorationConfig
         *        A string to string map specifying the inference hyperparameters you wish to use for hyperparameter
         *        optimization. See <a>customizing-solution-config-hpo</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemExplorationConfig(Map<String, String> itemExplorationConfig);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignConfig model) {
            itemExplorationConfig(model.itemExplorationConfig);
        }

        public final Map<String, String> getItemExplorationConfig() {
            return itemExplorationConfig;
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public CampaignConfig build() {
            return new CampaignConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
