/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the hyperparameters and their default ranges. Hyperparameters can be categorical, continuous, or
 * integer-valued.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultHyperParameterRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultHyperParameterRanges.Builder, DefaultHyperParameterRanges> {
    private static final SdkField<List<DefaultIntegerHyperParameterRange>> INTEGER_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultIntegerHyperParameterRange>> builder(MarshallingType.LIST)
            .getter(getter(DefaultHyperParameterRanges::integerHyperParameterRanges))
            .setter(setter(Builder::integerHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultIntegerHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultIntegerHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DefaultContinuousHyperParameterRange>> CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultContinuousHyperParameterRange>> builder(MarshallingType.LIST)
            .getter(getter(DefaultHyperParameterRanges::continuousHyperParameterRanges))
            .setter(setter(Builder::continuousHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultContinuousHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultContinuousHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DefaultCategoricalHyperParameterRange>> CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultCategoricalHyperParameterRange>> builder(MarshallingType.LIST)
            .getter(getter(DefaultHyperParameterRanges::categoricalHyperParameterRanges))
            .setter(setter(Builder::categoricalHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoricalHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultCategoricalHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultCategoricalHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_HYPER_PARAMETER_RANGES_FIELD, CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD,
            CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges;

    private final List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges;

    private final List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges;

    private DefaultHyperParameterRanges(BuilderImpl builder) {
        this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
        this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
        this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
    }

    /**
     * Returns true if the IntegerHyperParameterRanges property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasIntegerHyperParameterRanges() {
        return integerHyperParameterRanges != null && !(integerHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The integer-valued hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntegerHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The integer-valued hyperparameters and their default ranges.
     */
    public List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges() {
        return integerHyperParameterRanges;
    }

    /**
     * Returns true if the ContinuousHyperParameterRanges property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasContinuousHyperParameterRanges() {
        return continuousHyperParameterRanges != null && !(continuousHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The continuous hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContinuousHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The continuous hyperparameters and their default ranges.
     */
    public List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges() {
        return continuousHyperParameterRanges;
    }

    /**
     * Returns true if the CategoricalHyperParameterRanges property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCategoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges != null && !(categoricalHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categorical hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCategoricalHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The categorical hyperparameters and their default ranges.
     */
    public List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integerHyperParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(continuousHyperParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalHyperParameterRanges());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultHyperParameterRanges)) {
            return false;
        }
        DefaultHyperParameterRanges other = (DefaultHyperParameterRanges) obj;
        return Objects.equals(integerHyperParameterRanges(), other.integerHyperParameterRanges())
                && Objects.equals(continuousHyperParameterRanges(), other.continuousHyperParameterRanges())
                && Objects.equals(categoricalHyperParameterRanges(), other.categoricalHyperParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefaultHyperParameterRanges").add("IntegerHyperParameterRanges", integerHyperParameterRanges())
                .add("ContinuousHyperParameterRanges", continuousHyperParameterRanges())
                .add("CategoricalHyperParameterRanges", categoricalHyperParameterRanges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(integerHyperParameterRanges()));
        case "continuousHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousHyperParameterRanges()));
        case "categoricalHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalHyperParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultHyperParameterRanges, T> g) {
        return obj -> g.apply((DefaultHyperParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultHyperParameterRanges> {
        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(Collection<DefaultIntegerHyperParameterRange> integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(DefaultIntegerHyperParameterRange... integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DefaultIntegerHyperParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<DefaultIntegerHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DefaultIntegerHyperParameterRange>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #integerHyperParameterRanges(List<DefaultIntegerHyperParameterRange>)}.
         * 
         * @param integerHyperParameterRanges
         *        a consumer that will call methods on {@link List<DefaultIntegerHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerHyperParameterRanges(List<DefaultIntegerHyperParameterRange>)
         */
        Builder integerHyperParameterRanges(Consumer<DefaultIntegerHyperParameterRange.Builder>... integerHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(Collection<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(DefaultContinuousHyperParameterRange... continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DefaultContinuousHyperParameterRange>.Builder} avoiding the need to create one manually via {@link List
         * <DefaultContinuousHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DefaultContinuousHyperParameterRange>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #continuousHyperParameterRanges(List<DefaultContinuousHyperParameterRange>)}.
         * 
         * @param continuousHyperParameterRanges
         *        a consumer that will call methods on {@link List<DefaultContinuousHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousHyperParameterRanges(List<DefaultContinuousHyperParameterRange>)
         */
        Builder continuousHyperParameterRanges(
                Consumer<DefaultContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(Collection<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(DefaultCategoricalHyperParameterRange... categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DefaultCategoricalHyperParameterRange>.Builder} avoiding the need to create one manually via {@link List
         * <DefaultCategoricalHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DefaultCategoricalHyperParameterRange>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #categoricalHyperParameterRanges(List<DefaultCategoricalHyperParameterRange>)}.
         * 
         * @param categoricalHyperParameterRanges
         *        a consumer that will call methods on {@link List<DefaultCategoricalHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalHyperParameterRanges(List<DefaultCategoricalHyperParameterRange>)
         */
        Builder categoricalHyperParameterRanges(
                Consumer<DefaultCategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges = DefaultSdkAutoConstructList
                .getInstance();

        private List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultHyperParameterRanges model) {
            integerHyperParameterRanges(model.integerHyperParameterRanges);
            continuousHyperParameterRanges(model.continuousHyperParameterRanges);
            categoricalHyperParameterRanges(model.categoricalHyperParameterRanges);
        }

        public final Collection<DefaultIntegerHyperParameterRange.Builder> getIntegerHyperParameterRanges() {
            return integerHyperParameterRanges != null ? integerHyperParameterRanges.stream()
                    .map(DefaultIntegerHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integerHyperParameterRanges(Collection<DefaultIntegerHyperParameterRange> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = DefaultIntegerHyperParameterRangesCopier.copy(integerHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(DefaultIntegerHyperParameterRange... integerHyperParameterRanges) {
            integerHyperParameterRanges(Arrays.asList(integerHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(
                Consumer<DefaultIntegerHyperParameterRange.Builder>... integerHyperParameterRanges) {
            integerHyperParameterRanges(Stream.of(integerHyperParameterRanges)
                    .map(c -> DefaultIntegerHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerHyperParameterRanges(
                Collection<DefaultIntegerHyperParameterRange.BuilderImpl> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = DefaultIntegerHyperParameterRangesCopier
                    .copyFromBuilder(integerHyperParameterRanges);
        }

        public final Collection<DefaultContinuousHyperParameterRange.Builder> getContinuousHyperParameterRanges() {
            return continuousHyperParameterRanges != null ? continuousHyperParameterRanges.stream()
                    .map(DefaultContinuousHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder continuousHyperParameterRanges(
                Collection<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = DefaultContinuousHyperParameterRangesCopier
                    .copy(continuousHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                DefaultContinuousHyperParameterRange... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Arrays.asList(continuousHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                Consumer<DefaultContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Stream.of(continuousHyperParameterRanges)
                    .map(c -> DefaultContinuousHyperParameterRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContinuousHyperParameterRanges(
                Collection<DefaultContinuousHyperParameterRange.BuilderImpl> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = DefaultContinuousHyperParameterRangesCopier
                    .copyFromBuilder(continuousHyperParameterRanges);
        }

        public final Collection<DefaultCategoricalHyperParameterRange.Builder> getCategoricalHyperParameterRanges() {
            return categoricalHyperParameterRanges != null ? categoricalHyperParameterRanges.stream()
                    .map(DefaultCategoricalHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoricalHyperParameterRanges(
                Collection<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = DefaultCategoricalHyperParameterRangesCopier
                    .copy(categoricalHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                DefaultCategoricalHyperParameterRange... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Arrays.asList(categoricalHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                Consumer<DefaultCategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Stream.of(categoricalHyperParameterRanges)
                    .map(c -> DefaultCategoricalHyperParameterRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCategoricalHyperParameterRanges(
                Collection<DefaultCategoricalHyperParameterRange.BuilderImpl> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = DefaultCategoricalHyperParameterRangesCopier
                    .copyFromBuilder(categoricalHyperParameterRanges);
        }

        @Override
        public DefaultHyperParameterRanges build() {
            return new DefaultHyperParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
