/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventTrackerRequest extends PersonalizeRequest implements
        ToCopyableBuilder<DeleteEventTrackerRequest.Builder, DeleteEventTrackerRequest> {
    private static final SdkField<String> EVENT_TRACKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteEventTrackerRequest::eventTrackerArn)).setter(setter(Builder::eventTrackerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRACKER_ARN_FIELD));

    private final String eventTrackerArn;

    private DeleteEventTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.eventTrackerArn = builder.eventTrackerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event tracker to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event tracker to delete.
     */
    public String eventTrackerArn() {
        return eventTrackerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTrackerArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventTrackerRequest)) {
            return false;
        }
        DeleteEventTrackerRequest other = (DeleteEventTrackerRequest) obj;
        return Objects.equals(eventTrackerArn(), other.eventTrackerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteEventTrackerRequest").add("EventTrackerArn", eventTrackerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTrackerArn":
            return Optional.ofNullable(clazz.cast(eventTrackerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventTrackerRequest, T> g) {
        return obj -> g.apply((DeleteEventTrackerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEventTrackerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event tracker to delete.
         * </p>
         * 
         * @param eventTrackerArn
         *        The Amazon Resource Name (ARN) of the event tracker to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrackerArn(String eventTrackerArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String eventTrackerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventTrackerRequest model) {
            super(model);
            eventTrackerArn(model.eventTrackerArn);
        }

        public final String getEventTrackerArn() {
            return eventTrackerArn;
        }

        @Override
        public final Builder eventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
            return this;
        }

        public final void setEventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEventTrackerRequest build() {
            return new DeleteEventTrackerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
