/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that provides information about a specific version of a <a>Solution</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionVersion implements SdkPojo, Serializable, ToCopyableBuilder<SolutionVersion.Builder, SolutionVersion> {
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::solutionVersionArn)).setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::solutionArn)).setter(setter(Builder::solutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()).build();

    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SolutionVersion::performHPO)).setter(setter(Builder::performHPO))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SolutionVersion::performAutoML)).setter(setter(Builder::performAutoML))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField
            .<SolutionConfig> builder(MarshallingType.SDK_POJO).getter(getter(SolutionVersion::solutionConfig))
            .setter(setter(Builder::solutionConfig)).constructor(SolutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()).build();

    private static final SdkField<Double> TRAINING_HOURS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SolutionVersion::trainingHours)).setter(setter(Builder::trainingHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingHours").build()).build();

    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::trainingModeAsString)).setter(setter(Builder::trainingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()).build();

    private static final SdkField<TunedHPOParams> TUNED_HPO_PARAMS_FIELD = SdkField
            .<TunedHPOParams> builder(MarshallingType.SDK_POJO).getter(getter(SolutionVersion::tunedHPOParams))
            .setter(setter(Builder::tunedHPOParams)).constructor(TunedHPOParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunedHPOParams").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionVersion::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SolutionVersion::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SolutionVersion::lastUpdatedDateTime)).setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_ARN_FIELD,
            SOLUTION_ARN_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, RECIPE_ARN_FIELD, EVENT_TYPE_FIELD,
            DATASET_GROUP_ARN_FIELD, SOLUTION_CONFIG_FIELD, TRAINING_HOURS_FIELD, TRAINING_MODE_FIELD, TUNED_HPO_PARAMS_FIELD,
            STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String solutionVersionArn;

    private final String solutionArn;

    private final Boolean performHPO;

    private final Boolean performAutoML;

    private final String recipeArn;

    private final String eventType;

    private final String datasetGroupArn;

    private final SolutionConfig solutionConfig;

    private final Double trainingHours;

    private final String trainingMode;

    private final TunedHPOParams tunedHPOParams;

    private final String status;

    private final String failureReason;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private SolutionVersion(BuilderImpl builder) {
        this.solutionVersionArn = builder.solutionVersionArn;
        this.solutionArn = builder.solutionArn;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.recipeArn = builder.recipeArn;
        this.eventType = builder.eventType;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.solutionConfig = builder.solutionConfig;
        this.trainingHours = builder.trainingHours;
        this.trainingMode = builder.trainingMode;
        this.tunedHPOParams = builder.tunedHPOParams;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The ARN of the solution version.
     * </p>
     * 
     * @return The ARN of the solution version.
     */
    public String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The ARN of the solution.
     * </p>
     * 
     * @return The ARN of the solution.
     */
    public String solutionArn() {
        return solutionArn;
    }

    /**
     * <p>
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.
     * </p>
     * 
     * @return Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is
     *         <code>false</code>.
     */
    public Boolean performHPO() {
        return performHPO;
    }

    /**
     * <p>
     * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When
     * false (the default), Amazon Personalize uses <code>recipeArn</code>.
     * </p>
     * 
     * @return When true, Amazon Personalize searches for the most optimal recipe according to the solution
     *         configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.
     */
    public Boolean performAutoML() {
        return performAutoML;
    }

    /**
     * <p>
     * The ARN of the recipe used in the solution.
     * </p>
     * 
     * @return The ARN of the recipe used in the solution.
     */
    public String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The event type (for example, 'click' or 'like') that is used for training the model.
     * </p>
     * 
     * @return The event type (for example, 'click' or 'like') that is used for training the model.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group providing the training data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group providing the training data.
     */
    public String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * Describes the configuration properties for the solution.
     * </p>
     * 
     * @return Describes the configuration properties for the solution.
     */
    public SolutionConfig solutionConfig() {
        return solutionConfig;
    }

    /**
     * <p>
     * The time used to train the model. You are billed for the time it takes to train a model. This field is visible
     * only after Amazon Personalize successfully trains a model.
     * </p>
     * 
     * @return The time used to train the model. You are billed for the time it takes to train a model. This field is
     *         visible only after Amazon Personalize successfully trains a model.
     */
    public Double trainingHours() {
        return trainingHours;
    }

    /**
     * <p>
     * The scope of training used to create the solution version. The <code>FULL</code> option trains the solution
     * version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option
     * processes only the training data that has changed since the creation of the last solution version. Choose
     * <code>UPDATE</code> when you want to start recommending items added to the dataset without retraining the model.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used after you've created a solution version with the
     * <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training used to create the solution version. The <code>FULL</code> option trains the
     *         solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the training data that has changed since the creation of the
     *         last solution version. Choose <code>UPDATE</code> when you want to start recommending items added to the
     *         dataset without retraining the model.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used after you've created a solution version with the
     *         <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
     *         </p>
     * @see TrainingMode
     */
    public TrainingMode trainingMode() {
        return TrainingMode.fromValue(trainingMode);
    }

    /**
     * <p>
     * The scope of training used to create the solution version. The <code>FULL</code> option trains the solution
     * version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option
     * processes only the training data that has changed since the creation of the last solution version. Choose
     * <code>UPDATE</code> when you want to start recommending items added to the dataset without retraining the model.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used after you've created a solution version with the
     * <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training used to create the solution version. The <code>FULL</code> option trains the
     *         solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the training data that has changed since the creation of the
     *         last solution version. Choose <code>UPDATE</code> when you want to start recommending items added to the
     *         dataset without retraining the model.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used after you've created a solution version with the
     *         <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
     *         </p>
     * @see TrainingMode
     */
    public String trainingModeAsString() {
        return trainingMode;
    }

    /**
     * <p>
     * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.
     * </p>
     * 
     * @return If hyperparameter optimization was performed, contains the hyperparameter values of the best performing
     *         model.
     */
    public TunedHPOParams tunedHPOParams() {
        return tunedHPOParams;
    }

    /**
     * <p>
     * The status of the solution version.
     * </p>
     * <p>
     * A solution version can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the solution version.</p>
     *         <p>
     *         A solution version can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE IN_PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * If training a solution version fails, the reason for the failure.
     * </p>
     * 
     * @return If training a solution version fails, the reason for the failure.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date and time (in Unix time) that this version of the solution was created.
     * </p>
     * 
     * @return The date and time (in Unix time) that this version of the solution was created.
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the solution was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the solution was last updated.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingHours());
        hashCode = 31 * hashCode + Objects.hashCode(trainingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tunedHPOParams());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionVersion)) {
            return false;
        }
        SolutionVersion other = (SolutionVersion) obj;
        return Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(solutionArn(), other.solutionArn()) && Objects.equals(performHPO(), other.performHPO())
                && Objects.equals(performAutoML(), other.performAutoML()) && Objects.equals(recipeArn(), other.recipeArn())
                && Objects.equals(eventType(), other.eventType()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(solutionConfig(), other.solutionConfig())
                && Objects.equals(trainingHours(), other.trainingHours())
                && Objects.equals(trainingModeAsString(), other.trainingModeAsString())
                && Objects.equals(tunedHPOParams(), other.tunedHPOParams()) && Objects.equals(status(), other.status())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SolutionVersion").add("SolutionVersionArn", solutionVersionArn())
                .add("SolutionArn", solutionArn()).add("PerformHPO", performHPO()).add("PerformAutoML", performAutoML())
                .add("RecipeArn", recipeArn()).add("EventType", eventType()).add("DatasetGroupArn", datasetGroupArn())
                .add("SolutionConfig", solutionConfig()).add("TrainingHours", trainingHours())
                .add("TrainingMode", trainingModeAsString()).add("TunedHPOParams", tunedHPOParams()).add("Status", status())
                .add("FailureReason", failureReason()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "solutionArn":
            return Optional.ofNullable(clazz.cast(solutionArn()));
        case "performHPO":
            return Optional.ofNullable(clazz.cast(performHPO()));
        case "performAutoML":
            return Optional.ofNullable(clazz.cast(performAutoML()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "solutionConfig":
            return Optional.ofNullable(clazz.cast(solutionConfig()));
        case "trainingHours":
            return Optional.ofNullable(clazz.cast(trainingHours()));
        case "trainingMode":
            return Optional.ofNullable(clazz.cast(trainingModeAsString()));
        case "tunedHPOParams":
            return Optional.ofNullable(clazz.cast(tunedHPOParams()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionVersion, T> g) {
        return obj -> g.apply((SolutionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionVersion> {
        /**
         * <p>
         * The ARN of the solution version.
         * </p>
         * 
         * @param solutionVersionArn
         *        The ARN of the solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The ARN of the solution.
         * </p>
         * 
         * @param solutionArn
         *        The ARN of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionArn(String solutionArn);

        /**
         * <p>
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.
         * </p>
         * 
         * @param performHPO
         *        Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performHPO(Boolean performHPO);

        /**
         * <p>
         * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration.
         * When false (the default), Amazon Personalize uses <code>recipeArn</code>.
         * </p>
         * 
         * @param performAutoML
         *        When true, Amazon Personalize searches for the most optimal recipe according to the solution
         *        configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoML(Boolean performAutoML);

        /**
         * <p>
         * The ARN of the recipe used in the solution.
         * </p>
         * 
         * @param recipeArn
         *        The ARN of the recipe used in the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The event type (for example, 'click' or 'like') that is used for training the model.
         * </p>
         * 
         * @param eventType
         *        The event type (for example, 'click' or 'like') that is used for training the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group providing the training data.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group providing the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * Describes the configuration properties for the solution.
         * </p>
         * 
         * @param solutionConfig
         *        Describes the configuration properties for the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionConfig(SolutionConfig solutionConfig);

        /**
         * <p>
         * Describes the configuration properties for the solution.
         * </p>
         * This is a convenience that creates an instance of the {@link SolutionConfig.Builder} avoiding the need to
         * create one manually via {@link SolutionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SolutionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #solutionConfig(SolutionConfig)}.
         * 
         * @param solutionConfig
         *        a consumer that will call methods on {@link SolutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionConfig(SolutionConfig)
         */
        default Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return solutionConfig(SolutionConfig.builder().applyMutation(solutionConfig).build());
        }

        /**
         * <p>
         * The time used to train the model. You are billed for the time it takes to train a model. This field is
         * visible only after Amazon Personalize successfully trains a model.
         * </p>
         * 
         * @param trainingHours
         *        The time used to train the model. You are billed for the time it takes to train a model. This field is
         *        visible only after Amazon Personalize successfully trains a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingHours(Double trainingHours);

        /**
         * <p>
         * The scope of training used to create the solution version. The <code>FULL</code> option trains the solution
         * version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option
         * processes only the training data that has changed since the creation of the last solution version. Choose
         * <code>UPDATE</code> when you want to start recommending items added to the dataset without retraining the
         * model.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used after you've created a solution version with the
         * <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training used to create the solution version. The <code>FULL</code> option trains the
         *        solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the training data that has changed since the creation of the
         *        last solution version. Choose <code>UPDATE</code> when you want to start recommending items added to
         *        the dataset without retraining the model.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used after you've created a solution version with the
         *        <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(String trainingMode);

        /**
         * <p>
         * The scope of training used to create the solution version. The <code>FULL</code> option trains the solution
         * version based on the entirety of the input solution's training data, while the <code>UPDATE</code> option
         * processes only the training data that has changed since the creation of the last solution version. Choose
         * <code>UPDATE</code> when you want to start recommending items added to the dataset without retraining the
         * model.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used after you've created a solution version with the
         * <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training used to create the solution version. The <code>FULL</code> option trains the
         *        solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the training data that has changed since the creation of the
         *        last solution version. Choose <code>UPDATE</code> when you want to start recommending items added to
         *        the dataset without retraining the model.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used after you've created a solution version with the
         *        <code>FULL</code> option and the training solution uses the <a>native-recipe-hrnn-coldstart</a>.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(TrainingMode trainingMode);

        /**
         * <p>
         * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing
         * model.
         * </p>
         * 
         * @param tunedHPOParams
         *        If hyperparameter optimization was performed, contains the hyperparameter values of the best
         *        performing model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunedHPOParams(TunedHPOParams tunedHPOParams);

        /**
         * <p>
         * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing
         * model.
         * </p>
         * This is a convenience that creates an instance of the {@link TunedHPOParams.Builder} avoiding the need to
         * create one manually via {@link TunedHPOParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link TunedHPOParams.Builder#build()} is called immediately and its
         * result is passed to {@link #tunedHPOParams(TunedHPOParams)}.
         * 
         * @param tunedHPOParams
         *        a consumer that will call methods on {@link TunedHPOParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunedHPOParams(TunedHPOParams)
         */
        default Builder tunedHPOParams(Consumer<TunedHPOParams.Builder> tunedHPOParams) {
            return tunedHPOParams(TunedHPOParams.builder().applyMutation(tunedHPOParams).build());
        }

        /**
         * <p>
         * The status of the solution version.
         * </p>
         * <p>
         * A solution version can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the solution version.</p>
         *        <p>
         *        A solution version can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE IN_PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If training a solution version fails, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If training a solution version fails, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date and time (in Unix time) that this version of the solution was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix time) that this version of the solution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the solution was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the solution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String solutionVersionArn;

        private String solutionArn;

        private Boolean performHPO;

        private Boolean performAutoML;

        private String recipeArn;

        private String eventType;

        private String datasetGroupArn;

        private SolutionConfig solutionConfig;

        private Double trainingHours;

        private String trainingMode;

        private TunedHPOParams tunedHPOParams;

        private String status;

        private String failureReason;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionVersion model) {
            solutionVersionArn(model.solutionVersionArn);
            solutionArn(model.solutionArn);
            performHPO(model.performHPO);
            performAutoML(model.performAutoML);
            recipeArn(model.recipeArn);
            eventType(model.eventType);
            datasetGroupArn(model.datasetGroupArn);
            solutionConfig(model.solutionConfig);
            trainingHours(model.trainingHours);
            trainingMode(model.trainingMode);
            tunedHPOParams(model.tunedHPOParams);
            status(model.status);
            failureReason(model.failureReason);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final String getSolutionArn() {
            return solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        public final Boolean getPerformHPO() {
            return performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        public final Boolean getPerformAutoML() {
            return performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return solutionConfig != null ? solutionConfig.toBuilder() : null;
        }

        @Override
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        public final Double getTrainingHours() {
            return trainingHours;
        }

        @Override
        public final Builder trainingHours(Double trainingHours) {
            this.trainingHours = trainingHours;
            return this;
        }

        public final void setTrainingHours(Double trainingHours) {
            this.trainingHours = trainingHours;
        }

        public final String getTrainingMode() {
            return trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        public final TunedHPOParams.Builder getTunedHPOParams() {
            return tunedHPOParams != null ? tunedHPOParams.toBuilder() : null;
        }

        @Override
        public final Builder tunedHPOParams(TunedHPOParams tunedHPOParams) {
            this.tunedHPOParams = tunedHPOParams;
            return this;
        }

        public final void setTunedHPOParams(TunedHPOParams.BuilderImpl tunedHPOParams) {
            this.tunedHPOParams = tunedHPOParams != null ? tunedHPOParams.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public SolutionVersion build() {
            return new SolutionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
