/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data source that contains the data to upload to a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSource implements SdkPojo, Serializable, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private static final SdkField<String> DATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLocation").getter(getter(DataSource::dataLocation)).setter(setter(Builder::dataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataLocation;

    private DataSource(BuilderImpl builder) {
        this.dataLocation = builder.dataLocation;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For example:
     * </p>
     * <p>
     * <code>s3://bucket-name/training-data.csv</code>
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For
     *         example: </p>
     *         <p>
     *         <code>s3://bucket-name/training-data.csv</code>
     */
    public String dataLocation() {
        return dataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        return Objects.equals(dataLocation(), other.dataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSource").add("DataLocation", dataLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataLocation":
            return Optional.ofNullable(clazz.cast(dataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For
         * example:
         * </p>
         * <p>
         * <code>s3://bucket-name/training-data.csv</code>
         * </p>
         * 
         * @param dataLocation
         *        The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For
         *        example: </p>
         *        <p>
         *        <code>s3://bucket-name/training-data.csv</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocation(String dataLocation);
    }

    static final class BuilderImpl implements Builder {
        private String dataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            dataLocation(model.dataLocation);
        }

        public final String getDataLocation() {
            return dataLocation;
        }

        @Override
        public final Builder dataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final void setDataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
