/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides feature transformation information. Feature transformation is the process of modifying raw input data into a
 * form more suitable for model training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeatureTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<FeatureTransformation.Builder, FeatureTransformation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FeatureTransformation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FEATURE_TRANSFORMATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureTransformationArn").getter(getter(FeatureTransformation::featureTransformationArn))
            .setter(setter(Builder::featureTransformationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationArn").build())
            .build();

    private static final SdkField<Map<String, String>> DEFAULT_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("defaultParameters")
            .getter(getter(FeatureTransformation::defaultParameters))
            .setter(setter(Builder::defaultParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(FeatureTransformation::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(FeatureTransformation::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FeatureTransformation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            FEATURE_TRANSFORMATION_ARN_FIELD, DEFAULT_PARAMETERS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String featureTransformationArn;

    private final Map<String, String> defaultParameters;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String status;

    private FeatureTransformation(BuilderImpl builder) {
        this.name = builder.name;
        this.featureTransformationArn = builder.featureTransformationArn;
        this.defaultParameters = builder.defaultParameters;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the feature transformation.
     * </p>
     * 
     * @return The name of the feature transformation.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the FeatureTransformation object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the FeatureTransformation object.
     */
    public String featureTransformationArn() {
        return featureTransformationArn;
    }

    /**
     * Returns true if the DefaultParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDefaultParameters() {
        return defaultParameters != null && !(defaultParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Provides the default parameters for feature transformation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the default parameters for feature transformation.
     */
    public Map<String, String> defaultParameters() {
        return defaultParameters;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the feature transformation.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the feature transformation.
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The last update date and time (in Unix time) of the feature transformation.
     * </p>
     * 
     * @return The last update date and time (in Unix time) of the feature transformation.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The status of the feature transformation.
     * </p>
     * <p>
     * A feature transformation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the feature transformation.</p>
     *         <p>
     *         A feature transformation can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(featureTransformationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultParameters() ? defaultParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureTransformation)) {
            return false;
        }
        FeatureTransformation other = (FeatureTransformation) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(featureTransformationArn(), other.featureTransformationArn())
                && hasDefaultParameters() == other.hasDefaultParameters()
                && Objects.equals(defaultParameters(), other.defaultParameters())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FeatureTransformation").add("Name", name())
                .add("FeatureTransformationArn", featureTransformationArn())
                .add("DefaultParameters", hasDefaultParameters() ? defaultParameters() : null)
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "featureTransformationArn":
            return Optional.ofNullable(clazz.cast(featureTransformationArn()));
        case "defaultParameters":
            return Optional.ofNullable(clazz.cast(defaultParameters()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureTransformation, T> g) {
        return obj -> g.apply((FeatureTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeatureTransformation> {
        /**
         * <p>
         * The name of the feature transformation.
         * </p>
         * 
         * @param name
         *        The name of the feature transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the FeatureTransformation object.
         * </p>
         * 
         * @param featureTransformationArn
         *        The Amazon Resource Name (ARN) of the FeatureTransformation object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTransformationArn(String featureTransformationArn);

        /**
         * <p>
         * Provides the default parameters for feature transformation.
         * </p>
         * 
         * @param defaultParameters
         *        Provides the default parameters for feature transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultParameters(Map<String, String> defaultParameters);

        /**
         * <p>
         * The creation date and time (in Unix time) of the feature transformation.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the feature transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The last update date and time (in Unix time) of the feature transformation.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The last update date and time (in Unix time) of the feature transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The status of the feature transformation.
         * </p>
         * <p>
         * A feature transformation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the feature transformation.</p>
         *        <p>
         *        A feature transformation can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String featureTransformationArn;

        private Map<String, String> defaultParameters = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureTransformation model) {
            name(model.name);
            featureTransformationArn(model.featureTransformationArn);
            defaultParameters(model.defaultParameters);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFeatureTransformationArn() {
            return featureTransformationArn;
        }

        @Override
        public final Builder featureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
            return this;
        }

        public final void setFeatureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
        }

        public final Map<String, String> getDefaultParameters() {
            if (defaultParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return defaultParameters;
        }

        @Override
        public final Builder defaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = FeaturizationParametersCopier.copy(defaultParameters);
            return this;
        }

        public final void setDefaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = FeaturizationParametersCopier.copy(defaultParameters);
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public FeatureTransformation build() {
            return new FeatureTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
