/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the hyperparameters and their ranges. Hyperparameters can be categorical, continuous, or integer-valued.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterRanges.Builder, HyperParameterRanges> {
    private static final SdkField<List<IntegerHyperParameterRange>> INTEGER_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<IntegerHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("integerHyperParameterRanges")
            .getter(getter(HyperParameterRanges::integerHyperParameterRanges))
            .setter(setter(Builder::integerHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContinuousHyperParameterRange>> CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<ContinuousHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("continuousHyperParameterRanges")
            .getter(getter(HyperParameterRanges::continuousHyperParameterRanges))
            .setter(setter(Builder::continuousHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContinuousHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContinuousHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CategoricalHyperParameterRange>> CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<CategoricalHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("categoricalHyperParameterRanges")
            .getter(getter(HyperParameterRanges::categoricalHyperParameterRanges))
            .setter(setter(Builder::categoricalHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoricalHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoricalHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoricalHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_HYPER_PARAMETER_RANGES_FIELD, CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD,
            CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IntegerHyperParameterRange> integerHyperParameterRanges;

    private final List<ContinuousHyperParameterRange> continuousHyperParameterRanges;

    private final List<CategoricalHyperParameterRange> categoricalHyperParameterRanges;

    private HyperParameterRanges(BuilderImpl builder) {
        this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
        this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
        this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
    }

    /**
     * Returns true if the IntegerHyperParameterRanges property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasIntegerHyperParameterRanges() {
        return integerHyperParameterRanges != null && !(integerHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The integer-valued hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntegerHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The integer-valued hyperparameters and their ranges.
     */
    public List<IntegerHyperParameterRange> integerHyperParameterRanges() {
        return integerHyperParameterRanges;
    }

    /**
     * Returns true if the ContinuousHyperParameterRanges property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasContinuousHyperParameterRanges() {
        return continuousHyperParameterRanges != null && !(continuousHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The continuous hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContinuousHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The continuous hyperparameters and their ranges.
     */
    public List<ContinuousHyperParameterRange> continuousHyperParameterRanges() {
        return continuousHyperParameterRanges;
    }

    /**
     * Returns true if the CategoricalHyperParameterRanges property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCategoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges != null && !(categoricalHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categorical hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCategoricalHyperParameterRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The categorical hyperparameters and their ranges.
     */
    public List<CategoricalHyperParameterRange> categoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterRanges)) {
            return false;
        }
        HyperParameterRanges other = (HyperParameterRanges) obj;
        return hasIntegerHyperParameterRanges() == other.hasIntegerHyperParameterRanges()
                && Objects.equals(integerHyperParameterRanges(), other.integerHyperParameterRanges())
                && hasContinuousHyperParameterRanges() == other.hasContinuousHyperParameterRanges()
                && Objects.equals(continuousHyperParameterRanges(), other.continuousHyperParameterRanges())
                && hasCategoricalHyperParameterRanges() == other.hasCategoricalHyperParameterRanges()
                && Objects.equals(categoricalHyperParameterRanges(), other.categoricalHyperParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("HyperParameterRanges")
                .add("IntegerHyperParameterRanges", hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null)
                .add("ContinuousHyperParameterRanges",
                        hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null)
                .add("CategoricalHyperParameterRanges",
                        hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(integerHyperParameterRanges()));
        case "continuousHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousHyperParameterRanges()));
        case "categoricalHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalHyperParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterRanges, T> g) {
        return obj -> g.apply((HyperParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterRanges> {
        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(IntegerHyperParameterRange... integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntegerHyperParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<IntegerHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegerHyperParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #integerHyperParameterRanges(List<IntegerHyperParameterRange>)}.
         * 
         * @param integerHyperParameterRanges
         *        a consumer that will call methods on {@link List<IntegerHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerHyperParameterRanges(List<IntegerHyperParameterRange>)
         */
        Builder integerHyperParameterRanges(Consumer<IntegerHyperParameterRange.Builder>... integerHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(Collection<ContinuousHyperParameterRange> continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(ContinuousHyperParameterRange... continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContinuousHyperParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<ContinuousHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContinuousHyperParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #continuousHyperParameterRanges(List<ContinuousHyperParameterRange>)}.
         * 
         * @param continuousHyperParameterRanges
         *        a consumer that will call methods on {@link List<ContinuousHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousHyperParameterRanges(List<ContinuousHyperParameterRange>)
         */
        Builder continuousHyperParameterRanges(Consumer<ContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(Collection<CategoricalHyperParameterRange> categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange... categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CategoricalHyperParameterRange>.Builder}
         * avoiding the need to create one manually via {@link List<CategoricalHyperParameterRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CategoricalHyperParameterRange>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #categoricalHyperParameterRanges(List<CategoricalHyperParameterRange>)}.
         * 
         * @param categoricalHyperParameterRanges
         *        a consumer that will call methods on {@link List<CategoricalHyperParameterRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalHyperParameterRanges(List<CategoricalHyperParameterRange>)
         */
        Builder categoricalHyperParameterRanges(
                Consumer<CategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<IntegerHyperParameterRange> integerHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<ContinuousHyperParameterRange> continuousHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<CategoricalHyperParameterRange> categoricalHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterRanges model) {
            integerHyperParameterRanges(model.integerHyperParameterRanges);
            continuousHyperParameterRanges(model.continuousHyperParameterRanges);
            categoricalHyperParameterRanges(model.categoricalHyperParameterRanges);
        }

        public final Collection<IntegerHyperParameterRange.Builder> getIntegerHyperParameterRanges() {
            if (integerHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return integerHyperParameterRanges != null ? integerHyperParameterRanges.stream()
                    .map(IntegerHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copy(integerHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(IntegerHyperParameterRange... integerHyperParameterRanges) {
            integerHyperParameterRanges(Arrays.asList(integerHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(
                Consumer<IntegerHyperParameterRange.Builder>... integerHyperParameterRanges) {
            integerHyperParameterRanges(Stream.of(integerHyperParameterRanges)
                    .map(c -> IntegerHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerHyperParameterRanges(
                Collection<IntegerHyperParameterRange.BuilderImpl> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copyFromBuilder(integerHyperParameterRanges);
        }

        public final Collection<ContinuousHyperParameterRange.Builder> getContinuousHyperParameterRanges() {
            if (continuousHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return continuousHyperParameterRanges != null ? continuousHyperParameterRanges.stream()
                    .map(ContinuousHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder continuousHyperParameterRanges(
                Collection<ContinuousHyperParameterRange> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier.copy(continuousHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(ContinuousHyperParameterRange... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Arrays.asList(continuousHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                Consumer<ContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Stream.of(continuousHyperParameterRanges)
                    .map(c -> ContinuousHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContinuousHyperParameterRanges(
                Collection<ContinuousHyperParameterRange.BuilderImpl> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier
                    .copyFromBuilder(continuousHyperParameterRanges);
        }

        public final Collection<CategoricalHyperParameterRange.Builder> getCategoricalHyperParameterRanges() {
            if (categoricalHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return categoricalHyperParameterRanges != null ? categoricalHyperParameterRanges.stream()
                    .map(CategoricalHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoricalHyperParameterRanges(
                Collection<CategoricalHyperParameterRange> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier.copy(categoricalHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Arrays.asList(categoricalHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                Consumer<CategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Stream.of(categoricalHyperParameterRanges)
                    .map(c -> CategoricalHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategoricalHyperParameterRanges(
                Collection<CategoricalHyperParameterRange.BuilderImpl> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier
                    .copyFromBuilder(categoricalHyperParameterRanges);
        }

        @Override
        public HyperParameterRanges build() {
            return new HyperParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
