/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetSchema> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DatasetSchema.getter(DatasetSchema::name)).setter(DatasetSchema.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaArn").getter(DatasetSchema.getter(DatasetSchema::schemaArn)).setter(DatasetSchema.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(DatasetSchema.getter(DatasetSchema::schema)).setter(DatasetSchema.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DatasetSchema.getter(DatasetSchema::creationDateTime)).setter(DatasetSchema.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DatasetSchema.getter(DatasetSchema::lastUpdatedDateTime)).setter(DatasetSchema.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEMA_ARN_FIELD, SCHEMA_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String schemaArn;
    private final String schema;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private DatasetSchema(BuilderImpl builder) {
        this.name = builder.name;
        this.schemaArn = builder.schemaArn;
        this.schema = builder.schema;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public String name() {
        return this.name;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String schema() {
        return this.schema;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSchema)) {
            return false;
        }
        DatasetSchema other = (DatasetSchema)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public String toString() {
        return ToString.builder((String)"DatasetSchema").add("Name", (Object)this.name()).add("SchemaArn", (Object)this.schemaArn()).add("Schema", (Object)this.schema()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "schemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSchema, T> g) {
        return obj -> g.apply((DatasetSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String schemaArn;
        private String schema;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSchema model) {
            this.name(model.name);
            this.schemaArn(model.schemaArn);
            this.schema(model.schema);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public DatasetSchema build() {
            return new DatasetSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetSchema> {
        public Builder name(String var1);

        public Builder schemaArn(String var1);

        public Builder schema(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

