/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A truncated version of the <a>BatchInferenceJob</a> datatype. The <a>ListBatchInferenceJobs</a> operation returns a
 * list of batch inference job summaries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchInferenceJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchInferenceJobSummary.Builder, BatchInferenceJobSummary> {
    private static final SdkField<String> BATCH_INFERENCE_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchInferenceJobArn").getter(getter(BatchInferenceJobSummary::batchInferenceJobArn))
            .setter(setter(Builder::batchInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobArn").build())
            .build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(BatchInferenceJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchInferenceJobSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BatchInferenceJobSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BatchInferenceJobSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(BatchInferenceJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(BatchInferenceJobSummary::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_INFERENCE_JOB_ARN_FIELD,
            JOB_NAME_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD,
            SOLUTION_VERSION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String batchInferenceJobArn;

    private final String jobName;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private final String solutionVersionArn;

    private BatchInferenceJobSummary(BuilderImpl builder) {
        this.batchInferenceJobArn = builder.batchInferenceJobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
        this.solutionVersionArn = builder.solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch inference job.
     */
    public String batchInferenceJobArn() {
        return batchInferenceJobArn;
    }

    /**
     * <p>
     * The name of the batch inference job.
     * </p>
     * 
     * @return The name of the batch inference job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the batch inference job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the batch inference job. The status is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The time at which the batch inference job was created.
     * </p>
     * 
     * @return The time at which the batch inference job was created.
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The time at which the batch inference job was last updated.
     * </p>
     * 
     * @return The time at which the batch inference job was last updated.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If the batch inference job failed, the reason for the failure.
     * </p>
     * 
     * @return If the batch inference job failed, the reason for the failure.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ARN of the solution version used by the batch inference job.
     * </p>
     * 
     * @return The ARN of the solution version used by the batch inference job.
     */
    public String solutionVersionArn() {
        return solutionVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobSummary)) {
            return false;
        }
        BatchInferenceJobSummary other = (BatchInferenceJobSummary) obj;
        return Objects.equals(batchInferenceJobArn(), other.batchInferenceJobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(solutionVersionArn(), other.solutionVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchInferenceJobSummary").add("BatchInferenceJobArn", batchInferenceJobArn())
                .add("JobName", jobName()).add("Status", status()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("FailureReason", failureReason())
                .add("SolutionVersionArn", solutionVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchInferenceJobArn":
            return Optional.ofNullable(clazz.cast(batchInferenceJobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobSummary, T> g) {
        return obj -> g.apply((BatchInferenceJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchInferenceJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch inference job.
         * </p>
         * 
         * @param batchInferenceJobArn
         *        The Amazon Resource Name (ARN) of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobArn(String batchInferenceJobArn);

        /**
         * <p>
         * The name of the batch inference job.
         * </p>
         * 
         * @param jobName
         *        The name of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the batch inference job. The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * IN PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the batch inference job. The status is one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The time at which the batch inference job was created.
         * </p>
         * 
         * @param creationDateTime
         *        The time at which the batch inference job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The time at which the batch inference job was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The time at which the batch inference job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If the batch inference job failed, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If the batch inference job failed, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ARN of the solution version used by the batch inference job.
         * </p>
         * 
         * @param solutionVersionArn
         *        The ARN of the solution version used by the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);
    }

    static final class BuilderImpl implements Builder {
        private String batchInferenceJobArn;

        private String jobName;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private String solutionVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobSummary model) {
            batchInferenceJobArn(model.batchInferenceJobArn);
            jobName(model.jobName);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
            solutionVersionArn(model.solutionVersionArn);
        }

        public final String getBatchInferenceJobArn() {
            return batchInferenceJobArn;
        }

        @Override
        public final Builder batchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
            return this;
        }

        public final void setBatchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public BatchInferenceJobSummary build() {
            return new BatchInferenceJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
