/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCampaignRequest extends PersonalizeRequest implements
        ToCopyableBuilder<DeleteCampaignRequest.Builder, DeleteCampaignRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(DeleteCampaignRequest::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD));

    private final String campaignArn;

    private DeleteCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign to delete.
     */
    public String campaignArn() {
        return campaignArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCampaignRequest)) {
            return false;
        }
        DeleteCampaignRequest other = (DeleteCampaignRequest) obj;
        return Objects.equals(campaignArn(), other.campaignArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteCampaignRequest").add("CampaignArn", campaignArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCampaignRequest, T> g) {
        return obj -> g.apply((DeleteCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCampaignRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign to delete.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String campaignArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCampaignRequest model) {
            super(model);
            campaignArn(model.campaignArn);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCampaignRequest build() {
            return new DeleteCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
