/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSolutionVersionResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeSolutionVersionResponse.Builder, DescribeSolutionVersionResponse> {
    private static final SdkField<SolutionVersion> SOLUTION_VERSION_FIELD = SdkField
            .<SolutionVersion> builder(MarshallingType.SDK_POJO).memberName("solutionVersion")
            .getter(getter(DescribeSolutionVersionResponse::solutionVersion)).setter(setter(Builder::solutionVersion))
            .constructor(SolutionVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_FIELD));

    private final SolutionVersion solutionVersion;

    private DescribeSolutionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.solutionVersion = builder.solutionVersion;
    }

    /**
     * <p>
     * The solution version.
     * </p>
     * 
     * @return The solution version.
     */
    public SolutionVersion solutionVersion() {
        return solutionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSolutionVersionResponse)) {
            return false;
        }
        DescribeSolutionVersionResponse other = (DescribeSolutionVersionResponse) obj;
        return Objects.equals(solutionVersion(), other.solutionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSolutionVersionResponse").add("SolutionVersion", solutionVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionVersion":
            return Optional.ofNullable(clazz.cast(solutionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSolutionVersionResponse, T> g) {
        return obj -> g.apply((DescribeSolutionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSolutionVersionResponse> {
        /**
         * <p>
         * The solution version.
         * </p>
         * 
         * @param solutionVersion
         *        The solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersion(SolutionVersion solutionVersion);

        /**
         * <p>
         * The solution version.
         * </p>
         * This is a convenience that creates an instance of the {@link SolutionVersion.Builder} avoiding the need to
         * create one manually via {@link SolutionVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link SolutionVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #solutionVersion(SolutionVersion)}.
         * 
         * @param solutionVersion
         *        a consumer that will call methods on {@link SolutionVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionVersion(SolutionVersion)
         */
        default Builder solutionVersion(Consumer<SolutionVersion.Builder> solutionVersion) {
            return solutionVersion(SolutionVersion.builder().applyMutation(solutionVersion).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private SolutionVersion solutionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSolutionVersionResponse model) {
            super(model);
            solutionVersion(model.solutionVersion);
        }

        public final SolutionVersion.Builder getSolutionVersion() {
            return solutionVersion != null ? solutionVersion.toBuilder() : null;
        }

        @Override
        public final Builder solutionVersion(SolutionVersion solutionVersion) {
            this.solutionVersion = solutionVersion;
            return this;
        }

        public final void setSolutionVersion(SolutionVersion.BuilderImpl solutionVersion) {
            this.solutionVersion = solutionVersion != null ? solutionVersion.build() : null;
        }

        @Override
        public DescribeSolutionVersionResponse build() {
            return new DescribeSolutionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
