/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCampaignsResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListCampaignsResponse.Builder, ListCampaignsResponse> {
    private static final SdkField<List<CampaignSummary>> CAMPAIGNS_FIELD = SdkField
            .<List<CampaignSummary>> builder(MarshallingType.LIST)
            .memberName("campaigns")
            .getter(getter(ListCampaignsResponse::campaigns))
            .setter(setter(Builder::campaigns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaigns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CampaignSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CampaignSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCampaignsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CampaignSummary> campaigns;

    private final String nextToken;

    private ListCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.campaigns = builder.campaigns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Campaigns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCampaigns() {
        return campaigns != null && !(campaigns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the campaigns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCampaigns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the campaigns.
     */
    public List<CampaignSummary> campaigns() {
        return campaigns;
    }

    /**
     * <p>
     * A token for getting the next set of campaigns (if they exist).
     * </p>
     * 
     * @return A token for getting the next set of campaigns (if they exist).
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCampaigns() ? campaigns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsResponse)) {
            return false;
        }
        ListCampaignsResponse other = (ListCampaignsResponse) obj;
        return hasCampaigns() == other.hasCampaigns() && Objects.equals(campaigns(), other.campaigns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCampaignsResponse").add("Campaigns", hasCampaigns() ? campaigns() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaigns":
            return Optional.ofNullable(clazz.cast(campaigns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsResponse, T> g) {
        return obj -> g.apply((ListCampaignsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCampaignsResponse> {
        /**
         * <p>
         * A list of the campaigns.
         * </p>
         * 
         * @param campaigns
         *        A list of the campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaigns(Collection<CampaignSummary> campaigns);

        /**
         * <p>
         * A list of the campaigns.
         * </p>
         * 
         * @param campaigns
         *        A list of the campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaigns(CampaignSummary... campaigns);

        /**
         * <p>
         * A list of the campaigns.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CampaignSummary>.Builder} avoiding the need
         * to create one manually via {@link List<CampaignSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CampaignSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #campaigns(List<CampaignSummary>)}.
         * 
         * @param campaigns
         *        a consumer that will call methods on {@link List<CampaignSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaigns(List<CampaignSummary>)
         */
        Builder campaigns(Consumer<CampaignSummary.Builder>... campaigns);

        /**
         * <p>
         * A token for getting the next set of campaigns (if they exist).
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of campaigns (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<CampaignSummary> campaigns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsResponse model) {
            super(model);
            campaigns(model.campaigns);
            nextToken(model.nextToken);
        }

        public final Collection<CampaignSummary.Builder> getCampaigns() {
            if (campaigns instanceof SdkAutoConstructList) {
                return null;
            }
            return campaigns != null ? campaigns.stream().map(CampaignSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder campaigns(Collection<CampaignSummary> campaigns) {
            this.campaigns = CampaignsCopier.copy(campaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(CampaignSummary... campaigns) {
            campaigns(Arrays.asList(campaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(Consumer<CampaignSummary.Builder>... campaigns) {
            campaigns(Stream.of(campaigns).map(c -> CampaignSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCampaigns(Collection<CampaignSummary.BuilderImpl> campaigns) {
            this.campaigns = CampaignsCopier.copyFromBuilder(campaigns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCampaignsResponse build() {
            return new ListCampaignsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
