/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If hyperparameter optimization (HPO) was performed, contains the hyperparameter values of the best performing model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TunedHPOParams implements SdkPojo, Serializable, ToCopyableBuilder<TunedHPOParams.Builder, TunedHPOParams> {
    private static final SdkField<Map<String, String>> ALGORITHM_HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("algorithmHyperParameters")
            .getter(getter(TunedHPOParams::algorithmHyperParameters))
            .setter(setter(Builder::algorithmHyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALGORITHM_HYPER_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> algorithmHyperParameters;

    private TunedHPOParams(BuilderImpl builder) {
        this.algorithmHyperParameters = builder.algorithmHyperParameters;
    }

    /**
     * Returns true if the AlgorithmHyperParameters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAlgorithmHyperParameters() {
        return algorithmHyperParameters != null && !(algorithmHyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the hyperparameter values of the best performing model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlgorithmHyperParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the hyperparameter values of the best performing model.
     */
    public Map<String, String> algorithmHyperParameters() {
        return algorithmHyperParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlgorithmHyperParameters() ? algorithmHyperParameters() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunedHPOParams)) {
            return false;
        }
        TunedHPOParams other = (TunedHPOParams) obj;
        return hasAlgorithmHyperParameters() == other.hasAlgorithmHyperParameters()
                && Objects.equals(algorithmHyperParameters(), other.algorithmHyperParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TunedHPOParams")
                .add("AlgorithmHyperParameters", hasAlgorithmHyperParameters() ? algorithmHyperParameters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "algorithmHyperParameters":
            return Optional.ofNullable(clazz.cast(algorithmHyperParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunedHPOParams, T> g) {
        return obj -> g.apply((TunedHPOParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TunedHPOParams> {
        /**
         * <p>
         * A list of the hyperparameter values of the best performing model.
         * </p>
         * 
         * @param algorithmHyperParameters
         *        A list of the hyperparameter values of the best performing model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> algorithmHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TunedHPOParams model) {
            algorithmHyperParameters(model.algorithmHyperParameters);
        }

        public final Map<String, String> getAlgorithmHyperParameters() {
            if (algorithmHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return algorithmHyperParameters;
        }

        @Override
        public final Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
            return this;
        }

        public final void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
        }

        @Override
        public TunedHPOParams build() {
            return new TunedHPOParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
