/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a campaign. For a complete listing, call the <a>DescribeCampaign</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignSummary implements SdkPojo, Serializable, ToCopyableBuilder<CampaignSummary.Builder, CampaignSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CampaignSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(CampaignSummary::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CampaignSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CampaignSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(CampaignSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(CampaignSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CAMPAIGN_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String campaignArn;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private CampaignSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.campaignArn = builder.campaignArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the campaign.
     * </p>
     * 
     * @return The name of the campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign.
     */
    public final String campaignArn() {
        return campaignArn;
    }

    /**
     * <p>
     * The status of the campaign.
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the campaign.</p>
     *         <p>
     *         A campaign can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the campaign was created.
     * </p>
     * 
     * @return The date and time (in Unix time) that the campaign was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the campaign was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the campaign was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a campaign fails, the reason behind the failure.
     * </p>
     * 
     * @return If a campaign fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSummary)) {
            return false;
        }
        CampaignSummary other = (CampaignSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(campaignArn(), other.campaignArn())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignSummary").add("Name", name()).add("CampaignArn", campaignArn()).add("Status", status())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignSummary, T> g) {
        return obj -> g.apply((CampaignSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignSummary> {
        /**
         * <p>
         * The name of the campaign.
         * </p>
         * 
         * @param name
         *        The name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * The status of the campaign.
         * </p>
         * <p>
         * A campaign can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the campaign.</p>
         *        <p>
         *        A campaign can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time (in Unix time) that the campaign was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix time) that the campaign was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the campaign was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the campaign was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a campaign fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a campaign fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String campaignArn;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSummary model) {
            name(model.name);
            campaignArn(model.campaignArn);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public CampaignSummary build() {
            return new CampaignSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
