/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeatureTransformationResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeFeatureTransformationResponse.Builder, DescribeFeatureTransformationResponse> {
    private static final SdkField<FeatureTransformation> FEATURE_TRANSFORMATION_FIELD = SdkField
            .<FeatureTransformation> builder(MarshallingType.SDK_POJO).memberName("featureTransformation")
            .getter(getter(DescribeFeatureTransformationResponse::featureTransformation))
            .setter(setter(Builder::featureTransformation)).constructor(FeatureTransformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_TRANSFORMATION_FIELD));

    private final FeatureTransformation featureTransformation;

    private DescribeFeatureTransformationResponse(BuilderImpl builder) {
        super(builder);
        this.featureTransformation = builder.featureTransformation;
    }

    /**
     * <p>
     * A listing of the FeatureTransformation properties.
     * </p>
     * 
     * @return A listing of the FeatureTransformation properties.
     */
    public final FeatureTransformation featureTransformation() {
        return featureTransformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureTransformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureTransformationResponse)) {
            return false;
        }
        DescribeFeatureTransformationResponse other = (DescribeFeatureTransformationResponse) obj;
        return Objects.equals(featureTransformation(), other.featureTransformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFeatureTransformationResponse").add("FeatureTransformation", featureTransformation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "featureTransformation":
            return Optional.ofNullable(clazz.cast(featureTransformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureTransformationResponse, T> g) {
        return obj -> g.apply((DescribeFeatureTransformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFeatureTransformationResponse> {
        /**
         * <p>
         * A listing of the FeatureTransformation properties.
         * </p>
         * 
         * @param featureTransformation
         *        A listing of the FeatureTransformation properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTransformation(FeatureTransformation featureTransformation);

        /**
         * <p>
         * A listing of the FeatureTransformation properties.
         * </p>
         * This is a convenience that creates an instance of the {@link FeatureTransformation.Builder} avoiding the need
         * to create one manually via {@link FeatureTransformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FeatureTransformation.Builder#build()} is called immediately and
         * its result is passed to {@link #featureTransformation(FeatureTransformation)}.
         * 
         * @param featureTransformation
         *        a consumer that will call methods on {@link FeatureTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureTransformation(FeatureTransformation)
         */
        default Builder featureTransformation(Consumer<FeatureTransformation.Builder> featureTransformation) {
            return featureTransformation(FeatureTransformation.builder().applyMutation(featureTransformation).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private FeatureTransformation featureTransformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureTransformationResponse model) {
            super(model);
            featureTransformation(model.featureTransformation);
        }

        public final FeatureTransformation.Builder getFeatureTransformation() {
            return featureTransformation != null ? featureTransformation.toBuilder() : null;
        }

        @Override
        public final Builder featureTransformation(FeatureTransformation featureTransformation) {
            this.featureTransformation = featureTransformation;
            return this;
        }

        public final void setFeatureTransformation(FeatureTransformation.BuilderImpl featureTransformation) {
            this.featureTransformation = featureTransformation != null ? featureTransformation.build() : null;
        }

        @Override
        public DescribeFeatureTransformationResponse build() {
            return new DescribeFeatureTransformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
