/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCampaignRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateCampaignRequest.Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(CreateCampaignRequest::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minProvisionedTPS").getter(getter(CreateCampaignRequest::minProvisionedTPS))
            .setter(setter(Builder::minProvisionedTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()).build();

    private static final SdkField<CampaignConfig> CAMPAIGN_CONFIG_FIELD = SdkField
            .<CampaignConfig> builder(MarshallingType.SDK_POJO).memberName("campaignConfig")
            .getter(getter(CreateCampaignRequest::campaignConfig)).setter(setter(Builder::campaignConfig))
            .constructor(CampaignConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD, CAMPAIGN_CONFIG_FIELD));

    private final String name;

    private final String solutionVersionArn;

    private final Integer minProvisionedTPS;

    private final CampaignConfig campaignConfig;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
        this.campaignConfig = builder.campaignConfig;
    }

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     * 
     * @return A name for the new campaign. The campaign name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version to deploy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version to deploy.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support.
     * </p>
     * 
     * @return Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
     *         Personalize will support.
     */
    public final Integer minProvisionedTPS() {
        return minProvisionedTPS;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @return The configuration details of a campaign.
     */
    public final CampaignConfig campaignConfig() {
        return campaignConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(minProvisionedTPS());
        hashCode = 31 * hashCode + Objects.hashCode(campaignConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(minProvisionedTPS(), other.minProvisionedTPS())
                && Objects.equals(campaignConfig(), other.campaignConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCampaignRequest").add("Name", name()).add("SolutionVersionArn", solutionVersionArn())
                .add("MinProvisionedTPS", minProvisionedTPS()).add("CampaignConfig", campaignConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "minProvisionedTPS":
            return Optional.ofNullable(clazz.cast(minProvisionedTPS()));
        case "campaignConfig":
            return Optional.ofNullable(clazz.cast(campaignConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCampaignRequest> {
        /**
         * <p>
         * A name for the new campaign. The campaign name must be unique within your account.
         * </p>
         * 
         * @param name
         *        A name for the new campaign. The campaign name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version to deploy.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
         * will support.
         * </p>
         * 
         * @param minProvisionedTPS
         *        Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
         *        Personalize will support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minProvisionedTPS(Integer minProvisionedTPS);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * 
         * @param campaignConfig
         *        The configuration details of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignConfig(CampaignConfig campaignConfig);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignConfig.Builder} avoiding the need to
         * create one manually via {@link CampaignConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignConfig(CampaignConfig)}.
         * 
         * @param campaignConfig
         *        a consumer that will call methods on {@link CampaignConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignConfig(CampaignConfig)
         */
        default Builder campaignConfig(Consumer<CampaignConfig.Builder> campaignConfig) {
            return campaignConfig(CampaignConfig.builder().applyMutation(campaignConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String solutionVersionArn;

        private Integer minProvisionedTPS;

        private CampaignConfig campaignConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            name(model.name);
            solutionVersionArn(model.solutionVersionArn);
            minProvisionedTPS(model.minProvisionedTPS);
            campaignConfig(model.campaignConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final Integer getMinProvisionedTPS() {
            return minProvisionedTPS;
        }

        @Override
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        public final CampaignConfig.Builder getCampaignConfig() {
            return campaignConfig != null ? campaignConfig.toBuilder() : null;
        }

        @Override
        public final Builder campaignConfig(CampaignConfig campaignConfig) {
            this.campaignConfig = campaignConfig;
            return this;
        }

        public final void setCampaignConfig(CampaignConfig.BuilderImpl campaignConfig) {
            this.campaignConfig = campaignConfig != null ? campaignConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
