/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a job that exports a dataset to an Amazon S3 bucket. For more information, see
 * <a>CreateDatasetExportJob</a>.
 * </p>
 * <p>
 * A dataset export job can be in one of the following states:
 * </p>
 * <ul>
 * <li>
 * <p>
 * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetExportJob implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetExportJob.Builder, DatasetExportJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DatasetExportJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DATASET_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetExportJobArn").getter(getter(DatasetExportJob::datasetExportJobArn))
            .setter(setter(Builder::datasetExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetExportJobArn").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(DatasetExportJob::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<String> INGESTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionMode").getter(getter(DatasetExportJob::ingestionModeAsString))
            .setter(setter(Builder::ingestionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionMode").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DatasetExportJob::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DatasetExportJob::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DatasetExportJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<DatasetExportJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(DatasetExportJob::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(DatasetExportJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DatasetExportJob::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DatasetExportJob::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DatasetExportJob::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            DATASET_EXPORT_JOB_ARN_FIELD, DATASET_ARN_FIELD, INGESTION_MODE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD,
            JOB_OUTPUT_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String datasetExportJobArn;

    private final String datasetArn;

    private final String ingestionMode;

    private final String roleArn;

    private final String status;

    private final DatasetExportJobOutput jobOutput;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private DatasetExportJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.datasetExportJobArn = builder.datasetExportJobArn;
        this.datasetArn = builder.datasetArn;
        this.ingestionMode = builder.ingestionMode;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.jobOutput = builder.jobOutput;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the export job.
     * </p>
     * 
     * @return The name of the export job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset export job.
     */
    public final String datasetExportJobArn() {
        return datasetExportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset to export.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you
     * imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console,
     * PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is
     * <code>PUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionMode}
     * will return {@link IngestionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionModeAsString}.
     * </p>
     * 
     * @return The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data
     *         that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally
     *         (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The
     *         default value is <code>PUT</code>.
     * @see IngestionMode
     */
    public final IngestionMode ingestionMode() {
        return IngestionMode.fromValue(ingestionMode);
    }

    /**
     * <p>
     * The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you
     * imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console,
     * PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is
     * <code>PUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionMode}
     * will return {@link IngestionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionModeAsString}.
     * </p>
     * 
     * @return The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data
     *         that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally
     *         (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The
     *         default value is <code>PUT</code>.
     * @see IngestionMode
     */
    public final String ingestionModeAsString() {
        return ingestionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management service role that has permissions to add
     * data to your output Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management service role that has
     *         permissions to add data to your output Amazon S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the dataset export job.
     * </p>
     * <p>
     * A dataset export job can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the dataset export job.</p>
     *         <p>
     *         A dataset export job can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the job's output is stored. For example:
     * </p>
     * <p>
     * <code>s3://bucket-name/folder-name/</code>
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
     *         <p>
     *         <code>s3://bucket-name/folder-name/</code>
     */
    public final DatasetExportJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the dataset export job.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the dataset export job.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) the status of the dataset export job was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) the status of the dataset export job was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a dataset export job fails, provides the reason why.
     * </p>
     * 
     * @return If a dataset export job fails, provides the reason why.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetExportJob)) {
            return false;
        }
        DatasetExportJob other = (DatasetExportJob) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(datasetExportJobArn(), other.datasetExportJobArn())
                && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(ingestionModeAsString(), other.ingestionModeAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(status(), other.status())
                && Objects.equals(jobOutput(), other.jobOutput()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetExportJob").add("JobName", jobName()).add("DatasetExportJobArn", datasetExportJobArn())
                .add("DatasetArn", datasetArn()).add("IngestionMode", ingestionModeAsString()).add("RoleArn", roleArn())
                .add("Status", status()).add("JobOutput", jobOutput()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "datasetExportJobArn":
            return Optional.ofNullable(clazz.cast(datasetExportJobArn()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "ingestionMode":
            return Optional.ofNullable(clazz.cast(ingestionModeAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetExportJob, T> g) {
        return obj -> g.apply((DatasetExportJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetExportJob> {
        /**
         * <p>
         * The name of the export job.
         * </p>
         * 
         * @param jobName
         *        The name of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset export job.
         * </p>
         * 
         * @param datasetExportJobArn
         *        The Amazon Resource Name (ARN) of the dataset export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetExportJobArn(String datasetExportJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset to export.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that
         * you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the
         * console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value
         * is <code>PUT</code>.
         * </p>
         * 
         * @param ingestionMode
         *        The data to export, based on how you imported the data. You can choose to export <code>BULK</code>
         *        data that you imported using a dataset import job, <code>PUT</code> data that you imported
         *        incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
         *        for both types. The default value is <code>PUT</code>.
         * @see IngestionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionMode
         */
        Builder ingestionMode(String ingestionMode);

        /**
         * <p>
         * The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that
         * you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the
         * console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value
         * is <code>PUT</code>.
         * </p>
         * 
         * @param ingestionMode
         *        The data to export, based on how you imported the data. You can choose to export <code>BULK</code>
         *        data that you imported using a dataset import job, <code>PUT</code> data that you imported
         *        incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code>
         *        for both types. The default value is <code>PUT</code>.
         * @see IngestionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionMode
         */
        Builder ingestionMode(IngestionMode ingestionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management service role that has permissions to
         * add data to your output Amazon S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management service role that has
         *        permissions to add data to your output Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the dataset export job.
         * </p>
         * <p>
         * A dataset export job can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dataset export job.</p>
         *        <p>
         *        A dataset export job can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output is stored. For example:
         * </p>
         * <p>
         * <code>s3://bucket-name/folder-name/</code>
         * </p>
         * 
         * @param jobOutput
         *        The path to the Amazon S3 bucket where the job's output is stored. For example:</p>
         *        <p>
         *        <code>s3://bucket-name/folder-name/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(DatasetExportJobOutput jobOutput);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output is stored. For example:
         * </p>
         * <p>
         * <code>s3://bucket-name/folder-name/</code>
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetExportJobOutput.Builder} avoiding the
         * need to create one manually via {@link DatasetExportJobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetExportJobOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobOutput(DatasetExportJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link DatasetExportJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(DatasetExportJobOutput)
         */
        default Builder jobOutput(Consumer<DatasetExportJobOutput.Builder> jobOutput) {
            return jobOutput(DatasetExportJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * The creation date and time (in Unix time) of the dataset export job.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the dataset export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) the status of the dataset export job was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) the status of the dataset export job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a dataset export job fails, provides the reason why.
         * </p>
         * 
         * @param failureReason
         *        If a dataset export job fails, provides the reason why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String datasetExportJobArn;

        private String datasetArn;

        private String ingestionMode;

        private String roleArn;

        private String status;

        private DatasetExportJobOutput jobOutput;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetExportJob model) {
            jobName(model.jobName);
            datasetExportJobArn(model.datasetExportJobArn);
            datasetArn(model.datasetArn);
            ingestionMode(model.ingestionMode);
            roleArn(model.roleArn);
            status(model.status);
            jobOutput(model.jobOutput);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getDatasetExportJobArn() {
            return datasetExportJobArn;
        }

        @Override
        public final Builder datasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
            return this;
        }

        public final void setDatasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final String getIngestionMode() {
            return ingestionMode;
        }

        @Override
        public final Builder ingestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
            return this;
        }

        @Override
        public final Builder ingestionMode(IngestionMode ingestionMode) {
            this.ingestionMode(ingestionMode == null ? null : ingestionMode.toString());
            return this;
        }

        public final void setIngestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final DatasetExportJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        @Override
        public final Builder jobOutput(DatasetExportJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final void setJobOutput(DatasetExportJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public DatasetExportJob build() {
            return new DatasetExportJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
