/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventTrackersResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListEventTrackersResponse.Builder, ListEventTrackersResponse> {
    private static final SdkField<List<EventTrackerSummary>> EVENT_TRACKERS_FIELD = SdkField
            .<List<EventTrackerSummary>> builder(MarshallingType.LIST)
            .memberName("eventTrackers")
            .getter(getter(ListEventTrackersResponse::eventTrackers))
            .setter(setter(Builder::eventTrackers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTrackerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTrackerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEventTrackersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRACKERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventTrackerSummary> eventTrackers;

    private final String nextToken;

    private ListEventTrackersResponse(BuilderImpl builder) {
        super(builder);
        this.eventTrackers = builder.eventTrackers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventTrackers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEventTrackers() {
        return eventTrackers != null && !(eventTrackers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event trackers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTrackers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event trackers.
     */
    public final List<EventTrackerSummary> eventTrackers() {
        return eventTrackers;
    }

    /**
     * <p>
     * A token for getting the next set of event trackers (if they exist).
     * </p>
     * 
     * @return A token for getting the next set of event trackers (if they exist).
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTrackers() ? eventTrackers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventTrackersResponse)) {
            return false;
        }
        ListEventTrackersResponse other = (ListEventTrackersResponse) obj;
        return hasEventTrackers() == other.hasEventTrackers() && Objects.equals(eventTrackers(), other.eventTrackers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventTrackersResponse").add("EventTrackers", hasEventTrackers() ? eventTrackers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTrackers":
            return Optional.ofNullable(clazz.cast(eventTrackers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventTrackersResponse, T> g) {
        return obj -> g.apply((ListEventTrackersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventTrackersResponse> {
        /**
         * <p>
         * A list of event trackers.
         * </p>
         * 
         * @param eventTrackers
         *        A list of event trackers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrackers(Collection<EventTrackerSummary> eventTrackers);

        /**
         * <p>
         * A list of event trackers.
         * </p>
         * 
         * @param eventTrackers
         *        A list of event trackers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrackers(EventTrackerSummary... eventTrackers);

        /**
         * <p>
         * A list of event trackers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTrackerSummary>.Builder} avoiding the
         * need to create one manually via {@link List<EventTrackerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTrackerSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #eventTrackers(List<EventTrackerSummary>)}.
         * 
         * @param eventTrackers
         *        a consumer that will call methods on {@link List<EventTrackerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTrackers(List<EventTrackerSummary>)
         */
        Builder eventTrackers(Consumer<EventTrackerSummary.Builder>... eventTrackers);

        /**
         * <p>
         * A token for getting the next set of event trackers (if they exist).
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of event trackers (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<EventTrackerSummary> eventTrackers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventTrackersResponse model) {
            super(model);
            eventTrackers(model.eventTrackers);
            nextToken(model.nextToken);
        }

        public final List<EventTrackerSummary.Builder> getEventTrackers() {
            List<EventTrackerSummary.Builder> result = EventTrackersCopier.copyToBuilder(this.eventTrackers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder eventTrackers(Collection<EventTrackerSummary> eventTrackers) {
            this.eventTrackers = EventTrackersCopier.copy(eventTrackers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTrackers(EventTrackerSummary... eventTrackers) {
            eventTrackers(Arrays.asList(eventTrackers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTrackers(Consumer<EventTrackerSummary.Builder>... eventTrackers) {
            eventTrackers(Stream.of(eventTrackers).map(c -> EventTrackerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventTrackers(Collection<EventTrackerSummary.BuilderImpl> eventTrackers) {
            this.eventTrackers = EventTrackersCopier.copyFromBuilder(eventTrackers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventTrackersResponse build() {
            return new ListEventTrackersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
