/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the deployment of a solution version. For more information on campaigns, see
 * <a>CreateCampaign</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Campaign implements SdkPojo, Serializable, ToCopyableBuilder<Campaign.Builder, Campaign> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Campaign::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(Campaign::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(Campaign::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minProvisionedTPS").getter(getter(Campaign::minProvisionedTPS))
            .setter(setter(Builder::minProvisionedTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()).build();

    private static final SdkField<CampaignConfig> CAMPAIGN_CONFIG_FIELD = SdkField
            .<CampaignConfig> builder(MarshallingType.SDK_POJO).memberName("campaignConfig")
            .getter(getter(Campaign::campaignConfig)).setter(setter(Builder::campaignConfig))
            .constructor(CampaignConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignConfig").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Campaign::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(Campaign::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(Campaign::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(Campaign::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<CampaignUpdateSummary> LATEST_CAMPAIGN_UPDATE_FIELD = SdkField
            .<CampaignUpdateSummary> builder(MarshallingType.SDK_POJO).memberName("latestCampaignUpdate")
            .getter(getter(Campaign::latestCampaignUpdate)).setter(setter(Builder::latestCampaignUpdate))
            .constructor(CampaignUpdateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestCampaignUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CAMPAIGN_ARN_FIELD, SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD, CAMPAIGN_CONFIG_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LATEST_CAMPAIGN_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String campaignArn;

    private final String solutionVersionArn;

    private final Integer minProvisionedTPS;

    private final CampaignConfig campaignConfig;

    private final String status;

    private final String failureReason;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final CampaignUpdateSummary latestCampaignUpdate;

    private Campaign(BuilderImpl builder) {
        this.name = builder.name;
        this.campaignArn = builder.campaignArn;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
        this.campaignConfig = builder.campaignConfig;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.latestCampaignUpdate = builder.latestCampaignUpdate;
    }

    /**
     * <p>
     * The name of the campaign.
     * </p>
     * 
     * @return The name of the campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign.
     */
    public final String campaignArn() {
        return campaignArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a specific version of the solution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a specific version of the solution.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second.
     * </p>
     * 
     * @return Specifies the requested minimum provisioned transactions (recommendations) per second.
     */
    public final Integer minProvisionedTPS() {
        return minProvisionedTPS;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @return The configuration details of a campaign.
     */
    public final CampaignConfig campaignConfig() {
        return campaignConfig;
    }

    /**
     * <p>
     * The status of the campaign.
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the campaign.</p>
     *         <p>
     *         A campaign can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If a campaign fails, the reason behind the failure.
     * </p>
     * 
     * @return If a campaign fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the campaign was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the campaign was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the campaign was last updated.
     * </p>
     * 
     * @return The date and time (in Unix format) that the campaign was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * Returns the value of the LatestCampaignUpdate property for this object.
     * 
     * @return The value of the LatestCampaignUpdate property for this object.
     */
    public final CampaignUpdateSummary latestCampaignUpdate() {
        return latestCampaignUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(minProvisionedTPS());
        hashCode = 31 * hashCode + Objects.hashCode(campaignConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestCampaignUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Campaign)) {
            return false;
        }
        Campaign other = (Campaign) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(campaignArn(), other.campaignArn())
                && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(minProvisionedTPS(), other.minProvisionedTPS())
                && Objects.equals(campaignConfig(), other.campaignConfig()) && Objects.equals(status(), other.status())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(latestCampaignUpdate(), other.latestCampaignUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Campaign").add("Name", name()).add("CampaignArn", campaignArn())
                .add("SolutionVersionArn", solutionVersionArn()).add("MinProvisionedTPS", minProvisionedTPS())
                .add("CampaignConfig", campaignConfig()).add("Status", status()).add("FailureReason", failureReason())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("LatestCampaignUpdate", latestCampaignUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "minProvisionedTPS":
            return Optional.ofNullable(clazz.cast(minProvisionedTPS()));
        case "campaignConfig":
            return Optional.ofNullable(clazz.cast(campaignConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "latestCampaignUpdate":
            return Optional.ofNullable(clazz.cast(latestCampaignUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Campaign, T> g) {
        return obj -> g.apply((Campaign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Campaign> {
        /**
         * <p>
         * The name of the campaign.
         * </p>
         * 
         * @param name
         *        The name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a specific version of the solution.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of a specific version of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * Specifies the requested minimum provisioned transactions (recommendations) per second.
         * </p>
         * 
         * @param minProvisionedTPS
         *        Specifies the requested minimum provisioned transactions (recommendations) per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minProvisionedTPS(Integer minProvisionedTPS);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * 
         * @param campaignConfig
         *        The configuration details of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignConfig(CampaignConfig campaignConfig);

        /**
         * <p>
         * The configuration details of a campaign.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignConfig.Builder} avoiding the need to
         * create one manually via {@link CampaignConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignConfig(CampaignConfig)}.
         * 
         * @param campaignConfig
         *        a consumer that will call methods on {@link CampaignConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignConfig(CampaignConfig)
         */
        default Builder campaignConfig(Consumer<CampaignConfig.Builder> campaignConfig) {
            return campaignConfig(CampaignConfig.builder().applyMutation(campaignConfig).build());
        }

        /**
         * <p>
         * The status of the campaign.
         * </p>
         * <p>
         * A campaign can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the campaign.</p>
         *        <p>
         *        A campaign can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If a campaign fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a campaign fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date and time (in Unix format) that the campaign was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the campaign was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix format) that the campaign was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix format) that the campaign was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * Sets the value of the LatestCampaignUpdate property for this object.
         *
         * @param latestCampaignUpdate
         *        The new value for the LatestCampaignUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestCampaignUpdate(CampaignUpdateSummary latestCampaignUpdate);

        /**
         * Sets the value of the LatestCampaignUpdate property for this object.
         *
         * This is a convenience that creates an instance of the {@link CampaignUpdateSummary.Builder} avoiding the need
         * to create one manually via {@link CampaignUpdateSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignUpdateSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #latestCampaignUpdate(CampaignUpdateSummary)}.
         * 
         * @param latestCampaignUpdate
         *        a consumer that will call methods on {@link CampaignUpdateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestCampaignUpdate(CampaignUpdateSummary)
         */
        default Builder latestCampaignUpdate(Consumer<CampaignUpdateSummary.Builder> latestCampaignUpdate) {
            return latestCampaignUpdate(CampaignUpdateSummary.builder().applyMutation(latestCampaignUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String campaignArn;

        private String solutionVersionArn;

        private Integer minProvisionedTPS;

        private CampaignConfig campaignConfig;

        private String status;

        private String failureReason;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private CampaignUpdateSummary latestCampaignUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(Campaign model) {
            name(model.name);
            campaignArn(model.campaignArn);
            solutionVersionArn(model.solutionVersionArn);
            minProvisionedTPS(model.minProvisionedTPS);
            campaignConfig(model.campaignConfig);
            status(model.status);
            failureReason(model.failureReason);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            latestCampaignUpdate(model.latestCampaignUpdate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        @Transient
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        @Transient
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getMinProvisionedTPS() {
            return minProvisionedTPS;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        @Override
        @Transient
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final CampaignConfig.Builder getCampaignConfig() {
            return campaignConfig != null ? campaignConfig.toBuilder() : null;
        }

        public final void setCampaignConfig(CampaignConfig.BuilderImpl campaignConfig) {
            this.campaignConfig = campaignConfig != null ? campaignConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder campaignConfig(CampaignConfig campaignConfig) {
            this.campaignConfig = campaignConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final CampaignUpdateSummary.Builder getLatestCampaignUpdate() {
            return latestCampaignUpdate != null ? latestCampaignUpdate.toBuilder() : null;
        }

        public final void setLatestCampaignUpdate(CampaignUpdateSummary.BuilderImpl latestCampaignUpdate) {
            this.latestCampaignUpdate = latestCampaignUpdate != null ? latestCampaignUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder latestCampaignUpdate(CampaignUpdateSummary latestCampaignUpdate) {
            this.latestCampaignUpdate = latestCampaignUpdate;
            return this;
        }

        @Override
        public Campaign build() {
            return new Campaign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
