/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetExportJobRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateDatasetExportJobRequest.Builder, CreateDatasetExportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateDatasetExportJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(CreateDatasetExportJobRequest::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<String> INGESTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionMode").getter(getter(CreateDatasetExportJobRequest::ingestionModeAsString))
            .setter(setter(Builder::ingestionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionMode").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateDatasetExportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DatasetExportJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<DatasetExportJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(CreateDatasetExportJobRequest::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(DatasetExportJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            DATASET_ARN_FIELD, INGESTION_MODE_FIELD, ROLE_ARN_FIELD, JOB_OUTPUT_FIELD));

    private final String jobName;

    private final String datasetArn;

    private final String ingestionMode;

    private final String roleArn;

    private final DatasetExportJobOutput jobOutput;

    private CreateDatasetExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.datasetArn = builder.datasetArn;
        this.ingestionMode = builder.ingestionMode;
        this.roleArn = builder.roleArn;
        this.jobOutput = builder.jobOutput;
    }

    /**
     * <p>
     * The name for the dataset export job.
     * </p>
     * 
     * @return The name for the dataset export job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that contains the data to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that contains the data to export.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that
     * you imported using a dataset import job, only <code>PUT</code> data that you imported incrementally (using the
     * console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is
     * <code>PUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionMode}
     * will return {@link IngestionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionModeAsString}.
     * </p>
     * 
     * @return The data to export, based on how you imported the data. You can choose to export only <code>BULK</code>
     *         data that you imported using a dataset import job, only <code>PUT</code> data that you imported
     *         incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for
     *         both types. The default value is <code>PUT</code>.
     * @see IngestionMode
     */
    public final IngestionMode ingestionMode() {
        return IngestionMode.fromValue(ingestionMode);
    }

    /**
     * <p>
     * The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that
     * you imported using a dataset import job, only <code>PUT</code> data that you imported incrementally (using the
     * console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is
     * <code>PUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestionMode}
     * will return {@link IngestionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ingestionModeAsString}.
     * </p>
     * 
     * @return The data to export, based on how you imported the data. You can choose to export only <code>BULK</code>
     *         data that you imported using a dataset import job, only <code>PUT</code> data that you imported
     *         incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for
     *         both types. The default value is <code>PUT</code>.
     * @see IngestionMode
     */
    public final String ingestionModeAsString() {
        return ingestionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3
     * bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output
     *         Amazon S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the job's output is stored.
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the job's output is stored.
     */
    public final DatasetExportJobOutput jobOutput() {
        return jobOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetExportJobRequest)) {
            return false;
        }
        CreateDatasetExportJobRequest other = (CreateDatasetExportJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(ingestionModeAsString(), other.ingestionModeAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(jobOutput(), other.jobOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetExportJobRequest").add("JobName", jobName()).add("DatasetArn", datasetArn())
                .add("IngestionMode", ingestionModeAsString()).add("RoleArn", roleArn()).add("JobOutput", jobOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "ingestionMode":
            return Optional.ofNullable(clazz.cast(ingestionModeAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetExportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetExportJobRequest> {
        /**
         * <p>
         * The name for the dataset export job.
         * </p>
         * 
         * @param jobName
         *        The name for the dataset export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that contains the data to export.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset that contains the data to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data
         * that you imported using a dataset import job, only <code>PUT</code> data that you imported incrementally
         * (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The
         * default value is <code>PUT</code>.
         * </p>
         * 
         * @param ingestionMode
         *        The data to export, based on how you imported the data. You can choose to export only
         *        <code>BULK</code> data that you imported using a dataset import job, only <code>PUT</code> data that
         *        you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or
         *        <code>ALL</code> for both types. The default value is <code>PUT</code>.
         * @see IngestionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionMode
         */
        Builder ingestionMode(String ingestionMode);

        /**
         * <p>
         * The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data
         * that you imported using a dataset import job, only <code>PUT</code> data that you imported incrementally
         * (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The
         * default value is <code>PUT</code>.
         * </p>
         * 
         * @param ingestionMode
         *        The data to export, based on how you imported the data. You can choose to export only
         *        <code>BULK</code> data that you imported using a dataset import job, only <code>PUT</code> data that
         *        you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or
         *        <code>ALL</code> for both types. The default value is <code>PUT</code>.
         * @see IngestionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionMode
         */
        Builder ingestionMode(IngestionMode ingestionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon
         * S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output
         *        Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output is stored.
         * </p>
         * 
         * @param jobOutput
         *        The path to the Amazon S3 bucket where the job's output is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(DatasetExportJobOutput jobOutput);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetExportJobOutput.Builder} avoiding the
         * need to create one manually via {@link DatasetExportJobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetExportJobOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobOutput(DatasetExportJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link DatasetExportJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(DatasetExportJobOutput)
         */
        default Builder jobOutput(Consumer<DatasetExportJobOutput.Builder> jobOutput) {
            return jobOutput(DatasetExportJobOutput.builder().applyMutation(jobOutput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String jobName;

        private String datasetArn;

        private String ingestionMode;

        private String roleArn;

        private DatasetExportJobOutput jobOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetExportJobRequest model) {
            super(model);
            jobName(model.jobName);
            datasetArn(model.datasetArn);
            ingestionMode(model.ingestionMode);
            roleArn(model.roleArn);
            jobOutput(model.jobOutput);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        @Transient
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getIngestionMode() {
            return ingestionMode;
        }

        public final void setIngestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
        }

        @Override
        @Transient
        public final Builder ingestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder ingestionMode(IngestionMode ingestionMode) {
            this.ingestionMode(ingestionMode == null ? null : ingestionMode.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DatasetExportJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(DatasetExportJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder jobOutput(DatasetExportJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetExportJobRequest build() {
            return new CreateDatasetExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
