/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFilterRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateFilterRequest.Builder, CreateFilterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(CreateFilterRequest::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterExpression").getter(getter(CreateFilterRequest::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATASET_GROUP_ARN_FIELD, FILTER_EXPRESSION_FIELD));

    private final String name;

    private final String datasetGroupArn;

    private final String filterExpression;

    private CreateFilterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.filterExpression = builder.filterExpression;
    }

    /**
     * <p>
     * The name of the filter to create.
     * </p>
     * 
     * @return The name of the filter to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the dataset group that the filter will belong to.
     * </p>
     * 
     * @return The ARN of the dataset group that the filter will belong to.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The filter expression defines which items are included or excluded from recommendations. Filter expression must
     * follow specific format rules. For information about filter expression structure and syntax, see
     * <a>filter-expressions</a>.
     * </p>
     * 
     * @return The filter expression defines which items are included or excluded from recommendations. Filter
     *         expression must follow specific format rules. For information about filter expression structure and
     *         syntax, see <a>filter-expressions</a>.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFilterRequest)) {
            return false;
        }
        CreateFilterRequest other = (CreateFilterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(filterExpression(), other.filterExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFilterRequest").add("Name", name()).add("DatasetGroupArn", datasetGroupArn())
                .add("FilterExpression", filterExpression() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "filterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFilterRequest, T> g) {
        return obj -> g.apply((CreateFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFilterRequest> {
        /**
         * <p>
         * The name of the filter to create.
         * </p>
         * 
         * @param name
         *        The name of the filter to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the dataset group that the filter will belong to.
         * </p>
         * 
         * @param datasetGroupArn
         *        The ARN of the dataset group that the filter will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The filter expression defines which items are included or excluded from recommendations. Filter expression
         * must follow specific format rules. For information about filter expression structure and syntax, see
         * <a>filter-expressions</a>.
         * </p>
         * 
         * @param filterExpression
         *        The filter expression defines which items are included or excluded from recommendations. Filter
         *        expression must follow specific format rules. For information about filter expression structure and
         *        syntax, see <a>filter-expressions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String datasetGroupArn;

        private String filterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFilterRequest model) {
            super(model);
            name(model.name);
            datasetGroupArn(model.datasetGroupArn);
            filterExpression(model.filterExpression);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        @Transient
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFilterRequest build() {
            return new CreateFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
